/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.respawnablepets;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import moriyashiine.respawnablepets.Config;
import moriyashiine.respawnablepets.ExtendedWorld;
import moriyashiine.respawnablepets.RespawnablePets;
import moriyashiine.respawnablepets.Util;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ModEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void toggleRespawn(LivingAttackEvent event) {
        PlayerEntity player;
        Entity attacker;
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && !(entity instanceof PlayerEntity) && (attacker = event.getSource().func_76364_f()) instanceof PlayerEntity && (player = (PlayerEntity)attacker).func_184614_ca().func_77973_b() == RespawnablePets.Registry.etheric_gem) {
            event.setCanceled(true);
            UUID owner = Util.getOwner(entity);
            if (owner != null && owner.equals(player.func_110124_au())) {
                EntityType type = entity.func_200600_R();
                if (((List)Config.INSTANCE.blacklist.get()).contains(Objects.requireNonNull(type.getRegistryName()).toString())) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("respawnablepets.blacklisted", new Object[]{entity.func_145748_c_()}), true);
                } else if (Util.addPet(entity)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("respawnablepets.enable_respawn", new Object[]{entity.func_145748_c_()}), true);
                } else if (Util.removePet(entity)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("respawnablepets.disable_respawn", new Object[]{entity.func_145748_c_()}), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("respawnablepets.not_owner", new Object[]{entity.func_145748_c_()}), true);
            }
        }
    }

    @SubscribeEvent
    public void wakeUp(PlayerWakeUpEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            ExtendedWorld ext = ExtendedWorld.get(world);
            for (int i = ext.pets.size() - 1; i >= 0; --i) {
                LivingEntity entity;
                CompoundNBT tag = ext.pets.get(i);
                if (!tag.func_74779_i("OwnerUUID").equalsIgnoreCase(player.func_110124_au().toString()) || (entity = (LivingEntity)((EntityType)Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.func_74779_i("id"))))).func_200721_a(world)) == null) continue;
                entity.deserializeNBT(tag);
                entity.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, (float)world.field_73012_v.nextInt(360), 0.0f);
                if (!world.func_217376_c((Entity)entity)) continue;
                entity.func_70691_i(Float.MAX_VALUE);
                entity.func_70066_B();
                entity.func_195061_cb();
            }
        }
    }

    @SubscribeEvent
    public void livingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && !(entity instanceof PlayerEntity)) {
            ExtendedWorld ext = ExtendedWorld.get(world);
            UUID owner = Util.getOwner(entity);
            if (owner != null && entity.func_110143_aJ() - event.getAmount() <= 0.0f && ext.containsEntity(entity)) {
                PlayerEntity player;
                event.setCanceled(true);
                Util.removePet(entity);
                Util.addPet(entity);
                entity.func_70106_y();
                if (world.func_82736_K().func_223586_b(GameRules.field_223609_l) && (player = Util.findPlayer(world, owner)) != null) {
                    player.func_145747_a(entity.func_110142_aN().func_151521_b());
                }
            }
        }
    }
}

