/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rotten_creatures;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.rotten_creatures.RottenCreatures;
import net.mcreator.rotten_creatures.RottenCreaturesVariables;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class RottenCreaturesElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public RottenCreaturesElements() {
        sounds.put(new ResourceLocation("rotten_creatures", "entity.freeze.effect"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.freeze.effect")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.cold.death"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.cold.death")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.cold.ambient"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.cold.ambient")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.marshied.hurt"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.marshied.hurt")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.marshied.death"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.marshied.death")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.marshied.ambient"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.marshied.ambient")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.mummy.ambient"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.mummy.ambient")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.mummy.hurt"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.mummy.hurt")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.mummy.death"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.mummy.death")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.eskimo.hurt"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.eskimo.hurt")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.eskimo.ambient"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.eskimo.ambient")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.eskimo.death"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.eskimo.death")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.burned.death"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.burned.death")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.burned.ambient"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.burned.ambient")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.burned.hurt"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.burned.hurt")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.dead_beard.hurt"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.dead_beard.hurt")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.dead_beard.death"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.dead_beard.death")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.hurt"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.hurt")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.ambient"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.ambient")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.death"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.death")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.broke"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.broke")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.electroshock1"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.electroshock1")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.electroshock2"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.electroshock2")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.dead_beard.ambient"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.dead_beard.ambient")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.angry1"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.angry1")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.angry2"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.angry2")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.angry3"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.angry3")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.cold.hurt"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.cold.hurt")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.cure"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.cure")));
        sounds.put(new ResourceLocation("rotten_creatures", "entity.inmortal.dash"), new SoundEvent(new ResourceLocation("rotten_creatures", "entity.inmortal.dash")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("rotten_creatures").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        this.addNetworkMessage(RottenCreaturesVariables.WorldSavedDataSyncMessage.class, RottenCreaturesVariables.WorldSavedDataSyncMessage::buffer, RottenCreaturesVariables.WorldSavedDataSyncMessage::new, RottenCreaturesVariables.WorldSavedDataSyncMessage::handler);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            RottenCreaturesVariables.MapVariables mapdata = RottenCreaturesVariables.MapVariables.get(event.getPlayer().field_70170_p);
            RottenCreaturesVariables.WorldVariables worlddata = RottenCreaturesVariables.WorldVariables.get(event.getPlayer().field_70170_p);
            if (mapdata != null) {
                RottenCreatures.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new RottenCreaturesVariables.WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                RottenCreatures.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new RottenCreaturesVariables.WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        RottenCreaturesVariables.WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.field_72995_K && (worlddata = RottenCreaturesVariables.WorldVariables.get(event.getPlayer().field_70170_p)) != null) {
            RottenCreatures.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new RottenCreaturesVariables.WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        RottenCreatures.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final RottenCreaturesElements elements;
        protected final int sortid;

        public ModElement(RottenCreaturesElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

