/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing;

import com.teamderpy.shouldersurfing.ShoulderCamera;
import com.teamderpy.shouldersurfing.ShoulderSettings;
import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.math.RayTracer;
import com.teamderpy.shouldersurfing.renderer.ShoulderRenderBin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ShoulderEventHandler {
    private static float lastX = 0.0f;
    private static float lastY = 0.0f;
    private static Vec2f delta;
    private static Vec2f translation;

    @SubscribeEvent
    public void renderEvent(TickEvent.RenderTickEvent event) {
        ShoulderRenderBin.skipPlayerRender = false;
        RayTracer.traceFromEyes(1.0f);
        if (ShoulderRenderBin.rayTraceHit != null && Minecraft.func_71410_x().field_71439_g != null) {
            ShoulderRenderBin.rayTraceHit = ShoulderRenderBin.rayTraceHit.func_178788_d(new Vec3d(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v));
        }
    }

    @SubscribeEvent
    public void keyPressed(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71462_r == null && Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            if (ShoulderSettings.KEYBIND_ROTATE_CAMERA_LEFT.func_151470_d()) {
                ShoulderCamera.adjustCameraLeft();
            } else if (ShoulderSettings.KEYBIND_ROTATE_CAMERA_RIGHT.func_151470_d()) {
                ShoulderCamera.adjustCameraRight();
            } else if (ShoulderSettings.KEYBIND_ZOOM_CAMERA_IN.func_151470_d()) {
                ShoulderCamera.adjustCameraIn();
            } else if (ShoulderSettings.KEYBIND_ZOOM_CAMERA_OUT.func_151470_d()) {
                ShoulderCamera.adjustCameraOut();
            } else if (ShoulderSettings.KEYBIND_SWAP_SHOULDER.func_151468_f()) {
                ShoulderCamera.swapShoulder();
            } else {
                return;
            }
            ShoulderSurfing.CONFIG.get("general", "Rotation Offset", (double)ShoulderCamera.SHOULDER_ROTATION_YAW, "Third person camera rotation").set((double)ShoulderCamera.SHOULDER_ROTATION_YAW);
            ShoulderSurfing.CONFIG.get("general", "Zoom Offset", (double)ShoulderCamera.SHOULDER_ZOOM_MOD, "Third person camera zoom").set((double)ShoulderCamera.SHOULDER_ZOOM_MOD);
            ShoulderSurfing.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("shouldersurfing")) {
            boolean ppChanged;
            boolean prev = ShoulderSettings.REPLACE_DEFAULT_3PP;
            ShoulderSurfing.INSTACE.syncConfig();
            boolean bl = ppChanged = ShoulderSettings.REPLACE_DEFAULT_3PP != prev;
            if (ShoulderSettings.REPLACE_DEFAULT_3PP != prev) {
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 3 && ShoulderSettings.REPLACE_DEFAULT_3PP) {
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
                } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && !ShoulderSettings.REPLACE_DEFAULT_3PP) {
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 3;
                }
            }
        }
    }

    @SubscribeEvent
    public void preRenderPlayer(RenderPlayerEvent.Pre event) {
        if (ShoulderRenderBin.skipPlayerRender && event.getEntityPlayer().equals((Object)Minecraft.func_71410_x().field_71439_g) && (event.getRenderer().func_177068_d().field_78735_i != 180.0f || Minecraft.func_71410_x().field_71415_G) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void preRenderCrosshairs(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            boolean translate;
            ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
            int width = resolution.func_78326_a();
            int height = resolution.func_78328_b();
            float scale = (float)resolution.func_78325_e() * ShoulderSurfing.INSTACE.getShadersResmul();
            delta = this.computeDelta(width, height, scale, event.getPartialTicks());
            translation = this.computeTranslation(width, height, scale, delta);
            boolean bl = translate = ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED && Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId();
            if (translate) {
                GlStateManager.func_179109_b((float)ShoulderEventHandler.translation.field_189982_i, (float)ShoulderEventHandler.translation.field_189983_j, (float)0.0f);
            } else {
                lastX = (float)width * scale / 2.0f;
                lastY = (float)height * scale / 2.0f;
            }
            if (ShoulderSettings.OVERRIDE_MOD_CROSSHAIRS && Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179141_d();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
                Minecraft.func_71410_x().field_71456_v.func_184045_a(event.getPartialTicks(), resolution);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                if (event.isCanceled() && ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED && Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
                    this.translateBack();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void postRenderCrosshairs(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED && Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            this.translateBack();
        }
    }

    private void translateBack() {
        lastX += ShoulderEventHandler.delta.field_189982_i;
        lastY += ShoulderEventHandler.delta.field_189983_j;
        GlStateManager.func_179109_b((float)(-ShoulderEventHandler.translation.field_189982_i), (float)(-ShoulderEventHandler.translation.field_189983_j), (float)0.0f);
    }

    private Vec2f computeDelta(int width, int height, float scale, float partial) {
        float deltaX = ((float)width * scale / 2.0f - lastX) * partial;
        float deltaY = ((float)height * scale / 2.0f - lastY) * partial;
        if (ShoulderRenderBin.projectedVector != null) {
            deltaX = (ShoulderRenderBin.projectedVector.x - lastX) * partial;
            deltaY = (ShoulderRenderBin.projectedVector.y - lastY) * partial;
        }
        return new Vec2f(deltaX, deltaY);
    }

    private Vec2f computeTranslation(int width, int height, float scale, Vec2f diff) {
        float crosshairWidth = (lastX + diff.field_189982_i) / scale;
        float crosshairHeight = (lastY + diff.field_189983_j) / scale;
        float translationX = (float)(-width / 2) + crosshairWidth;
        float translationY = (float)(-height / 2) + crosshairHeight;
        return new Vec2f(translationX, translationY);
    }
}

