/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing;

import com.teamderpy.shouldersurfing.ShoulderCamera;
import com.teamderpy.shouldersurfing.ShoulderEventHandler;
import com.teamderpy.shouldersurfing.ShoulderSettings;
import com.teamderpy.shouldersurfing.asm.ShoulderTransformations;
import com.teamderpy.shouldersurfing.compatibility.EnumShaderCompatibility;
import com.teamderpy.shouldersurfing.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.optifine.shaders.Shaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
@IFMLLoadingPlugin.MCVersion(value="1.9")
@Mod(modid="shouldersurfing", name="Shoulder Surfing", acceptedMinecraftVersions="[1.9,)", version="1.16", canBeDeactivated=false, guiFactory="com.teamderpy.shouldersurfing.gui.GuiShoulderSurfingConfigFactory", certificateFingerprint="d6261bb645f41db84c74f98e512c2bb43f188af2")
public class ShoulderSurfing {
    @SidedProxy(clientSide="com.teamderpy.shouldersurfing.proxy.ClientProxy", serverSide="com.teamderpy.shouldersurfing.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration CONFIG;
    public static final String NAME = "Shoulder Surfing";
    public static final String MODID = "shouldersurfing";
    public static final String MC_VERSION = "1.9";
    public static final String VERSION = "1.16";
    public static final String DEVELOPERS = "Joshua Powers, Exopandora (for 1.8+)";
    public static final String CERTIFICATE = "d6261bb645f41db84c74f98e512c2bb43f188af2";
    public static final Logger LOGGER;
    @Mod.Instance(value="shouldersurfing")
    public static ShoulderSurfing INSTACE;
    private EnumShaderCompatibility shader = EnumShaderCompatibility.NONE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        CONFIG.load();
        this.syncConfig();
        ClientRegistry.registerKeyBinding((KeyBinding)ShoulderSettings.KEYBIND_ROTATE_CAMERA_LEFT);
        ClientRegistry.registerKeyBinding((KeyBinding)ShoulderSettings.KEYBIND_ROTATE_CAMERA_RIGHT);
        ClientRegistry.registerKeyBinding((KeyBinding)ShoulderSettings.KEYBIND_ZOOM_CAMERA_OUT);
        ClientRegistry.registerKeyBinding((KeyBinding)ShoulderSettings.KEYBIND_ZOOM_CAMERA_IN);
        ClientRegistry.registerKeyBinding((KeyBinding)ShoulderSettings.KEYBIND_SWAP_SHOULDER);
        if (ShoulderSettings.DEFAULT_PERSPECTIVE.equals("first person")) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
        } else if (ShoulderSettings.DEFAULT_PERSPECTIVE.equals("third person")) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
        } else if (ShoulderSettings.DEFAULT_PERSPECTIVE.equals("front third person")) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 2;
        } else if (ShoulderSettings.DEFAULT_PERSPECTIVE.equals("shoulder surfing")) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = ShoulderSettings.getShoulderSurfing3ppId();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ShoulderEventHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ShoulderTransformations.MODIFICATIONS != 9) {
            LOGGER.error("Only found " + ShoulderTransformations.MODIFICATIONS + " code injections, but expected " + 9);
            LOGGER.error("ShoulderSurfing should be disabled!");
        } else {
            LOGGER.info("Loaded " + ShoulderTransformations.MODIFICATIONS + " code injections, ShoulderSurfing good to go!");
        }
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        try {
            Class.forName("shadersmod.client.Shaders");
            this.shader = EnumShaderCompatibility.OLD;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("net.optifine.shaders.Shaders");
            this.shader = EnumShaderCompatibility.NEW;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void syncConfig() {
        ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED = CONFIG.get("general", "Dynamic Crosshair", ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED, "If enabled, then the crosshair moves around to line up with the block you are facing.").getBoolean(ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED);
        ShoulderCamera.SHOULDER_ROTATION_YAW = (float)CONFIG.get("general", "Rotation Offset", (double)ShoulderCamera.SHOULDER_ROTATION_YAW, "Third person camera rotation").getDouble((double)ShoulderCamera.SHOULDER_ROTATION_YAW);
        ShoulderCamera.SHOULDER_ZOOM_MOD = (float)CONFIG.get("general", "Zoom Offset", (double)ShoulderCamera.SHOULDER_ZOOM_MOD, "Third person camera zoom").getDouble((double)ShoulderCamera.SHOULDER_ZOOM_MOD);
        ShoulderSettings.IS_ROTATION_UNLIMITED = CONFIG.get("general", "Unlimited Rotation", ShoulderSettings.IS_ROTATION_UNLIMITED, "Whether or not rotation adjustment has limits").getBoolean(ShoulderSettings.IS_ROTATION_UNLIMITED);
        ShoulderSettings.ROTATION_MAXIMUM = (float)CONFIG.get("general", "Rotation Maximum", (double)ShoulderSettings.ROTATION_MAXIMUM, "If rotation is limited this is the maximum amount").getDouble((double)ShoulderSettings.ROTATION_MAXIMUM);
        ShoulderSettings.ROTATION_MINIMUM = (float)CONFIG.get("general", "Rotation Minimum", (double)ShoulderSettings.ROTATION_MINIMUM, "If rotation is limited this is the minimum amount").getDouble((double)ShoulderSettings.ROTATION_MINIMUM);
        ShoulderSettings.IS_ZOOM_UNLIMITED = CONFIG.get("general", "Unlimited Zoom", ShoulderSettings.IS_ZOOM_UNLIMITED, "Whether or not zoom adjustment has limits").getBoolean(ShoulderSettings.IS_ZOOM_UNLIMITED);
        ShoulderSettings.ZOOM_MAXIMUM = (float)CONFIG.get("general", "Zoom Maximum", (double)ShoulderSettings.ZOOM_MAXIMUM, "If zoom is limited this is the maximum amount").getDouble((double)ShoulderSettings.ZOOM_MAXIMUM);
        ShoulderSettings.ZOOM_MINIMUM = (float)CONFIG.get("general", "Zoom Minimum", (double)ShoulderSettings.ZOOM_MINIMUM, "If zoom is limited this is the minimum amount").getDouble((double)ShoulderSettings.ZOOM_MINIMUM);
        ShoulderSettings.TRACE_TO_HORIZON_LAST_RESORT = CONFIG.get("general", "Always Show Crosshair", ShoulderSettings.TRACE_TO_HORIZON_LAST_RESORT, "Whether or not to show a crosshair in the center of the screen if nothing is in range of you").getBoolean(ShoulderSettings.TRACE_TO_HORIZON_LAST_RESORT);
        ShoulderSettings.USE_CUSTOM_RAYTRACE_DISTANCE = CONFIG.get("general", "Show Crosshair Farther", ShoulderSettings.USE_CUSTOM_RAYTRACE_DISTANCE, "Whether or not to show the crosshairs farther than normal").getBoolean(ShoulderSettings.USE_CUSTOM_RAYTRACE_DISTANCE);
        ShoulderSettings.HIDE_PLAYER_IF_TOO_CLOSE_TO_CAMERA = CONFIG.get("general", "Keep Camera Out Of Head", ShoulderSettings.HIDE_PLAYER_IF_TOO_CLOSE_TO_CAMERA, "Whether or not to hide the player model if the camera gets too close to it").getBoolean(ShoulderSettings.HIDE_PLAYER_IF_TOO_CLOSE_TO_CAMERA);
        ShoulderSettings.ENABLE_3PP_CROSSHAIR = CONFIG.get("general", "Third Person Crosshair", ShoulderSettings.ENABLE_3PP_CROSSHAIR, "Enable or disable the crosshair in third person").getBoolean(ShoulderSettings.ENABLE_3PP_CROSSHAIR);
        ShoulderSettings.ENABLE_1PP_CROSSHAIR = CONFIG.get("general", "First Person Crosshair", ShoulderSettings.ENABLE_1PP_CROSSHAIR, "Enable or disable the crosshair in first person").getBoolean(ShoulderSettings.ENABLE_1PP_CROSSHAIR);
        ShoulderSettings.ENABLE_ATTACK_INDICATOR = CONFIG.get("general", "Third Person Attack Indicator", ShoulderSettings.ENABLE_ATTACK_INDICATOR, "Enable or disable the attack indicator in third person").getBoolean(ShoulderSettings.ENABLE_ATTACK_INDICATOR);
        ShoulderSettings.IGNORE_BLOCKS_WITHOUT_COLLISION = CONFIG.get("general", "Ignore Blocks Without Collision", ShoulderSettings.IGNORE_BLOCKS_WITHOUT_COLLISION, "Whether or not the camera ignores blocks without collision").getBoolean(ShoulderSettings.IGNORE_BLOCKS_WITHOUT_COLLISION);
        ShoulderSettings.REPLACE_DEFAULT_3PP = CONFIG.get("general", "Replace Default Perspective", ShoulderSettings.REPLACE_DEFAULT_3PP, "Whether or not to replace the default third person perspective").getBoolean(ShoulderSettings.REPLACE_DEFAULT_3PP);
        ShoulderSettings.DEFAULT_PERSPECTIVE = CONFIG.get("general", "Default Perspective", ShoulderSettings.DEFAULT_PERSPECTIVE, "The default perspective when you load the game", new String[]{"First person", "Third person", "Front third person", "Shoulder surfing"}).getString();
        ShoulderSettings.OVERRIDE_MOD_CROSSHAIRS = CONFIG.get("general", "Override Mod Crosshairs", ShoulderSettings.OVERRIDE_MOD_CROSSHAIRS, "Whether or not to override mod crosshairs").getBoolean(ShoulderSettings.OVERRIDE_MOD_CROSSHAIRS);
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }

    public float getShadersResmul() {
        switch (this.shader) {
            case OLD: {
                return shadersmod.client.Shaders.shaderPackLoaded ? shadersmod.client.Shaders.configRenderResMul : 1.0f;
            }
            case NEW: {
                return Shaders.shaderPackLoaded ? Shaders.configRenderResMul : 1.0f;
            }
        }
        return 1.0f;
    }

    static {
        LOGGER = LogManager.getLogger((String)NAME);
    }
}

