/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.teamderpy.shouldersurfing.ShoulderCamera;
import com.teamderpy.shouldersurfing.ShoulderSettings;
import com.teamderpy.shouldersurfing.math.VectorConverter;
import com.teamderpy.shouldersurfing.renderer.ShoulderRenderBin;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class InjectionDelegation {
    private static double CAMERA_DISTANCE = 0.0;

    public static float getShoulderRotationYaw() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            return ShoulderCamera.SHOULDER_ROTATION_YAW;
        }
        return 0.0f;
    }

    public static float getShoulderRotationPitch() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            return ShoulderCamera.SHOULDER_ROTATION_PITCH;
        }
        return 0.0f;
    }

    public static float getShoulderZoomMod() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            return ShoulderCamera.SHOULDER_ZOOM_MOD;
        }
        return 1.0f;
    }

    public static void calculateRayTraceProjection() {
        if (ShoulderRenderBin.rayTraceHit != null) {
            ShoulderRenderBin.projectedVector = VectorConverter.project2D((float)ShoulderRenderBin.rayTraceHit.field_72450_a, (float)ShoulderRenderBin.rayTraceHit.field_72448_b, (float)ShoulderRenderBin.rayTraceHit.field_72449_c);
            ShoulderRenderBin.rayTraceHit = null;
        }
    }

    public static void verifyReverseBlockDist(double distance) {
        if (distance < 0.8 && ShoulderSettings.HIDE_PLAYER_IF_TOO_CLOSE_TO_CAMERA) {
            ShoulderRenderBin.skipPlayerRender = true;
        }
    }

    public static RayTraceResult getRayTraceResult(World world, Vec3d vec1, Vec3d vec2) {
        if (ShoulderSettings.IGNORE_BLOCKS_WITHOUT_COLLISION) {
            return world.func_147447_a(vec1, vec2, false, true, false);
        }
        return world.func_72933_a(vec1, vec2);
    }

    public static int getMax3ppId() {
        if (ShoulderSettings.REPLACE_DEFAULT_3PP) {
            return 2;
        }
        return 3;
    }

    public static double checkDistance(double distance, float yaw, double posX, double posY, double posZ, double cameraXoffset, double cameraYoffset, double cameraZoffset) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            double result = distance;
            float radiant = (float)Math.PI / 180;
            float offset = InjectionDelegation.getShoulderRotationYaw();
            float newYaw = yaw - offset;
            double length = (double)MathHelper.func_76134_b((float)((-90.0f - offset) * radiant)) * distance;
            double addX = (double)MathHelper.func_76134_b((float)(newYaw * radiant)) * length;
            double addZ = (double)MathHelper.func_76126_a((float)(newYaw * radiant)) * length;
            for (int i = 0; i < 8; ++i) {
                double newDistance;
                RayTraceResult raytraceresult;
                float offsetX = (i & 1) * 2 - 1;
                float offsetY = (i >> 1 & 1) * 2 - 1;
                float offsetZ = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = InjectionDelegation.getRayTraceResult((World)Minecraft.func_71410_x().field_71441_e, new Vec3d(posX + (double)(offsetX *= 0.1f), posY + (double)(offsetY *= 0.1f), posZ + (double)(offsetZ *= 0.1f)), new Vec3d(posX - (cameraXoffset + addX) + (double)offsetX + (double)offsetZ, posY - cameraYoffset + (double)offsetY, posZ - (cameraZoffset + addZ) + (double)offsetZ))) == null || !((newDistance = raytraceresult.field_72307_f.func_72438_d(new Vec3d(posX, posY, posZ))) < result)) continue;
                result = newDistance;
            }
            CAMERA_DISTANCE = result;
            return CAMERA_DISTANCE;
        }
        CAMERA_DISTANCE = distance;
        return CAMERA_DISTANCE;
    }

    public static Vec3d getPositionEyes(Entity entity, Vec3d positionEyes) {
        if (!ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED) {
            float radiant = (float)Math.PI / 180;
            double length = (double)MathHelper.func_76134_b((float)((90.0f - InjectionDelegation.getShoulderRotationYaw()) * radiant)) * CAMERA_DISTANCE;
            double addX = (double)MathHelper.func_76134_b((float)(entity.field_70177_z * radiant)) * length;
            double addZ = (double)MathHelper.func_76126_a((float)(entity.field_70177_z * radiant)) * length;
            return positionEyes.func_178787_e(new Vec3d(addX, 0.0, addZ));
        }
        return positionEyes;
    }

    public static int doRenderCrosshair() {
        int result = 0;
        if (!ShoulderSettings.TRACE_TO_HORIZON_LAST_RESORT && Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71476_x.field_72313_a != RayTraceResult.Type.MISS) {
            result = 1;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O > 0 && !ShoulderSettings.ENABLE_3PP_CROSSHAIR) {
            result = 1;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && !ShoulderSettings.ENABLE_1PP_CROSSHAIR) {
            result = 1;
        }
        return result;
    }
}

