/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.google.gson.Gson;
import com.teamderpy.shouldersurfing.ShoulderSurfing;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Mappings {
    private final Map<String, JsonMapping.JsonVersions.JsonMappings.JsonClassMapping> CLASS_MAPPINGS = new HashMap<String, JsonMapping.JsonVersions.JsonMappings.JsonClassMapping>();
    private final Map<String, JsonMapping.JsonVersions.JsonMappings.JsonFieldMapping> FIELD_MAPPINGS = new HashMap<String, JsonMapping.JsonVersions.JsonMappings.JsonFieldMapping>();
    private boolean isObfuscated;

    public Mappings(String ... files) {
        try {
            this.init(files);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(String ... files) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        for (String file : files) {
            String version = ForgeVersion.class.getDeclaredField("mcVersion").get(ForgeVersion.class).toString();
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            JsonMapping json = (JsonMapping)new Gson().fromJson((Reader)reader, JsonMapping.class);
            if (json != null) {
                for (JsonMapping.JsonVersions versions : json.getVersions()) {
                    if (!versions.getVersion().equals(version)) continue;
                    for (JsonMapping.JsonVersions.JsonMappings.JsonClassMapping jsonClassMapping : versions.getMappings().getClasses()) {
                        this.CLASS_MAPPINGS.put(jsonClassMapping.getName(), jsonClassMapping);
                    }
                    for (JsonMapping.JsonVersions.JsonMappings.JsonMappingBase jsonMappingBase : versions.getMappings().getMethods()) {
                        this.FIELD_MAPPINGS.put(jsonMappingBase.getName(), (JsonMapping.JsonVersions.JsonMappings.JsonFieldMapping)jsonMappingBase);
                    }
                    for (JsonMapping.JsonVersions.JsonMappings.JsonMappingBase jsonMappingBase : versions.getMappings().getFields()) {
                        this.FIELD_MAPPINGS.put(jsonMappingBase.getName(), (JsonMapping.JsonVersions.JsonMappings.JsonFieldMapping)jsonMappingBase);
                    }
                    ShoulderSurfing.LOGGER.info("Loaded mappings for Minecraft " + versions.getVersion());
                    break;
                }
            }
            if (!this.CLASS_MAPPINGS.isEmpty() && !this.FIELD_MAPPINGS.isEmpty()) continue;
            ShoulderSurfing.LOGGER.error("No mappings found for Minecraft 1.12.2");
        }
    }

    public void setObfuscated(boolean isObfuscated) {
        this.isObfuscated = isObfuscated;
    }

    @Nullable
    public String getClassPackage(String klass) {
        if (this.CLASS_MAPPINGS.containsKey(klass)) {
            return this.CLASS_MAPPINGS.get(klass).getClassPackage(this.isObfuscated);
        }
        return null;
    }

    @Nullable
    public String getClassPath(String klass) {
        if (this.CLASS_MAPPINGS.containsKey(klass)) {
            return this.CLASS_MAPPINGS.get(klass).getClassPath(this.isObfuscated);
        }
        return null;
    }

    @Nullable
    public String getFieldOrMethod(String fieldOrMethod) {
        if (this.FIELD_MAPPINGS.containsKey(fieldOrMethod)) {
            return this.FIELD_MAPPINGS.get(fieldOrMethod).getFieldOrMethod(this.isObfuscated);
        }
        return null;
    }

    @Nullable
    public String getPackage(String klass) {
        if (this.CLASS_MAPPINGS.containsKey(klass)) {
            return this.CLASS_MAPPINGS.get(klass).getPackage();
        }
        return null;
    }

    @Nullable
    public String getPath(String klass) {
        if (this.CLASS_MAPPINGS.containsKey(klass)) {
            return this.CLASS_MAPPINGS.get(klass).getPath();
        }
        return null;
    }

    @Nullable
    public String getName(String field) {
        if (this.CLASS_MAPPINGS.containsKey(field)) {
            return this.CLASS_MAPPINGS.get(field).getName();
        }
        if (this.FIELD_MAPPINGS.containsKey(field)) {
            return this.FIELD_MAPPINGS.get(field).getName();
        }
        return null;
    }

    @Nullable
    public String getObf(String field) {
        if (this.CLASS_MAPPINGS.containsKey(field)) {
            return this.CLASS_MAPPINGS.get(field).getObf();
        }
        if (this.FIELD_MAPPINGS.containsKey(field)) {
            return this.FIELD_MAPPINGS.get(field).getObf();
        }
        return null;
    }

    @Nullable
    public String getDescriptor(String field) {
        if (this.FIELD_MAPPINGS.containsKey(field)) {
            return this.FIELD_MAPPINGS.get(field).getDescriptor(this.CLASS_MAPPINGS, this.isObfuscated);
        }
        return null;
    }

    public static class JsonMapping {
        private JsonVersions[] versions;

        public void setVersions(JsonVersions[] versions) {
            this.versions = versions;
        }

        public JsonVersions[] getVersions() {
            return this.versions;
        }

        public static class JsonVersions {
            private String version;
            private JsonMappings mappings;

            public String getVersion() {
                return this.version;
            }

            public JsonMappings getMappings() {
                return this.mappings;
            }

            public static class JsonMappings {
                private JsonClassMapping[] classes;
                private JsonFieldMapping[] methods;
                private JsonFieldMapping[] fields;

                public JsonClassMapping[] getClasses() {
                    return this.classes;
                }

                public JsonFieldMapping[] getMethods() {
                    return this.methods;
                }

                public JsonFieldMapping[] getFields() {
                    return this.fields;
                }

                public static class JsonFieldMapping
                extends JsonMappingBase {
                    private String desc;

                    public String getDescriptor(Map<String, JsonClassMapping> mappings, boolean isObfuscated) {
                        String result = this.desc;
                        if (result != null) {
                            for (JsonClassMapping mapping : mappings.values()) {
                                result = result.replaceAll("L\\$" + mapping.name + ";", "L" + mapping.getClassPath(isObfuscated) + ";");
                            }
                        }
                        return result;
                    }

                    public String getFieldOrMethod(boolean isObfuscated) {
                        return isObfuscated ? this.obf : this.name.split("#")[1];
                    }
                }

                public static class JsonClassMapping
                extends JsonMappingBase {
                    private String path;

                    public String getPath() {
                        return this.path + "/" + this.name;
                    }

                    public String getPackage() {
                        return this.path.replaceAll("/", ".") + "." + this.name;
                    }

                    public String getClassPackage(boolean isObfuscated) {
                        return isObfuscated ? this.obf : this.getPackage();
                    }

                    public String getClassPath(boolean isObfuscated) {
                        return isObfuscated ? this.obf : this.getPath();
                    }
                }

                public static abstract class JsonMappingBase {
                    protected String name;
                    protected String obf;

                    public String getName() {
                        return this.name;
                    }

                    public String getObf() {
                        return this.obf;
                    }
                }
            }
        }
    }
}

