/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing;

import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.proxy.ClientProxy;
import com.teamderpy.shouldersurfing.proxy.CommonProxy;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.optifine.shaders.Shaders;

@Mod(value="shouldersurfing")
public class ShoulderSurfing {
    public static final String MODID = "shouldersurfing";
    public static final KeyBinding KEYBIND_ROTATE_CAMERA_LEFT = new KeyBinding("Camera left", 263, "key.categories.misc");
    public static final KeyBinding KEYBIND_ROTATE_CAMERA_RIGHT = new KeyBinding("Camera right", 262, "key.categories.misc");
    public static final KeyBinding KEYBIND_ZOOM_CAMERA_OUT = new KeyBinding("Camera closer", 265, "key.categories.misc");
    public static final KeyBinding KEYBIND_ZOOM_CAMERA_IN = new KeyBinding("Camera farther", 264, "key.categories.misc");
    public static final KeyBinding KEYBIND_SWAP_SHOULDER = new KeyBinding("Swap shoulder", 79, "key.categories.misc");
    public static final float RAYTRACE_DISTANCE = 400.0f;
    private static CommonProxy SIDEPROXY;
    private static boolean SHADER_ACTIVE;

    public ShoulderSurfing() {
        SIDEPROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC, "shouldersurfing.toml");
        modEventBus.register(Config.class);
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND_ROTATE_CAMERA_LEFT);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND_ROTATE_CAMERA_RIGHT);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND_ZOOM_CAMERA_OUT);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND_ZOOM_CAMERA_IN);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND_SWAP_SHOULDER);
        SHADER_ACTIVE = ShoulderSurfing.isClassLoaded("net.optifine.shaders.Shaders");
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        SIDEPROXY.setup();
    }

    public static float getShadersResMul() {
        if (SHADER_ACTIVE) {
            return Shaders.shaderPackLoaded ? Shaders.configRenderResMul : 1.0f;
        }
        return 1.0f;
    }

    private static boolean isClassLoaded(String klass) {
        try {
            Class.forName(klass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

