/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.math.RayTracer;
import com.teamderpy.shouldersurfing.math.VectorConverter;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class InjectionDelegation {
    private static double CAMERA_DISTANCE = 0.0;

    public static float getShoulderRotationYaw() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.CLIENT.getShoulderSurfing3ppId()) {
            return (float)Config.CLIENT.getShoulderRotationYaw();
        }
        return 0.0f;
    }

    public static float getShoulderRotationPitch() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.CLIENT.getShoulderSurfing3ppId()) {
            return 0.0f;
        }
        return 0.0f;
    }

    public static float getShoulderZoomMod() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.CLIENT.getShoulderSurfing3ppId()) {
            return (float)Config.CLIENT.getShoulderZoomMod();
        }
        return 1.0f;
    }

    public static void calculateRayTraceProjection() {
        RayTracer rayTracer = RayTracer.getInstance();
        if (rayTracer.getRayTraceHit() != null) {
            rayTracer.setProjectedVector(VectorConverter.project2D(rayTracer.getRayTraceHit()));
            rayTracer.setRayTraceHit(null);
        }
    }

    public static void verifyReverseBlockDist(double distance) {
        if (distance < 0.8 && Config.CLIENT.keepCameraOutOfHead()) {
            RayTracer.getInstance().setSkipPlayerRender(true);
        }
    }

    public static RayTraceResult rayTraceBlocks(World world, Vec3d vec1, Vec3d vec2) {
        if (Config.CLIENT.ignoreBlocksWithoutCollision()) {
            return world.func_200259_a(vec1, vec2, RayTraceFluidMode.NEVER, true, false);
        }
        return world.func_72933_a(vec1, vec2);
    }

    public static int getMax3ppId() {
        if (Config.CLIENT.replaceDefaultPerspective()) {
            return 2;
        }
        return 3;
    }

    public static double checkDistance(double distance, float yaw, double posX, double posY, double posZ, double cameraXoffset, double cameraYoffset, double cameraZoffset) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.CLIENT.getShoulderSurfing3ppId()) {
            double result = distance;
            float radiant = (float)Math.PI / 180;
            float newYaw = yaw - InjectionDelegation.getShoulderRotationYaw();
            double length = (double)MathHelper.func_76126_a((float)(-InjectionDelegation.getShoulderRotationYaw() * ((float)Math.PI / 180))) * distance;
            double addX = (double)MathHelper.func_76134_b((float)(newYaw * ((float)Math.PI / 180))) * length;
            double addZ = (double)MathHelper.func_76126_a((float)(newYaw * ((float)Math.PI / 180))) * length;
            for (int i = 0; i < 8; ++i) {
                double newDistance;
                RayTraceResult raytraceresult;
                float offsetX = (i & 1) * 2 - 1;
                float offsetY = (i >> 1 & 1) * 2 - 1;
                float offsetZ = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = InjectionDelegation.rayTraceBlocks((World)Minecraft.func_71410_x().field_71441_e, new Vec3d(posX + (double)(offsetX *= 0.1f), posY + (double)(offsetY *= 0.1f), posZ + (double)(offsetZ *= 0.1f)), new Vec3d(posX - (cameraXoffset + addX) + (double)offsetX + (double)offsetZ, posY - cameraYoffset + (double)offsetY, posZ - (cameraZoffset + addZ) + (double)offsetZ))) == null || !((newDistance = raytraceresult.field_72307_f.func_72438_d(new Vec3d(posX, posY, posZ))) < result)) continue;
                result = newDistance;
            }
            CAMERA_DISTANCE = result;
            return CAMERA_DISTANCE;
        }
        CAMERA_DISTANCE = distance;
        return CAMERA_DISTANCE;
    }

    public static Vec3d getEyePosition(Entity entity, Vec3d positionEyes) {
        if (!Config.CLIENT.getCrosshairType().isDynamic(Minecraft.func_71410_x().field_71439_g.func_184607_cu())) {
            float radiant = (float)Math.PI / 180;
            float radiantPitch = entity.field_70125_A * ((float)Math.PI / 180);
            float radiantYaw = entity.field_70177_z * ((float)Math.PI / 180);
            double pitchYLength = (double)MathHelper.func_76126_a((float)(InjectionDelegation.getShoulderRotationPitch() * ((float)Math.PI / 180))) * CAMERA_DISTANCE;
            double pitchX = (double)(MathHelper.func_76126_a((float)radiantPitch) * MathHelper.func_76126_a((float)(-radiantYaw))) * pitchYLength;
            double pitchY = (double)MathHelper.func_76134_b((float)radiantPitch) * pitchYLength;
            double pitchZ = (double)(MathHelper.func_76126_a((float)radiantPitch) * MathHelper.func_76134_b((float)(-radiantYaw))) * pitchYLength;
            double yawXZlength = (double)MathHelper.func_76126_a((float)(InjectionDelegation.getShoulderRotationYaw() * ((float)Math.PI / 180))) * CAMERA_DISTANCE;
            double yawX = (double)MathHelper.func_76134_b((float)radiantYaw) * yawXZlength;
            double yawZ = (double)MathHelper.func_76126_a((float)radiantYaw) * yawXZlength;
            return positionEyes.func_72441_c(yawX, 0.0, yawZ).func_72441_c(pitchX, pitchY, pitchZ);
        }
        return positionEyes;
    }

    public static int doRenderCrosshair() {
        int result = 0;
        if (!Config.CLIENT.alwaysShowCrosshair() && Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71476_x.field_72313_a != RayTraceResult.Type.MISS) {
            result = 1;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O > 0 && !Config.CLIENT.show3ppCrosshair()) {
            result = 1;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && !Config.CLIENT.show1ppCrosshair()) {
            result = 1;
        }
        return result;
    }
}

