/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    private static ModConfig MOD_CONFIG;
    private static CommentedFileConfig CONFIG_DATA;

    protected static <T> void set(ForgeConfigSpec.ConfigValue<T> configValue, T value) {
        if (value != null && !value.equals(configValue.get())) {
            CONFIG_DATA.set(configValue.getPath(), value);
        }
    }

    @SubscribeEvent
    public static void configLoad(ModConfig.Loading event) {
        if (event.getConfig().getType().equals((Object)ModConfig.Type.CLIENT)) {
            MOD_CONFIG = event.getConfig();
            CONFIG_DATA = (CommentedFileConfig)MOD_CONFIG.getConfigData();
            CLIENT.read();
            switch (CLIENT.getDefaultPerspective()) {
                case FIRST_PERSON: {
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
                    break;
                }
                case THIRD_PERSON: {
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
                    break;
                }
                case FRONT_THIRD_PERSON: {
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 2;
                    break;
                }
                case SHOULDER_SURFING: {
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = CLIENT.getShoulderSurfing3ppId();
                }
            }
        }
    }

    @SubscribeEvent
    public static void configReload(ModConfig.ConfigReloading event) {
        if (event.getConfig().getType().equals((Object)ModConfig.Type.CLIENT) && CONFIG_DATA != null) {
            CONFIG_DATA.load();
            CLIENT.read();
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 3 && CLIENT.replaceDefaultPerspective()) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
            } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && !CLIENT.replaceDefaultPerspective()) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 3;
            }
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        CLIENT = (ClientConfig)pair.getLeft();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientConfig {
        private double shoulderRotationYaw;
        private double shoulderZoomMod;
        private boolean unlimitedRotation;
        private double rotationMin;
        private double rotationMax;
        private boolean unlimitedZoom;
        private double zoomMin;
        private double zoomMax;
        private boolean show3ppCrosshair;
        private boolean show1ppCrosshair;
        private boolean alwaysShowCrosshair;
        private boolean showCrosshairFarther;
        private boolean keepCameraOutOfHead;
        private boolean attackIndicator;
        private boolean ignoreBlocksWithoutCollision;
        private boolean replaceDefaultPerspective;
        private Perspective defaultPerspective;
        private CrosshairType crosshairType;
        private final ForgeConfigSpec.DoubleValue valueShoulderRotationYaw;
        private final ForgeConfigSpec.DoubleValue valueShoulderZoomMod;
        private final ForgeConfigSpec.BooleanValue valueUnlimitedRotation;
        private final ForgeConfigSpec.DoubleValue valueRotationMin;
        private final ForgeConfigSpec.DoubleValue valueRotationMax;
        private final ForgeConfigSpec.BooleanValue valueUnlimitedZoom;
        private final ForgeConfigSpec.DoubleValue valueZoomMin;
        private final ForgeConfigSpec.DoubleValue valueZoomMax;
        private final ForgeConfigSpec.BooleanValue valueShow3ppCrosshair;
        private final ForgeConfigSpec.BooleanValue valueShow1ppCrosshair;
        private final ForgeConfigSpec.BooleanValue valueAlwaysShowCrosshair;
        private final ForgeConfigSpec.BooleanValue valueShowCrosshairFarther;
        private final ForgeConfigSpec.BooleanValue valueKeepCameraOutOfHead;
        private final ForgeConfigSpec.BooleanValue valueAttackIndicator;
        private final ForgeConfigSpec.BooleanValue valueIgnoreBlocksWithoutCollision;
        private final ForgeConfigSpec.BooleanValue valueReplaceDefaultPerspective;
        private final ForgeConfigSpec.ConfigValue<Perspective> valueDefaultPerspective;
        private final ForgeConfigSpec.ConfigValue<CrosshairType> valueCrosshairType;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.valueShoulderRotationYaw = builder.comment("Third person camera rotation").translation("Rotation Offset").defineInRange("rotation_offset", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.valueShoulderZoomMod = builder.comment("Third person camera zoom").translation("Zoom Offset").defineInRange("zoom_offset", 0.7, -1.7976931348623157E308, Double.MAX_VALUE);
            this.valueUnlimitedRotation = builder.comment("Whether or not rotation adjustment has limits").translation("Unlimited Rotation").define("unlimited_rotation", false);
            this.valueRotationMin = builder.comment("If rotation is limited this is the minimum amount").translation("Rotation Minimum").defineInRange("rotation_min", -60.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.valueRotationMax = builder.comment("If rotation is limited this is the maximum amount").translation("Rotation Maximum").defineInRange("rotation_max", 60.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.valueUnlimitedZoom = builder.comment("Whether or not zoom adjustment has limits").translation("Unlimited Zoom").define("unlimited_zoom", false);
            this.valueZoomMin = builder.comment("If zoom is limited this is the minimum amount").translation("Zoom Minimum").defineInRange("zoom_min", 0.3, -1.7976931348623157E308, Double.MAX_VALUE);
            this.valueZoomMax = builder.comment("If zoom is limited this is the maximum amount").translation("Zoom Maximum").defineInRange("zoom_max", 2.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.valueShow3ppCrosshair = builder.comment("Enable or disable the crosshair in third person").translation("Third Person Crosshair").define("3pp_crosshair", true);
            this.valueShow1ppCrosshair = builder.comment("Enable or disable the crosshair in first person").translation("First Person Crosshair").define("1pp_crosshair", true);
            this.valueAlwaysShowCrosshair = builder.comment("Whether or not to show a crosshair in the center of the screen if nothing is in range of you").translation("Always Show Crosshair").define("always_show_crosshair", true);
            this.valueShowCrosshairFarther = builder.comment("Whether or not to show the crosshairs farther than normal").translation("Show Crosshair Farther").define("show_crosshair_farther", true);
            this.valueKeepCameraOutOfHead = builder.comment("Whether or not to hide the player model if the camera gets too close to it").translation("Keep Camera Out Of Head").define("keep_camera_out_of_head", true);
            this.valueAttackIndicator = builder.comment("Enable or disable the attack indicator in third person").translation("Third Person Attack Indicator").define("third_person_attack_indicator", true);
            this.valueIgnoreBlocksWithoutCollision = builder.comment("Whether or not the camera ignores blocks without collision").translation("Ignore Blocks Without Collision").define("third_person_attack_indicator", true);
            this.valueReplaceDefaultPerspective = builder.comment("Whether or not to replace the default third person perspective").translation("Replace Default Perspective").define("replace_default_perspective", false);
            this.valueDefaultPerspective = builder.comment("The default perspective when you load the game (FIRST_PERSON, THIRD_PERSON, FRONT_THIRD_PERSON, SHOULDER_SURFING)").translation("Default Perspective").defineEnum("default_perspective", (Enum)Perspective.SHOULDER_SURFING, (Enum[])Perspective.values());
            this.valueCrosshairType = builder.comment("Crosshair type to use in 3PP (ADAPTIVE, DYNAMIC, STATIC, STATIC_WITH_1PP)").translation("Crosshair type").defineEnum("crosshair_type", (Enum)CrosshairType.ADAPTIVE, (Enum[])CrosshairType.values());
        }

        public void read() {
            this.shoulderRotationYaw = (Double)this.valueShoulderRotationYaw.get();
            this.shoulderZoomMod = (Double)this.valueShoulderZoomMod.get();
            this.unlimitedRotation = (Boolean)this.valueUnlimitedRotation.get();
            this.rotationMin = (Double)this.valueRotationMin.get();
            this.rotationMax = (Double)this.valueRotationMax.get();
            this.unlimitedZoom = (Boolean)this.valueUnlimitedZoom.get();
            this.zoomMin = (Double)this.valueZoomMin.get();
            this.zoomMax = (Double)this.valueZoomMax.get();
            this.show3ppCrosshair = (Boolean)this.valueShow3ppCrosshair.get();
            this.show1ppCrosshair = (Boolean)this.valueShow1ppCrosshair.get();
            this.alwaysShowCrosshair = (Boolean)this.valueAlwaysShowCrosshair.get();
            this.showCrosshairFarther = (Boolean)this.valueShowCrosshairFarther.get();
            this.keepCameraOutOfHead = (Boolean)this.valueKeepCameraOutOfHead.get();
            this.attackIndicator = (Boolean)this.valueAttackIndicator.get();
            this.ignoreBlocksWithoutCollision = (Boolean)this.valueIgnoreBlocksWithoutCollision.get();
            this.replaceDefaultPerspective = (Boolean)this.valueReplaceDefaultPerspective.get();
            this.defaultPerspective = (Perspective)((Object)this.valueDefaultPerspective.get());
            this.crosshairType = (CrosshairType)((Object)this.valueCrosshairType.get());
        }

        private void write() {
            Config.set(this.valueShoulderRotationYaw, this.shoulderRotationYaw);
            Config.set(this.valueShoulderZoomMod, this.shoulderZoomMod);
            Config.set(this.valueUnlimitedRotation, this.unlimitedRotation);
            Config.set(this.valueRotationMin, this.rotationMin);
            Config.set(this.valueRotationMax, this.rotationMax);
            Config.set(this.valueUnlimitedZoom, this.unlimitedZoom);
            Config.set(this.valueZoomMin, this.zoomMin);
            Config.set(this.valueZoomMax, this.zoomMax);
            Config.set(this.valueShow3ppCrosshair, this.show3ppCrosshair);
            Config.set(this.valueShow1ppCrosshair, this.show1ppCrosshair);
            Config.set(this.valueAlwaysShowCrosshair, this.alwaysShowCrosshair);
            Config.set(this.valueShowCrosshairFarther, this.showCrosshairFarther);
            Config.set(this.valueKeepCameraOutOfHead, this.keepCameraOutOfHead);
            Config.set(this.valueAttackIndicator, this.attackIndicator);
            Config.set(this.valueIgnoreBlocksWithoutCollision, this.ignoreBlocksWithoutCollision);
            Config.set(this.valueReplaceDefaultPerspective, this.replaceDefaultPerspective);
            Config.set(this.valueDefaultPerspective, this.defaultPerspective);
            Config.set(this.valueCrosshairType, this.crosshairType);
        }

        public double getShoulderRotationYaw() {
            return this.shoulderRotationYaw;
        }

        public void setShoulderRotationYaw(double yaw) {
            this.shoulderRotationYaw = yaw;
            this.write();
        }

        public double getShoulderZoomMod() {
            return this.shoulderZoomMod;
        }

        public void setShoulderZoomMod(double zoomMod) {
            this.shoulderZoomMod = zoomMod;
            this.write();
        }

        public boolean isRotationUnlimited() {
            return this.unlimitedRotation;
        }

        public void setRotationUnlimited(boolean enabled) {
            this.unlimitedRotation = enabled;
            this.write();
        }

        public double getRotationMin() {
            return this.rotationMin;
        }

        public void setRotationMin(double min) {
            this.rotationMin = min;
            this.write();
        }

        public double getRotationMax() {
            return this.rotationMax;
        }

        public void setRotationMax(double max) {
            this.rotationMax = max;
            this.write();
        }

        public boolean isZoomUnlimited() {
            return this.unlimitedZoom;
        }

        public void setZoomUnlimited(boolean enabled) {
            this.unlimitedZoom = enabled;
            this.write();
        }

        public double getZoomMin() {
            return this.zoomMin;
        }

        public void setZoomMin(double min) {
            this.zoomMin = min;
            this.write();
        }

        public double getZoomMax() {
            return this.zoomMax;
        }

        public void setZoomMax(double max) {
            this.rotationMax = max;
            this.write();
        }

        public boolean show3ppCrosshair() {
            return this.show3ppCrosshair;
        }

        public void setShow3ppCrosshair(boolean enabled) {
            this.show3ppCrosshair = enabled;
            this.write();
        }

        public boolean show1ppCrosshair() {
            return this.show1ppCrosshair;
        }

        public void setShow1ppCrosshair(boolean enabled) {
            this.show1ppCrosshair = enabled;
            this.write();
        }

        public boolean alwaysShowCrosshair() {
            return this.alwaysShowCrosshair;
        }

        public void setAlwaysShowCrosshair(boolean enabled) {
            this.alwaysShowCrosshair = enabled;
            this.write();
        }

        public boolean showCrosshairFarther() {
            return this.showCrosshairFarther;
        }

        public void setShowCrosshairFarther(boolean enabled) {
            this.showCrosshairFarther = enabled;
            this.write();
        }

        public boolean keepCameraOutOfHead() {
            return this.keepCameraOutOfHead;
        }

        public void setKeepCameraOutOfHead(boolean enabled) {
            this.keepCameraOutOfHead = enabled;
            this.write();
        }

        public boolean showAttackIndicator() {
            return this.attackIndicator;
        }

        public void setShowAttackIndicator(boolean enabled) {
            this.attackIndicator = enabled;
            this.write();
        }

        public boolean ignoreBlocksWithoutCollision() {
            return this.ignoreBlocksWithoutCollision;
        }

        public void setIgnoreBlocksWithoutCollision(boolean enabled) {
            this.ignoreBlocksWithoutCollision = enabled;
            this.write();
        }

        public boolean replaceDefaultPerspective() {
            return this.replaceDefaultPerspective;
        }

        public void setReplaceDefaultPerspective(boolean enabled) {
            this.replaceDefaultPerspective = enabled;
            this.write();
        }

        public Perspective getDefaultPerspective() {
            return this.defaultPerspective;
        }

        public CrosshairType getCrosshairType() {
            return this.crosshairType;
        }

        public int getShoulderSurfing3ppId() {
            if (this.replaceDefaultPerspective()) {
                return 1;
            }
            return 3;
        }

        public void adjustCameraLeft() {
            if (this.isRotationUnlimited() || this.getShoulderRotationYaw() < this.getRotationMax()) {
                this.setShoulderRotationYaw(this.getShoulderRotationYaw() + 0.5);
            }
        }

        public void adjustCameraRight() {
            if (this.isRotationUnlimited() || this.getShoulderRotationYaw() > this.getRotationMin()) {
                this.setShoulderRotationYaw(this.getShoulderRotationYaw() - 0.5);
            }
        }

        public void adjustCameraIn() {
            if (this.isZoomUnlimited() || this.getShoulderZoomMod() < this.getZoomMax()) {
                this.setShoulderZoomMod(this.getShoulderZoomMod() + (double)0.01f);
            }
        }

        public void adjustCameraOut() {
            if (this.isZoomUnlimited() || this.getShoulderZoomMod() > this.getZoomMin()) {
                this.setShoulderZoomMod(this.getShoulderZoomMod() - (double)0.01f);
            }
        }

        public void swapShoulder() {
            this.setShoulderRotationYaw(-this.getShoulderRotationYaw());
        }

        public static enum Perspective {
            FIRST_PERSON,
            THIRD_PERSON,
            FRONT_THIRD_PERSON,
            SHOULDER_SURFING;

        }

        public static enum CrosshairType {
            ADAPTIVE,
            DYNAMIC,
            STATIC,
            STATIC_WITH_1PP;


            public boolean isDynamic(ItemStack stack) {
                if (this == ADAPTIVE && stack.func_77973_b().func_185040_i()) {
                    return stack.func_77973_b().func_185045_a(new ResourceLocation("pull")) != null;
                }
                return this == DYNAMIC;
            }
        }
    }
}

