/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.event;

import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.math.RayTracer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static float lastX = 0.0f;
    private static float lastY = 0.0f;
    private static Vec2f delta = Vec2f.field_189974_a;
    private static Vec2f translation = Vec2f.field_189974_a;
    private static int itemUseTicks;

    @SubscribeEvent
    public static void renderTickEvent(TickEvent.RenderTickEvent event) {
        RayTracer rayTracer = RayTracer.getInstance();
        rayTracer.setSkipPlayerRender(false);
        rayTracer.traceFromEyes(1.0f);
        if (rayTracer.getRayTraceHit() != null && Minecraft.func_71410_x().field_71439_g != null) {
            rayTracer.setRayTraceHit(rayTracer.getRayTraceHit().func_178788_d(Minecraft.func_71410_x().field_71439_g.func_174791_d()));
        }
    }

    @SubscribeEvent
    public static void livingEntityUseItemEventTick(LivingEntityUseItemEvent.Tick event) {
        if (Config.CLIENT.getCrosshairType().equals((Object)Config.ClientConfig.CrosshairType.STATIC_WITH_1PP) && itemUseTicks < 2 && event.getEntity().equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.CLIENT.getShoulderSurfing3ppId()) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
            itemUseTicks = 2;
        }
    }

    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (Config.CLIENT.getCrosshairType().equals((Object)Config.ClientConfig.CrosshairType.STATIC_WITH_1PP) && event.phase.equals((Object)TickEvent.Phase.START)) {
            if (itemUseTicks > 0) {
                --itemUseTicks;
            }
            if (itemUseTicks == 1) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = Config.CLIENT.getShoulderSurfing3ppId();
            }
        }
    }

    @SubscribeEvent
    public static void preRenderPlayerEvent(RenderPlayerEvent.Pre event) {
        if (RayTracer.getInstance().skipPlayerRender() && event.getEntityPlayer().equals((Object)Minecraft.func_71410_x().field_71439_g) && (event.getRenderer().func_177068_d().field_78735_i != 180.0f || Minecraft.func_71410_x().func_195544_aj()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS)) {
            int width = Minecraft.func_71410_x().field_195558_d.func_198107_o();
            int height = Minecraft.func_71410_x().field_195558_d.func_198087_p();
            float scale = (float)Minecraft.func_71410_x().field_195558_d.func_198078_c(Minecraft.func_71410_x().field_71474_y.field_74335_Z) * ShoulderSurfing.getShadersResMul();
            delta = ClientEventHandler.computeDelta(width, height, scale, event.getPartialTicks());
            translation = ClientEventHandler.computeTranslation(width, height, scale);
            if (Config.CLIENT.getCrosshairType().isDynamic(Minecraft.func_71410_x().field_71439_g.func_184607_cu()) && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.CLIENT.getShoulderSurfing3ppId()) {
                GlStateManager.func_179109_b((float)ClientEventHandler.translation.field_189982_i, (float)ClientEventHandler.translation.field_189983_j, (float)0.0f);
            } else {
                lastX = (float)width * scale / 2.0f;
                lastY = (float)height * scale / 2.0f;
            }
        }
    }

    @SubscribeEvent
    public static void postRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS) && Config.CLIENT.getCrosshairType().isDynamic(Minecraft.func_71410_x().field_71439_g.func_184607_cu()) && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.CLIENT.getShoulderSurfing3ppId()) {
            ClientEventHandler.translateBack();
        }
    }

    private static void translateBack() {
        lastX += ClientEventHandler.delta.field_189982_i;
        lastY += ClientEventHandler.delta.field_189983_j;
        GlStateManager.func_179109_b((float)(-ClientEventHandler.translation.field_189982_i), (float)(-ClientEventHandler.translation.field_189983_j), (float)0.0f);
    }

    private static Vec2f computeDelta(int width, int height, float scale, float partial) {
        float deltaX = ((float)width * scale / 2.0f - lastX) * partial;
        float deltaY = ((float)height * scale / 2.0f - lastY) * partial;
        RayTracer rayTracer = RayTracer.getInstance();
        if (rayTracer.getProjectedVector() != null) {
            deltaX = (rayTracer.getProjectedVector().field_189982_i - lastX) * partial;
            deltaY = (rayTracer.getProjectedVector().field_189983_j - lastY) * partial;
        }
        return new Vec2f(deltaX, deltaY);
    }

    private static Vec2f computeTranslation(int width, int height, float scale) {
        float crosshairWidth = (lastX + ClientEventHandler.delta.field_189982_i) / scale;
        float crosshairHeight = (lastY + ClientEventHandler.delta.field_189983_j) / scale;
        float translationX = (float)(-width / 2) + crosshairWidth;
        float translationY = (float)(-height / 2) + crosshairHeight;
        return new Vec2f(translationX, translationY);
    }
}

