/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.math;

import com.teamderpy.shouldersurfing.config.Config;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RayTracer {
    private boolean rayTraceInReach = false;
    private boolean skipPlayerRender = false;
    private Vec2f projectedVector = null;
    private Vec3d rayTraceHit = null;
    private static final RayTracer INSTANCE = new RayTracer();

    public static RayTracer getInstance() {
        return INSTANCE;
    }

    public void traceFromEyes(float partialTicks) {
        this.projectedVector = null;
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        if (renderView != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.CLIENT.getShoulderSurfing3ppId()) {
            double playerReach = Config.CLIENT.showCrosshairFarther() ? 400.0 : (double)Minecraft.func_71410_x().field_71442_b.func_78757_d();
            double blockDist = 0.0;
            RayTraceResult result = renderView.func_174822_a(playerReach, partialTicks, RayTraceFluidMode.NEVER);
            if (result != null) {
                this.rayTraceHit = result.field_72307_f;
                blockDist = result.field_72307_f.func_72438_d(new Vec3d(renderView.field_70165_t, renderView.field_70163_u, renderView.field_70161_v));
                this.rayTraceInReach = blockDist <= (double)Minecraft.func_71410_x().field_71442_b.func_78757_d();
            } else {
                this.rayTraceHit = null;
            }
            Vec3d renderViewPos = renderView.func_174824_e(partialTicks);
            Vec3d sightVector = renderView.func_70676_i(partialTicks);
            Vec3d sightRay = renderViewPos.func_72441_c(sightVector.field_72450_a * playerReach - 5.0, sightVector.field_72448_b * playerReach, sightVector.field_72449_c * playerReach);
            List entityList = Minecraft.func_71410_x().field_71441_e.func_72839_b(renderView, renderView.func_174813_aQ().func_72321_a(sightVector.field_72450_a * playerReach, sightVector.field_72448_b * playerReach, sightVector.field_72449_c * playerReach).func_72321_a(1.0, 1.0, 1.0));
            for (Entity entity : entityList) {
                double entityDist;
                if (!entity.func_70067_L()) continue;
                float collisionSize = entity.func_70111_Y();
                AxisAlignedBB aabb = entity.func_174813_aQ().func_72321_a((double)collisionSize, (double)collisionSize, (double)collisionSize);
                RayTraceResult potentialIntercept = aabb.func_72327_a(renderViewPos, sightRay);
                if (potentialIntercept == null || !((entityDist = potentialIntercept.field_72307_f.func_72438_d(new Vec3d(renderView.field_70165_t, renderView.field_70163_u, renderView.field_70161_v))) < blockDist)) continue;
                this.rayTraceHit = potentialIntercept.field_72307_f;
                this.rayTraceInReach = entityDist <= (double)Minecraft.func_71410_x().field_71442_b.func_78757_d();
            }
        }
    }

    public boolean isRayTraceInReach() {
        return this.rayTraceInReach;
    }

    public void setRayTraceInReach(boolean rayTraceInReach) {
        this.rayTraceInReach = rayTraceInReach;
    }

    public boolean skipPlayerRender() {
        return this.skipPlayerRender;
    }

    public void setSkipPlayerRender(boolean skipPlayerRender) {
        this.skipPlayerRender = skipPlayerRender;
    }

    public Vec2f getProjectedVector() {
        return this.projectedVector;
    }

    public void setProjectedVector(Vec2f projectedVector) {
        this.projectedVector = projectedVector;
    }

    public Vec3d getRayTraceHit() {
        return this.rayTraceHit;
    }

    public void setRayTraceHit(Vec3d rayTraceHit) {
        this.rayTraceHit = rayTraceHit;
    }
}

