/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.event.ClientEventHandler;
import com.teamderpy.shouldersurfing.math.RayTracer;
import com.teamderpy.shouldersurfing.math.VectorConverter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class InjectionDelegation {
    private static double cameraDistance = 0.0;

    public static float getShoulderRotationYaw() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
            return (float)Config.CLIENT.getShoulderRotationYaw();
        }
        return 0.0f;
    }

    public static float getShoulderRotationPitch() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
            return 0.0f;
        }
        return 0.0f;
    }

    public static float getShoulderZoomMod() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
            return (float)Config.CLIENT.getShoulderZoomMod();
        }
        return 1.0f;
    }

    public static void calculateRayTraceProjection() {
        if (RayTracer.getRayTraceHit() != null) {
            RayTracer.setProjectedVector(VectorConverter.project2D(RayTracer.getRayTraceHit()));
            RayTracer.setRayTraceHit(null);
        }
    }

    public static int getMax3ppId() {
        if (Config.CLIENT.replaceDefaultPerspective()) {
            return 2;
        }
        return 3;
    }

    public static double calcCameraDistance(double distance, ActiveRenderInfo info) {
        double result = distance;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
            float radiant = (float)Math.PI / 180;
            float radiantYaw = info.func_216778_f() * ((float)Math.PI / 180);
            double yawXZlength = (double)MathHelper.func_76126_a((float)(InjectionDelegation.getShoulderRotationYaw() * ((float)Math.PI / 180))) * distance;
            double yawX = (double)MathHelper.func_76134_b((float)radiantYaw) * yawXZlength;
            double yawZ = (double)MathHelper.func_76126_a((float)radiantYaw) * yawXZlength;
            for (int i = 0; i < 8; ++i) {
                double newDistance;
                Vec3d vec3d1;
                float offsetX = (i & 1) * 2 - 1;
                float offsetY = (i >> 1 & 1) * 2 - 1;
                float offsetZ = (i >> 2 & 1) * 2 - 1;
                Vec3d vec3d = info.func_216785_c().func_72441_c((double)(offsetX *= 0.1f), (double)(offsetY *= 0.1f), (double)(offsetZ *= 0.1f));
                BlockRayTraceResult raytraceresult = Minecraft.func_71410_x().field_71441_e.func_217299_a(new RayTraceContext(vec3d, vec3d1 = new Vec3d(info.func_216785_c().field_72450_a - info.func_216787_l().field_72450_a * distance + (double)offsetX + (double)offsetZ + yawX, info.func_216785_c().field_72448_b - info.func_216787_l().field_72448_b * distance + (double)offsetY, info.func_216785_c().field_72449_c - info.func_216787_l().field_72449_c * distance + (double)offsetZ + yawZ), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, Minecraft.func_71410_x().field_175622_Z));
                if (raytraceresult == null || !((newDistance = raytraceresult.func_216347_e().func_72438_d(info.func_216785_c())) < result)) continue;
                result = newDistance;
            }
        }
        ClientEventHandler.skipRenderPlayer = distance < 0.8;
        cameraDistance = result;
        return cameraDistance;
    }

    public static Vec3d getEyePosition(Entity entity, Vec3d positionEyes) {
        if (!Config.CLIENT.getCrosshairType().isDynamic()) {
            float radiant = (float)Math.PI / 180;
            float radiantPitch = entity.field_70125_A * ((float)Math.PI / 180);
            float radiantYaw = entity.field_70177_z * ((float)Math.PI / 180);
            double pitchYLength = (double)MathHelper.func_76126_a((float)(InjectionDelegation.getShoulderRotationPitch() * ((float)Math.PI / 180))) * cameraDistance;
            double pitchX = (double)(MathHelper.func_76126_a((float)radiantPitch) * MathHelper.func_76126_a((float)(-radiantYaw))) * pitchYLength;
            double pitchY = (double)MathHelper.func_76134_b((float)radiantPitch) * pitchYLength;
            double pitchZ = (double)(MathHelper.func_76126_a((float)radiantPitch) * MathHelper.func_76134_b((float)(-radiantYaw))) * pitchYLength;
            double yawXZlength = (double)MathHelper.func_76126_a((float)(InjectionDelegation.getShoulderRotationYaw() * ((float)Math.PI / 180))) * cameraDistance;
            double yawX = (double)MathHelper.func_76134_b((float)radiantYaw) * yawXZlength;
            double yawZ = (double)MathHelper.func_76126_a((float)radiantYaw) * yawXZlength;
            return positionEyes.func_72441_c(yawX, 0.0, yawZ).func_72441_c(pitchX, pitchY, pitchZ);
        }
        return positionEyes;
    }

    public static int doRenderCrosshair() {
        int skipRender = 0;
        if (!Config.CLIENT.getCrosshairVisibility().doRender()) {
            skipRender = 1;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O != Config.ClientConfig.Perspective.FIRST_PERSON.getPerspectiveId() && !Config.CLIENT.show3ppCrosshair()) {
            skipRender = 1;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.FIRST_PERSON.getPerspectiveId() && !Config.CLIENT.show1ppCrosshair()) {
            skipRender = 1;
        }
        return skipRender;
    }

    public static void movePosition(ActiveRenderInfo info, double x, double y, double z) {
        float radiant = (float)Math.PI / 180;
        float radiantYaw = InjectionDelegation.getShoulderRotationYaw() * ((float)Math.PI / 180);
        double yawX = (double)MathHelper.func_76134_b((float)radiantYaw) * cameraDistance;
        double yawZ = (double)MathHelper.func_76126_a((float)radiantYaw) * cameraDistance;
        info.func_216782_a(-yawX, 0.0, yawZ);
    }
}

