/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.math.RayTracer;
import com.teamderpy.shouldersurfing.math.Vec2f;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static Vec2f lastTickTranslation = Vec2f.ZERO;
    private static Vec2f translation = Vec2f.ZERO;
    private static boolean switchPerspective;
    public static boolean isAiming;
    public static boolean skipRenderPlayer;

    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                if (!isAiming && ClientEventHandler.isHoldingSpecialItem()) {
                    if (Config.CLIENT.getCrosshairType().doSwitchPerspective() && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
                        Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
                        switchPerspective = true;
                    }
                    isAiming = true;
                } else if (isAiming && !ClientEventHandler.isHoldingSpecialItem()) {
                    if (!Config.CLIENT.getCrosshairType().doSwitchPerspective() && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && switchPerspective) {
                        Minecraft.func_71410_x().field_71474_y.field_74320_O = Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId();
                        switchPerspective = false;
                    }
                    isAiming = false;
                }
            }
            skipRenderPlayer = false;
            RayTracer.traceFromEyes(1.0f);
            if (RayTracer.getRayTraceHit() != null && Minecraft.func_71410_x().field_71439_g != null) {
                RayTracer.setRayTraceHit(RayTracer.getRayTraceHit().func_178788_d(Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c()));
            }
        }
    }

    @SubscribeEvent
    public static void preRenderPlayerEvent(RenderPlayerEvent.Pre event) {
        if (event.getPlayer().equals((Object)Minecraft.func_71410_x().field_71439_g) && skipRenderPlayer && Config.CLIENT.keepCameraOutOfHead() && Minecraft.func_71410_x().field_71462_r == null && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS) && Minecraft.func_71410_x().field_71462_r == null) {
            float scale = (float)Minecraft.func_71410_x().field_195558_d.func_216521_a(Minecraft.func_71410_x().field_71474_y.field_74335_Z, Minecraft.func_71410_x().func_211821_e()) * ShoulderSurfing.getShadersResMul();
            Vec2f window = new Vec2f(Minecraft.func_71410_x().field_195558_d.func_198107_o(), Minecraft.func_71410_x().field_195558_d.func_198087_p());
            Vec2f center = window.scale(scale).divide(2.0f);
            if (RayTracer.getProjectedVector() != null) {
                Vec2f projectedOffset = RayTracer.getProjectedVector().subtract(center).divide(scale);
                translation = lastTickTranslation.add(projectedOffset.subtract(lastTickTranslation).scale(event.getPartialTicks()));
            }
            if (Config.CLIENT.getCrosshairType().isDynamic() && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
                GlStateManager.translatef((float)translation.getX(), (float)translation.getY(), (float)0.0f);
                lastTickTranslation = translation;
            } else {
                lastTickTranslation = Vec2f.ZERO;
            }
        }
    }

    @SubscribeEvent
    public static void postRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS) && Minecraft.func_71410_x().field_71462_r == null && Config.CLIENT.getCrosshairType().isDynamic() && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
            GlStateManager.translatef((float)(-translation.getX()), (float)(-translation.getY()), (float)0.0f);
        }
    }

    public static boolean isHoldingSpecialItem() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Item item = Minecraft.func_71410_x().field_71439_g.func_184607_cu().func_77973_b();
            if (item.func_185040_i() && (item.func_185045_a(new ResourceLocation("pull")) != null || item.func_185045_a(new ResourceLocation("throwing")) != null)) {
                return true;
            }
            for (ItemStack held : Minecraft.func_71410_x().field_71439_g.func_184214_aD()) {
                if (!held.func_77973_b().func_185040_i() || held.func_77973_b().func_185045_a(new ResourceLocation("charged")) == null) continue;
                return true;
            }
        }
        return false;
    }
}

