/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.math;

import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.math.Vec2f;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RayTracer {
    private static Vec2f projectedVector = null;
    private static Vec3d rayTraceHit = null;

    public static void traceFromEyes(float partialTicks) {
        projectedVector = null;
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        if (renderView != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
            double playerReach = Config.CLIENT.showCrosshairFarther() ? 400.0 : (double)Minecraft.func_71410_x().field_71442_b.func_78757_d();
            double blockDist = 0.0;
            RayTraceResult result = renderView.func_213324_a(playerReach, partialTicks, false);
            if (result != null) {
                rayTraceHit = result.func_216347_e();
                blockDist = result.func_216347_e().func_72438_d(new Vec3d(renderView.field_70165_t, renderView.field_70163_u, renderView.field_70161_v));
            } else {
                rayTraceHit = null;
            }
            Vec3d renderViewPos = renderView.func_174824_e(partialTicks);
            Vec3d sightVector = renderView.func_70676_i(partialTicks);
            Vec3d sightRay = renderViewPos.func_72441_c(sightVector.field_72450_a * playerReach - 5.0, sightVector.field_72448_b * playerReach, sightVector.field_72449_c * playerReach);
            List entityList = Minecraft.func_71410_x().field_71441_e.func_72839_b(renderView, renderView.func_174813_aQ().func_72321_a(sightVector.field_72450_a * playerReach, sightVector.field_72448_b * playerReach, sightVector.field_72449_c * playerReach).func_72321_a(1.0, 1.0, 1.0));
            for (Entity entity : entityList) {
                double entityDist;
                if (!entity.func_70067_L()) continue;
                float collisionSize = entity.func_70111_Y();
                AxisAlignedBB aabb = entity.func_174813_aQ().func_72321_a((double)collisionSize, (double)collisionSize, (double)collisionSize);
                Optional intercept = aabb.func_216365_b(renderViewPos, sightRay);
                if (!intercept.isPresent() || !((entityDist = ((Vec3d)intercept.get()).func_72438_d(new Vec3d(renderView.field_70165_t, renderView.field_70163_u, renderView.field_70161_v))) < blockDist)) continue;
                rayTraceHit = (Vec3d)intercept.get();
            }
        }
    }

    public static Vec2f getProjectedVector() {
        return projectedVector;
    }

    public static void setProjectedVector(Vec2f projectedVector) {
        RayTracer.projectedVector = projectedVector;
    }

    public static Vec3d getRayTraceHit() {
        return rayTraceHit;
    }

    public static void setRayTraceHit(Vec3d rayTraceHit) {
        RayTracer.rayTraceHit = rayTraceHit;
    }
}

