/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.math;

import com.teamderpy.shouldersurfing.math.Vec2f;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class VectorConverter {
    public static Vec2f project2D(Vec3d v3) {
        return VectorConverter.project2D((float)v3.field_72450_a, (float)v3.field_72448_b, (float)v3.field_72449_c);
    }

    public static Vec2f project2D(float x, float y, float z) {
        FloatBuffer screen_coords = GLAllocation.func_74529_h((int)3);
        IntBuffer viewport = GLAllocation.func_74524_c((int)64).asIntBuffer();
        FloatBuffer modelview = GLAllocation.func_74529_h((int)16);
        FloatBuffer projection = GLAllocation.func_74529_h((int)16);
        screen_coords.clear();
        modelview.clear();
        projection.clear();
        viewport.clear();
        GL11.glGetFloatv((int)2982, (FloatBuffer)modelview);
        GL11.glGetFloatv((int)2983, (FloatBuffer)projection);
        GL11.glGetIntegerv((int)2978, (IntBuffer)viewport);
        if (VectorConverter.uProject(x, y, z, modelview, projection, viewport, screen_coords)) {
            float screenX = screen_coords.get(0);
            float screenY = screen_coords.get(1);
            if (!Float.isInfinite(screenX) && !Float.isInfinite(screenY)) {
                return new Vec2f(screenX, screenY);
            }
        }
        return null;
    }

    private static void multMatrixVecf(FloatBuffer m, float[] in, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = in[0] * m.get(m.position() + i) + in[1] * m.get(m.position() + 4 + i) + in[2] * m.get(m.position() + 8 + i) + in[3] * m.get(m.position() + 12 + i);
        }
    }

    private static boolean uProject(float objx, float objy, float objz, FloatBuffer modelMatrix, FloatBuffer projMatrix, IntBuffer viewport, FloatBuffer win_pos) {
        float[] in = new float[4];
        float[] out = new float[4];
        in[0] = objx;
        in[1] = objy;
        in[2] = objz;
        in[3] = 1.0f;
        VectorConverter.multMatrixVecf(modelMatrix, in, out);
        VectorConverter.multMatrixVecf(projMatrix, out, in);
        if (in[3] == 0.0f) {
            return false;
        }
        in[3] = 1.0f / in[3] * 0.5f;
        in[0] = in[0] * in[3] + 0.5f;
        in[1] = in[1] * in[3] + 0.5f;
        in[2] = in[2] * in[3] + 0.5f;
        win_pos.put(0, in[0] * (float)viewport.get(viewport.position() + 2) + (float)viewport.get(viewport.position()));
        win_pos.put(1, in[1] * (float)viewport.get(viewport.position() + 3) + (float)viewport.get(viewport.position() + 1));
        win_pos.put(2, in[2]);
        return true;
    }
}

