/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.teamderpy.shouldersurfing.event.ClientEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    private static ModConfig MOD_CONFIG;
    private static CommentedFileConfig CONFIG_DATA;

    protected static <T> void set(ForgeConfigSpec.ConfigValue<T> configValue, T value) {
        if (value != null && !value.equals(configValue.get())) {
            CONFIG_DATA.set(configValue.getPath(), value);
        }
    }

    @SubscribeEvent
    public static void configLoad(ModConfig.Loading event) {
        if (event.getConfig().getType().equals((Object)ModConfig.Type.CLIENT)) {
            MOD_CONFIG = event.getConfig();
            CONFIG_DATA = (CommentedFileConfig)MOD_CONFIG.getConfigData();
        }
    }

    @SubscribeEvent
    public static void configReload(ModConfig.Reloading event) {
        if (event.getConfig().getType().equals((Object)ModConfig.Type.CLIENT) && CONFIG_DATA != null) {
            CONFIG_DATA.load();
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 3 && CLIENT.replaceDefaultPerspective()) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
            } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && !CLIENT.replaceDefaultPerspective()) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 3;
            }
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        CLIENT = (ClientConfig)pair.getLeft();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientConfig {
        private final ForgeConfigSpec.DoubleValue shoulderRotationYaw;
        private final ForgeConfigSpec.DoubleValue shoulderZoomMod;
        private final ForgeConfigSpec.BooleanValue unlimitedRotation;
        private final ForgeConfigSpec.DoubleValue rotationMin;
        private final ForgeConfigSpec.DoubleValue rotationMax;
        private final ForgeConfigSpec.BooleanValue unlimitedZoom;
        private final ForgeConfigSpec.DoubleValue zoomMin;
        private final ForgeConfigSpec.DoubleValue zoomMax;
        private final ForgeConfigSpec.BooleanValue show3ppCrosshair;
        private final ForgeConfigSpec.BooleanValue show1ppCrosshair;
        private final ForgeConfigSpec.ConfigValue<CrosshairVisibility> crosshairVisibility;
        private final ForgeConfigSpec.BooleanValue showCrosshairFarther;
        private final ForgeConfigSpec.BooleanValue keepCameraOutOfHead;
        private final ForgeConfigSpec.BooleanValue attackIndicator;
        private final ForgeConfigSpec.BooleanValue replaceDefaultPerspective;
        private final ForgeConfigSpec.ConfigValue<Perspective> defaultPerspective;
        private final ForgeConfigSpec.ConfigValue<CrosshairType> crosshairType;
        private final ForgeConfigSpec.BooleanValue rememberLastPerspective;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.shoulderRotationYaw = builder.comment("Third person camera rotation").translation("Rotation Offset").defineInRange("rotation_offset", 0.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.shoulderZoomMod = builder.comment("Third person camera zoom").translation("Zoom Offset").defineInRange("zoom_offset", 0.7, -1.7976931348623157E308, Double.MAX_VALUE);
            this.unlimitedRotation = builder.comment("Whether or not rotation adjustment has limits").translation("Unlimited Rotation").define("unlimited_rotation", false);
            this.rotationMin = builder.comment("If rotation is limited this is the minimum amount").translation("Rotation Minimum").defineInRange("rotation_min", -60.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.rotationMax = builder.comment("If rotation is limited this is the maximum amount").translation("Rotation Maximum").defineInRange("rotation_max", 60.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.unlimitedZoom = builder.comment("Whether or not zoom adjustment has limits").translation("Unlimited Zoom").define("unlimited_zoom", false);
            this.zoomMin = builder.comment("If zoom is limited this is the minimum amount").translation("Zoom Minimum").defineInRange("zoom_min", 0.3, -1.7976931348623157E308, Double.MAX_VALUE);
            this.zoomMax = builder.comment("If zoom is limited this is the maximum amount").translation("Zoom Maximum").defineInRange("zoom_max", 2.0, -1.7976931348623157E308, Double.MAX_VALUE);
            this.show3ppCrosshair = builder.comment("Enable or disable the crosshair in third person").translation("Third Person Crosshair").define("3pp_crosshair", true);
            this.show1ppCrosshair = builder.comment("Enable or disable the crosshair in first person").translation("First Person Crosshair").define("1pp_crosshair", true);
            this.crosshairVisibility = builder.comment("Crosshair visibility in 3PP").translation("Crosshair Visibility").defineEnum("crosshair_visibility", (Enum)CrosshairVisibility.ALWAYS, (Enum[])CrosshairVisibility.values());
            this.showCrosshairFarther = builder.comment("Whether or not to show the crosshairs farther than normal").translation("Show Crosshair Farther").define("show_crosshair_farther", true);
            this.keepCameraOutOfHead = builder.comment("Whether or not to hide the player model if the camera gets too close to it").translation("Keep Camera Out Of Head").define("keep_camera_out_of_head", true);
            this.attackIndicator = builder.comment("Enable or disable the attack indicator in third person").translation("Third Person Attack Indicator").define("third_person_attack_indicator", true);
            this.replaceDefaultPerspective = builder.comment("Whether or not to replace the default third person perspective").translation("Replace Default Perspective").define("replace_default_perspective", false);
            this.defaultPerspective = builder.comment("The default perspective when you load the game").translation("Default Perspective").defineEnum("default_perspective", (Enum)Perspective.SHOULDER_SURFING, (Enum[])Perspective.values());
            this.crosshairType = builder.comment("Crosshair type to use in 3PP").translation("Crosshair type").defineEnum("crosshair_type", (Enum)CrosshairType.ADAPTIVE, (Enum[])CrosshairType.values());
            this.rememberLastPerspective = builder.comment("Whether or not to remember the last perspective used").translation("Remember Last Perspective").define("remember_last_perspective", true);
        }

        public double getShoulderRotationYaw() {
            return (Double)this.shoulderRotationYaw.get();
        }

        public void setShoulderRotationYaw(double yaw) {
            Config.set(this.shoulderRotationYaw, yaw);
        }

        public double getShoulderZoomMod() {
            return (Double)this.shoulderZoomMod.get();
        }

        public void setShoulderZoomMod(double zoomMod) {
            Config.set(this.shoulderZoomMod, zoomMod);
        }

        public boolean isRotationUnlimited() {
            return (Boolean)this.unlimitedRotation.get();
        }

        public void setRotationUnlimited(boolean enabled) {
            Config.set(this.unlimitedRotation, enabled);
        }

        public double getRotationMin() {
            return (Double)this.rotationMin.get();
        }

        public void setRotationMin(double min) {
            Config.set(this.rotationMin, min);
        }

        public double getRotationMax() {
            return (Double)this.rotationMax.get();
        }

        public void setRotationMax(double max) {
            Config.set(this.rotationMax, max);
        }

        public boolean isZoomUnlimited() {
            return (Boolean)this.unlimitedZoom.get();
        }

        public void setZoomUnlimited(boolean enabled) {
            Config.set(this.unlimitedZoom, enabled);
        }

        public double getZoomMin() {
            return (Double)this.zoomMin.get();
        }

        public void setZoomMin(double min) {
            Config.set(this.zoomMin, min);
        }

        public double getZoomMax() {
            return (Double)this.zoomMax.get();
        }

        public void setZoomMax(double max) {
            Config.set(this.rotationMax, max);
        }

        public boolean show3ppCrosshair() {
            return (Boolean)this.show3ppCrosshair.get();
        }

        public void setShow3ppCrosshair(boolean enabled) {
            Config.set(this.show3ppCrosshair, enabled);
        }

        public boolean show1ppCrosshair() {
            return (Boolean)this.show1ppCrosshair.get();
        }

        public void setShow1ppCrosshair(boolean enabled) {
            Config.set(this.show1ppCrosshair, enabled);
        }

        public CrosshairVisibility getCrosshairVisibility() {
            return (CrosshairVisibility)((Object)this.crosshairVisibility.get());
        }

        public void setCrosshairVisibility(CrosshairVisibility visibility) {
            Config.set(this.crosshairVisibility, visibility);
        }

        public boolean showCrosshairFarther() {
            return (Boolean)this.showCrosshairFarther.get();
        }

        public void setShowCrosshairFarther(boolean enabled) {
            Config.set(this.showCrosshairFarther, enabled);
        }

        public boolean keepCameraOutOfHead() {
            return (Boolean)this.keepCameraOutOfHead.get();
        }

        public void setKeepCameraOutOfHead(boolean enabled) {
            Config.set(this.keepCameraOutOfHead, enabled);
        }

        public boolean showAttackIndicator() {
            return (Boolean)this.attackIndicator.get();
        }

        public void setShowAttackIndicator(boolean enabled) {
            Config.set(this.attackIndicator, enabled);
        }

        public boolean replaceDefaultPerspective() {
            return (Boolean)this.replaceDefaultPerspective.get();
        }

        public void setReplaceDefaultPerspective(boolean enabled) {
            Config.set(this.replaceDefaultPerspective, enabled);
        }

        public Perspective getDefaultPerspective() {
            return (Perspective)((Object)this.defaultPerspective.get());
        }

        public void setDefaultPerspective(Perspective perspective) {
            Config.set(this.defaultPerspective, perspective);
        }

        public CrosshairType getCrosshairType() {
            return (CrosshairType)((Object)this.crosshairType.get());
        }

        public void setCrosshairType(CrosshairType type) {
            Config.set(this.crosshairType, type);
        }

        public boolean doRememberLastPerspective() {
            return (Boolean)this.rememberLastPerspective.get();
        }

        public void setRememberLastPerspective(boolean enabled) {
            Config.set(this.rememberLastPerspective, enabled);
        }

        public int getShoulderSurfing3ppId() {
            if (this.replaceDefaultPerspective()) {
                return 1;
            }
            return 3;
        }

        public void adjustCameraLeft() {
            if (this.isRotationUnlimited() || this.getShoulderRotationYaw() < this.getRotationMax()) {
                this.setShoulderRotationYaw(this.getShoulderRotationYaw() + 0.5);
            }
        }

        public void adjustCameraRight() {
            if (this.isRotationUnlimited() || this.getShoulderRotationYaw() > this.getRotationMin()) {
                this.setShoulderRotationYaw(this.getShoulderRotationYaw() - 0.5);
            }
        }

        public void adjustCameraIn() {
            if (this.isZoomUnlimited() || this.getShoulderZoomMod() < this.getZoomMax()) {
                this.setShoulderZoomMod(this.getShoulderZoomMod() + (double)0.01f);
            }
        }

        public void adjustCameraOut() {
            if (this.isZoomUnlimited() || this.getShoulderZoomMod() > this.getZoomMin()) {
                this.setShoulderZoomMod(this.getShoulderZoomMod() - (double)0.01f);
            }
        }

        public void swapShoulder() {
            this.setShoulderRotationYaw(-this.getShoulderRotationYaw());
        }

        @OnlyIn(value=Dist.CLIENT)
        public static enum CrosshairVisibility {
            ALWAYS,
            WHEN_AIMING,
            WHEN_IN_RANGE,
            WHEN_AIMING_OR_IN_RANGE;


            public boolean doRender() {
                if (this == WHEN_AIMING) {
                    return ClientEventHandler.isAiming;
                }
                if (this == WHEN_IN_RANGE) {
                    return Minecraft.func_71410_x().field_71476_x != null && !Minecraft.func_71410_x().field_71476_x.func_216346_c().equals((Object)RayTraceResult.Type.MISS);
                }
                if (this == WHEN_AIMING_OR_IN_RANGE) {
                    return WHEN_IN_RANGE.doRender() || WHEN_AIMING.doRender();
                }
                return true;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static enum Perspective {
            FIRST_PERSON,
            THIRD_PERSON,
            FRONT_THIRD_PERSON,
            SHOULDER_SURFING;


            public int getPerspectiveId() {
                if (this == SHOULDER_SURFING) {
                    return CLIENT.getShoulderSurfing3ppId();
                }
                return this.ordinal();
            }

            public static Perspective of(int id) {
                if (id == SHOULDER_SURFING.getPerspectiveId()) {
                    return SHOULDER_SURFING;
                }
                if (id >= 0 && id <= 2) {
                    return Perspective.values()[id];
                }
                return FIRST_PERSON;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static enum CrosshairType {
            ADAPTIVE,
            DYNAMIC,
            STATIC,
            STATIC_WITH_1PP;


            public boolean isDynamic() {
                if (this == ADAPTIVE) {
                    return ClientEventHandler.isHoldingSpecialItem();
                }
                return this == DYNAMIC;
            }

            public boolean doSwitchPerspective() {
                if (this == STATIC_WITH_1PP) {
                    return ClientEventHandler.isHoldingSpecialItem();
                }
                return false;
            }
        }
    }
}

