/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.asm.InjectionDelegation;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.math.RayTracer;
import com.teamderpy.shouldersurfing.math.Vec2f;
import com.teamderpy.shouldersurfing.math.VectorConverter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static Vec2f lastTickTranslation = Vec2f.ZERO;
    private static Vec2f translation = Vec2f.ZERO;
    private static boolean switchPerspective;
    public static boolean isAiming;

    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                if (!isAiming && ClientEventHandler.isHoldingSpecialItem()) {
                    if (Config.CLIENT.getCrosshairType().doSwitchPerspective() && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
                        Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
                        switchPerspective = true;
                    }
                    isAiming = true;
                } else if (isAiming && !ClientEventHandler.isHoldingSpecialItem()) {
                    if (!Config.CLIENT.getCrosshairType().doSwitchPerspective() && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && switchPerspective) {
                        Minecraft.func_71410_x().field_71474_y.field_74320_O = Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId();
                        switchPerspective = false;
                    }
                    isAiming = false;
                }
            }
            RayTracer.traceFromEyes(1.0f);
            if (RayTracer.getRayTraceHit() != null && Minecraft.func_71410_x().field_71439_g != null) {
                RayTracer.setRayTraceHit(RayTracer.getRayTraceHit().func_178788_d(Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c()));
            }
        }
    }

    @SubscribeEvent
    public static void preRenderPlayerEvent(RenderPlayerEvent.Pre event) {
        if (event.getPlayer().equals((Object)Minecraft.func_71410_x().field_71439_g) && InjectionDelegation.cameraDistance < 0.8 && Config.CLIENT.keepCameraOutOfHead() && Minecraft.func_71410_x().field_71462_r == null && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS) && Minecraft.func_71410_x().field_71462_r == null) {
            float scale = (float)Minecraft.func_71410_x().func_228018_at_().func_216521_a(Minecraft.func_71410_x().field_71474_y.field_74335_Z, Minecraft.func_71410_x().func_211821_e()) * ShoulderSurfing.getShadersResMul();
            Vec2f window = new Vec2f(Minecraft.func_71410_x().func_228018_at_().func_198107_o(), Minecraft.func_71410_x().func_228018_at_().func_198087_p());
            Vec2f center = window.scale(scale).divide(2.0f);
            if (RayTracer.getProjectedVector() != null) {
                Vec2f projectedOffset = RayTracer.getProjectedVector().subtract(center).divide(scale);
                translation = lastTickTranslation.add(projectedOffset.subtract(lastTickTranslation).scale(event.getPartialTicks()));
            }
            if (Config.CLIENT.getCrosshairType().isDynamic() && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
                RenderSystem.translatef((float)translation.getX(), (float)translation.getY(), (float)0.0f);
                lastTickTranslation = translation;
            } else {
                lastTickTranslation = Vec2f.ZERO;
            }
        }
    }

    @SubscribeEvent
    public static void postRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS) && Minecraft.func_71410_x().field_71462_r == null && Config.CLIENT.getCrosshairType().isDynamic() && Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
            RenderSystem.translatef((float)(-translation.getX()), (float)(-translation.getY()), (float)0.0f);
        }
    }

    @SubscribeEvent
    public static void cameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == Config.ClientConfig.Perspective.SHOULDER_SURFING.getPerspectiveId()) {
            ActiveRenderInfo info = event.getInfo();
            double x = MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)info.func_216773_g().field_70169_q, (double)info.func_216773_g().func_226277_ct_());
            double y = MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)info.func_216773_g().field_70167_r, (double)info.func_216773_g().func_226278_cu_()) + MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)info.field_216802_n, (double)info.field_216801_m);
            double z = MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)info.func_216773_g().field_70166_s, (double)info.func_216773_g().func_226281_cx_());
            info.func_216775_b(x, y, z);
            InjectionDelegation.cameraDistance = ClientEventHandler.calcCameraDistance(info, event.getInfo().func_216779_a(4.0));
            float radiantYaw = (float)Math.toRadians(InjectionDelegation.getShoulderRotationYaw());
            double yawX = (double)MathHelper.func_76134_b((float)radiantYaw) * InjectionDelegation.cameraDistance;
            double yawZ = (double)MathHelper.func_76126_a((float)radiantYaw) * InjectionDelegation.cameraDistance;
            event.getInfo().func_216782_a(-yawX, 0.0, yawZ);
        }
    }

    @SubscribeEvent
    public static void renderWorldLast(RenderWorldLastEvent event) {
        if (RayTracer.getRayTraceHit() != null) {
            RayTracer.setProjectedVector(VectorConverter.project2D(RayTracer.getRayTraceHit(), event.getMatrixStack(), event.getProjectionMatrix()));
            RayTracer.setRayTraceHit(null);
        }
    }

    private static double calcCameraDistance(ActiveRenderInfo info, double distance) {
        double result = distance;
        float radiantYaw = (float)Math.toRadians(info.func_216778_f());
        double yawXZlength = (double)MathHelper.func_76126_a((float)((float)Math.toRadians(Config.CLIENT.getShoulderRotationYaw()))) * distance;
        double yawX = (double)MathHelper.func_76134_b((float)radiantYaw) * yawXZlength;
        double yawZ = (double)MathHelper.func_76126_a((float)radiantYaw) * yawXZlength;
        Vec3d view = info.func_216785_c();
        for (int i = 0; i < 8; ++i) {
            double newDistance;
            Vec3d camera;
            BlockRayTraceResult raytraceresult;
            float offsetX = (i & 1) * 2 - 1;
            float offsetY = (i >> 1 & 1) * 2 - 1;
            float offsetZ = (i >> 2 & 1) * 2 - 1;
            Vec3d head = view.func_72441_c((double)(offsetX *= 0.1f), (double)(offsetY *= 0.1f), (double)(offsetZ *= 0.1f));
            if ((raytraceresult = Minecraft.func_71410_x().field_71441_e.func_217299_a(new RayTraceContext(head, camera = new Vec3d(view.field_72450_a - (double)info.func_227996_l_().func_195899_a() * distance + (double)offsetX + (double)offsetZ + yawX, view.field_72448_b - (double)info.func_227996_l_().func_195900_b() * distance + (double)offsetY, view.field_72449_c - (double)info.func_227996_l_().func_195902_c() * distance + (double)offsetZ + yawZ), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, Minecraft.func_71410_x().field_175622_Z))) == null || !((newDistance = raytraceresult.func_216347_e().func_72438_d(info.func_216785_c())) < result)) continue;
            result = newDistance;
        }
        return result;
    }

    public static boolean isHoldingSpecialItem() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Item item = Minecraft.func_71410_x().field_71439_g.func_184607_cu().func_77973_b();
            if (item.func_185040_i() && (item.func_185045_a(new ResourceLocation("pull")) != null || item.func_185045_a(new ResourceLocation("throwing")) != null)) {
                return true;
            }
            for (ItemStack held : Minecraft.func_71410_x().field_71439_g.func_184214_aD()) {
                if (!held.func_77973_b().func_185040_i() || held.func_77973_b().func_185045_a(new ResourceLocation("charged")) == null) continue;
                return true;
            }
        }
        return false;
    }
}

