/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.math;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.teamderpy.shouldersurfing.math.Vec2f;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class VectorConverter {
    public static Vec2f project2D(Vec3d position, MatrixStack matrixStackIn, Matrix4f projectionIn) {
        IntBuffer viewport = GLAllocation.func_74524_c((int)64).asIntBuffer();
        FloatBuffer modelview = GLAllocation.func_74529_h((int)16);
        FloatBuffer projection = GLAllocation.func_74529_h((int)16);
        modelview.clear();
        projection.clear();
        viewport.clear();
        matrixStackIn.func_227866_c_().func_227870_a_().func_195879_b(modelview);
        projectionIn.func_195879_b(projection);
        GL11.glGetIntegerv((int)2978, (IntBuffer)viewport);
        Vec2f screen = VectorConverter.uProject(position, modelview, projection, viewport);
        if (screen == null || Float.isInfinite(screen.getX()) || Float.isInfinite(screen.getY())) {
            return null;
        }
        return screen;
    }

    private static void multMatrixVecf(FloatBuffer m, float[] in, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = in[0] * m.get(m.position() + i) + in[1] * m.get(m.position() + 4 + i) + in[2] * m.get(m.position() + 8 + i) + in[3] * m.get(m.position() + 12 + i);
        }
    }

    private static Vec2f uProject(Vec3d position, FloatBuffer modelMatrix, FloatBuffer projMatrix, IntBuffer viewport) {
        float[] in = new float[4];
        float[] out = new float[4];
        in[0] = (float)position.func_82615_a();
        in[1] = (float)position.func_82617_b();
        in[2] = (float)position.func_82616_c();
        in[3] = 1.0f;
        VectorConverter.multMatrixVecf(modelMatrix, in, out);
        VectorConverter.multMatrixVecf(projMatrix, out, in);
        if (in[3] == 0.0f) {
            return null;
        }
        in[3] = 1.0f / in[3] * 0.5f;
        in[0] = in[0] * in[3] + 0.5f;
        in[1] = in[1] * in[3] + 0.5f;
        in[2] = in[2] * in[3] + 0.5f;
        float x = in[0] * (float)viewport.get(viewport.position() + 2) + (float)viewport.get(viewport.position());
        float y = in[1] * (float)viewport.get(viewport.position() + 3) + (float)viewport.get(viewport.position() + 1);
        return new Vec2f(x, y);
    }
}

