/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing;

import com.teamderpy.shouldersurfing.ShoulderCamera;
import com.teamderpy.shouldersurfing.ShoulderSettings;
import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.math.RayTracer;
import com.teamderpy.shouldersurfing.renderer.ShoulderRenderBin;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ShoulderEventHandler {
    private static float lastX = 0.0f;
    private static float lastY = 0.0f;

    @SubscribeEvent
    public void renderEvent(TickEvent.RenderTickEvent event) {
        ShoulderRenderBin.skipPlayerRender = false;
        RayTracer.traceFromEyes(1.0f);
        if (ShoulderRenderBin.rayTraceHit != null && Minecraft.func_71410_x().field_71439_g != null) {
            ShoulderRenderBin.rayTraceHit.field_72450_a -= Minecraft.func_71410_x().field_71439_g.field_70165_t;
            ShoulderRenderBin.rayTraceHit.field_72448_b -= Minecraft.func_71410_x().field_71439_g.field_70163_u;
            ShoulderRenderBin.rayTraceHit.field_72449_c -= Minecraft.func_71410_x().field_71439_g.field_70161_v;
        }
    }

    @SubscribeEvent
    public void keyPressed(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71415_G && Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            if (ShoulderSettings.KEYBIND_ROTATE_CAMERA_LEFT.func_151468_f()) {
                ShoulderCamera.adjustCameraLeft();
            } else if (ShoulderSettings.KEYBIND_ROTATE_CAMERA_RIGHT.func_151468_f()) {
                ShoulderCamera.adjustCameraRight();
            } else if (ShoulderSettings.KEYBIND_ZOOM_CAMERA_IN.func_151468_f()) {
                ShoulderCamera.adjustCameraIn();
            } else if (ShoulderSettings.KEYBIND_ZOOM_CAMERA_OUT.func_151468_f()) {
                ShoulderCamera.adjustCameraOut();
            } else if (ShoulderSettings.KEYBIND_SWAP_SHOULDER.func_151468_f()) {
                ShoulderCamera.swapShoulder();
            } else {
                return;
            }
            ShoulderSurfing.CONFIG.get("general", "Rotation Offset", (double)ShoulderCamera.SHOULDER_ROTATION, "Third person camera rotation").set((double)ShoulderCamera.SHOULDER_ROTATION);
            ShoulderSurfing.CONFIG.get("general", "Zoom Offset", (double)ShoulderCamera.SHOULDER_ZOOM_MOD, "Third person camera zoom").set((double)ShoulderCamera.SHOULDER_ZOOM_MOD);
            ShoulderSurfing.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("shouldersurfing")) {
            boolean ppChanged;
            boolean prev = ShoulderSettings.REPLACE_DEFAULT_3PP;
            ShoulderSurfing.syncConfig();
            boolean bl = ppChanged = ShoulderSettings.REPLACE_DEFAULT_3PP != prev;
            if (ShoulderSettings.REPLACE_DEFAULT_3PP != prev) {
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 3 && ShoulderSettings.REPLACE_DEFAULT_3PP) {
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
                } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && !ShoulderSettings.REPLACE_DEFAULT_3PP) {
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 3;
                }
            }
        }
    }

    @SubscribeEvent
    public void preRenderPlayer(RenderPlayerEvent.Pre event) {
        if (ShoulderRenderBin.skipPlayerRender && Minecraft.func_71410_x().field_71415_G && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void preRenderCrosshairs(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            float tick = event.partialTicks;
            GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
            ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            int width = resolution.func_78326_a();
            int height = resolution.func_78328_b();
            int scale = resolution.func_78325_e();
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 || !ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED && Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
                lastX = width * scale / 2;
                lastY = height * scale / 2;
                this.renderCrosshair(gui, resolution);
            } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
                GL11.glPushMatrix();
                float diffX = ((float)(width * scale / 2) - lastX) * tick;
                float diffY = ((float)(height * scale / 2) - lastY) * tick;
                if (ShoulderRenderBin.projectedVector != null) {
                    diffX = (ShoulderRenderBin.projectedVector.x - lastX) * tick;
                    diffY = (ShoulderRenderBin.projectedVector.y - lastY) * tick;
                }
                float crosshairWidth = (lastX + diffX) / (float)scale - 7.0f;
                float crosshairHeight = (lastY + diffY) / (float)scale - 7.0f;
                GL11.glScalef((float)(1.0f / (float)scale), (float)(1.0f / (float)scale), (float)(1.0f / (float)scale));
                GL11.glTranslatef((float)(crosshairWidth * (float)scale), (float)(crosshairHeight * (float)scale), (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glTranslatef((float)(-width / 2 + 7), (float)(-height / 2 + 7), (float)0.0f);
                this.renderCrosshair(gui, resolution);
                lastX += diffX;
                lastY += diffY;
                GL11.glPopMatrix();
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    private void renderCrosshair(GuiIngame gui, ScaledResolution resolution) {
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)775, (int)769);
        if (ShoulderSettings.ENABLE_CROSSHAIR || Minecraft.func_71410_x().field_71474_y.field_74320_O != ShoulderSettings.getShoulderSurfing3ppId()) {
            gui.func_73729_b(width / 2 - 7, height / 2 - 7, 0, 0, 16, 16);
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

