/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.teamderpy.shouldersurfing.ShoulderCamera;
import com.teamderpy.shouldersurfing.ShoulderSettings;
import com.teamderpy.shouldersurfing.math.VectorConverter;
import com.teamderpy.shouldersurfing.renderer.ShoulderRenderBin;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public final class InjectionDelegation {
    public static float getShoulderRotation() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            return ShoulderCamera.SHOULDER_ROTATION;
        }
        return 0.0f;
    }

    public static float getShoulderZoomMod() {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            return ShoulderCamera.SHOULDER_ZOOM_MOD;
        }
        return 1.0f;
    }

    public static void calculateRayTraceProjection() {
        if (ShoulderRenderBin.rayTraceHit != null) {
            ShoulderRenderBin.projectedVector = VectorConverter.project2D((float)ShoulderRenderBin.rayTraceHit.field_72450_a, (float)ShoulderRenderBin.rayTraceHit.field_72448_b, (float)ShoulderRenderBin.rayTraceHit.field_72449_c);
            ShoulderRenderBin.rayTraceHit = null;
        }
    }

    public static void verifyReverseBlockDist(double distance) {
        if (distance < 0.8 && ShoulderSettings.HIDE_PLAYER_IF_TOO_CLOSE_TO_CAMERA) {
            ShoulderRenderBin.skipPlayerRender = true;
        }
    }

    public static MovingObjectPosition getRayTraceResult(World world, Vec3 vec1, Vec3 vec2) {
        if (ShoulderSettings.IGNORE_BLOCKS_WITHOUT_COLLISION) {
            return world.func_147447_a(vec1, vec2, false, true, false);
        }
        return world.func_72933_a(vec1, vec2);
    }

    public static int getMax3ppId() {
        if (ShoulderSettings.REPLACE_DEFAULT_3PP) {
            return 2;
        }
        return 3;
    }

    public static double checkDistance(double distance, float yaw, double posX, double posY, double posZ, double cameraXoffset, double cameraYoffset, double cameraZoffset) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == ShoulderSettings.getShoulderSurfing3ppId()) {
            double result = distance;
            float radiant = (float)Math.PI / 180;
            float offset = InjectionDelegation.getShoulderRotation();
            float oldYaw = yaw - offset;
            double length = (double)MathHelper.func_76134_b((float)((-90.0f - offset) * radiant)) * distance;
            double addX = (double)MathHelper.func_76134_b((float)(oldYaw * radiant)) * length;
            double addZ = (double)MathHelper.func_76126_a((float)(oldYaw * radiant)) * length;
            for (int i = 0; i < 8; ++i) {
                double newDistance;
                MovingObjectPosition raytraceresult;
                float offsetX = (i & 1) * 2 - 1;
                float offsetY = (i >> 1 & 1) * 2 - 1;
                float offsetZ = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = InjectionDelegation.getRayTraceResult((World)Minecraft.func_71410_x().field_71441_e, Vec3.func_72443_a((double)(posX + (double)(offsetX *= 0.1f)), (double)(posY + (double)(offsetY *= 0.1f)), (double)(posZ + (double)(offsetZ *= 0.1f))), Vec3.func_72443_a((double)(posX - (cameraXoffset + addX) + (double)offsetX + (double)offsetZ), (double)(posY - cameraYoffset + (double)offsetY), (double)(posZ - (cameraZoffset + addZ) + (double)offsetZ)))) == null || !((newDistance = raytraceresult.field_72307_f.func_72438_d(Vec3.func_72443_a((double)posX, (double)posY, (double)posZ))) < result)) continue;
                result = newDistance;
            }
            return result;
        }
        return distance;
    }
}

