/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.google.gson.Gson;
import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.json.JsonShoulderSurfing;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@SideOnly(value=Side.CLIENT)
public class ShoulderMappings {
    private final Map<String, JsonShoulderSurfing.JsonVersions.JsonMappings.JsonClassMapping> CLASS_MAPPINGS = new HashMap<String, JsonShoulderSurfing.JsonVersions.JsonMappings.JsonClassMapping>();
    private final Map<String, JsonShoulderSurfing.JsonVersions.JsonMappings.JsonFieldMapping> FIELD_MAPPINGS = new HashMap<String, JsonShoulderSurfing.JsonVersions.JsonMappings.JsonFieldMapping>();
    private boolean isObfuscated;

    public ShoulderMappings() {
        this.init();
    }

    public void init() {
        try {
            String version = "1.7.10";
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("assets/shouldersurfing/mappings/mappings.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            JsonShoulderSurfing json = (JsonShoulderSurfing)new Gson().fromJson((Reader)reader, JsonShoulderSurfing.class);
            if (json != null) {
                for (JsonShoulderSurfing.JsonVersions versions : json.getVersions()) {
                    if (!versions.getVersion().equals(version)) continue;
                    for (JsonShoulderSurfing.JsonVersions.JsonMappings.JsonClassMapping jsonClassMapping : versions.getMappings().getClasses()) {
                        this.CLASS_MAPPINGS.put(jsonClassMapping.getName(), jsonClassMapping);
                    }
                    for (JsonShoulderSurfing.JsonVersions.JsonMappings.JsonMapping jsonMapping : versions.getMappings().getMethods()) {
                        this.FIELD_MAPPINGS.put(jsonMapping.getName(), (JsonShoulderSurfing.JsonVersions.JsonMappings.JsonFieldMapping)jsonMapping);
                    }
                    for (JsonShoulderSurfing.JsonVersions.JsonMappings.JsonMapping jsonMapping : versions.getMappings().getFields()) {
                        this.FIELD_MAPPINGS.put(jsonMapping.getName(), (JsonShoulderSurfing.JsonVersions.JsonMappings.JsonFieldMapping)jsonMapping);
                    }
                    ShoulderSurfing.LOGGER.info("Loaded mappings for Minecraft " + versions.getVersion());
                    break;
                }
            }
            if (this.CLASS_MAPPINGS.isEmpty() || this.FIELD_MAPPINGS.isEmpty()) {
                ShoulderSurfing.LOGGER.error("No mappings found for Minecraft " + version);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setObfuscated(boolean isObfuscated) {
        this.isObfuscated = isObfuscated;
    }

    @Nullable
    public String getClassPackage(String klass) {
        if (this.CLASS_MAPPINGS.containsKey(klass)) {
            return this.CLASS_MAPPINGS.get(klass).getClassPackage(this.isObfuscated);
        }
        return null;
    }

    @Nullable
    public String getClassPath(String klass) {
        if (this.CLASS_MAPPINGS.containsKey(klass)) {
            return this.CLASS_MAPPINGS.get(klass).getClassPath(this.isObfuscated);
        }
        return null;
    }

    @Nullable
    public String getFieldOrMethod(String fieldOrMethod) {
        if (this.FIELD_MAPPINGS.containsKey(fieldOrMethod)) {
            return this.FIELD_MAPPINGS.get(fieldOrMethod).getFieldOrMethod(this.isObfuscated);
        }
        return null;
    }

    @Nullable
    public String getPackage(String klass) {
        if (this.CLASS_MAPPINGS.containsKey(klass)) {
            return this.CLASS_MAPPINGS.get(klass).getPackage();
        }
        return null;
    }

    @Nullable
    public String getPath(String klass) {
        if (this.CLASS_MAPPINGS.containsKey(klass)) {
            return this.CLASS_MAPPINGS.get(klass).getPath();
        }
        return null;
    }

    @Nullable
    public String getName(String field) {
        if (this.CLASS_MAPPINGS.containsKey(field)) {
            return this.CLASS_MAPPINGS.get(field).getName();
        }
        if (this.FIELD_MAPPINGS.containsKey(field)) {
            return this.FIELD_MAPPINGS.get(field).getName();
        }
        return null;
    }

    @Nullable
    public String getObf(String field) {
        if (this.CLASS_MAPPINGS.containsKey(field)) {
            return this.CLASS_MAPPINGS.get(field).getObf();
        }
        if (this.FIELD_MAPPINGS.containsKey(field)) {
            return this.FIELD_MAPPINGS.get(field).getObf();
        }
        return null;
    }

    @Nullable
    public String getDescriptor(String field) {
        if (this.FIELD_MAPPINGS.containsKey(field)) {
            return this.FIELD_MAPPINGS.get(field).getDescriptor(this.CLASS_MAPPINGS, this.isObfuscated);
        }
        return null;
    }
}

