/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.asm.ShoulderASMHelper;
import com.teamderpy.shouldersurfing.asm.ShoulderMappings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.Function;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@SideOnly(value=Side.CLIENT)
public class ShoulderTransformations
implements IClassTransformer {
    public static final int TOTAL_MODIFICATIONS = 6;
    public static int MODIFICATIONS = 0;
    private final ShoulderMappings mappings = new ShoulderMappings();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.equals(this.mappings.getObf("EntityRenderer"))) {
            return this.transformClass(bytes, true, this::transformEntityRender);
        }
        if (name.equals(this.mappings.getPackage("EntityRenderer"))) {
            return this.transformClass(bytes, false, this::transformEntityRender);
        }
        if (name.equals(this.mappings.getObf("Minecraft"))) {
            return this.transformClass(bytes, true, this::transformMinecraft);
        }
        if (name.equals(this.mappings.getPackage("Minecraft"))) {
            return this.transformClass(bytes, false, this::transformMinecraft);
        }
        return bytes;
    }

    private byte[] transformClass(byte[] bytes, boolean obfuscated, Function<MethodNode, Boolean> transformer) {
        ShoulderSurfing.LOGGER.info(obfuscated ? "Injecting into obfuscated code" : "Injecting into non-obfuscated code");
        this.mappings.setObfuscated(obfuscated);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (transformer.apply(method).booleanValue()) continue;
            return bytes;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private boolean transformEntityRender(MethodNode method) {
        if (this.methodMatches(method, "EntityRenderer#orientCamera")) {
            ShoulderSurfing.LOGGER.info("Located method " + method.name + method.desc + ", locating signature");
            InsnList searchList = new InsnList();
            searchList.add((AbstractInsnNode)new VarInsnNode(25, 2));
            searchList.add((AbstractInsnNode)new FieldInsnNode(180, this.mappings.getClassPath("EntityLivingBase"), this.mappings.getFieldOrMethod("EntityLivingBase#rotationYaw"), this.mappings.getDescriptor("EntityLivingBase#rotationYaw")));
            searchList.add((AbstractInsnNode)new VarInsnNode(56, 13));
            searchList.add((AbstractInsnNode)new VarInsnNode(25, 2));
            searchList.add((AbstractInsnNode)new FieldInsnNode(180, this.mappings.getClassPath("EntityLivingBase"), this.mappings.getFieldOrMethod("EntityLivingBase#rotationPitch"), this.mappings.getDescriptor("EntityLivingBase#rotationPitch")));
            searchList.add((AbstractInsnNode)new VarInsnNode(56, 12));
            int offset = ShoulderASMHelper.locateOffset(method.instructions, searchList);
            if (offset == -1) {
                ShoulderSurfing.LOGGER.error("Failed to locate first of four offsets in " + method.name + method.desc + "! Is base file changed?");
                return false;
            }
            ShoulderSurfing.LOGGER.info("Located offset @" + offset);
            InsnList hackCode = new InsnList();
            hackCode.add((AbstractInsnNode)new VarInsnNode(23, 13));
            hackCode.add((AbstractInsnNode)new MethodInsnNode(184, "com/teamderpy/shouldersurfing/asm/InjectionDelegation", "getShoulderRotation", "()F", false));
            hackCode.add((AbstractInsnNode)new InsnNode(98));
            hackCode.add((AbstractInsnNode)new VarInsnNode(56, 13));
            hackCode.add((AbstractInsnNode)new VarInsnNode(24, 10));
            hackCode.add((AbstractInsnNode)new MethodInsnNode(184, "com/teamderpy/shouldersurfing/asm/InjectionDelegation", "getShoulderZoomMod", "()F", false));
            hackCode.add((AbstractInsnNode)new InsnNode(141));
            hackCode.add((AbstractInsnNode)new InsnNode(107));
            hackCode.add((AbstractInsnNode)new VarInsnNode(57, 10));
            hackCode.add((AbstractInsnNode)new LabelNode(new Label()));
            method.instructions.insertBefore(method.instructions.get(offset + 1), hackCode);
            ShoulderSurfing.LOGGER.info("Injected code for camera orientation!");
            ++MODIFICATIONS;
            searchList = new InsnList();
            searchList.add((AbstractInsnNode)new VarInsnNode(57, 25));
            searchList.add((AbstractInsnNode)new VarInsnNode(24, 25));
            offset = ShoulderASMHelper.locateOffset(method.instructions, searchList);
            if (offset == -1) {
                ShoulderSurfing.LOGGER.error("Failed to locate second of four offsets in " + method.name + method.desc + "! Is base file changed?");
                return false;
            }
            ShoulderSurfing.LOGGER.info("Located offset @" + offset);
            hackCode = new InsnList();
            hackCode.add((AbstractInsnNode)new VarInsnNode(24, 25));
            hackCode.add((AbstractInsnNode)new MethodInsnNode(184, "com/teamderpy/shouldersurfing/asm/InjectionDelegation", "verifyReverseBlockDist", "(D)V", false));
            hackCode.add((AbstractInsnNode)new LabelNode(new Label()));
            method.instructions.insertBefore(method.instructions.get(offset), hackCode);
            ShoulderSurfing.LOGGER.info("Injected code for alternative camera distance check!");
            ++MODIFICATIONS;
            searchList = new InsnList();
            searchList.add((AbstractInsnNode)new MethodInsnNode(182, this.mappings.getClassPath("WorldClient"), this.mappings.getFieldOrMethod("WorldClient#rayTraceBlocks"), this.mappings.getDescriptor("WorldClient#rayTraceBlocks"), false));
            offset = ShoulderASMHelper.locateOffset(method.instructions, searchList);
            if (offset == -1) {
                ShoulderSurfing.LOGGER.error("Failed to locate third of four offsets in " + method.name + method.desc + "! Is base file changed?");
                return false;
            }
            method.instructions.set(method.instructions.get(offset), (AbstractInsnNode)new MethodInsnNode(184, "com/teamderpy/shouldersurfing/asm/InjectionDelegation", "getRayTraceResult", this.mappings.getDescriptor("InjectionDelegation#getRayTraceResult"), false));
            ShoulderSurfing.LOGGER.info("Injected code for ray trace!");
            ++MODIFICATIONS;
            searchList = new InsnList();
            searchList.add((AbstractInsnNode)new InsnNode(118));
            searchList.add((AbstractInsnNode)new InsnNode(141));
            searchList.add((AbstractInsnNode)new VarInsnNode(24, 10));
            searchList.add((AbstractInsnNode)new InsnNode(107));
            searchList.add((AbstractInsnNode)new VarInsnNode(57, 18));
            offset = ShoulderASMHelper.locateOffset(method.instructions, searchList);
            if (offset == 1) {
                ShoulderSurfing.LOGGER.error("Failed to locate fourth of four offsets in " + method.name + method.desc + "! Is base file changed?");
                return false;
            }
            ShoulderSurfing.LOGGER.info("Located offset @" + offset);
            hackCode = new InsnList();
            hackCode.add((AbstractInsnNode)new VarInsnNode(24, 10));
            hackCode.add((AbstractInsnNode)new VarInsnNode(23, 13));
            hackCode.add((AbstractInsnNode)new VarInsnNode(24, 4));
            hackCode.add((AbstractInsnNode)new VarInsnNode(24, 6));
            hackCode.add((AbstractInsnNode)new VarInsnNode(24, 8));
            hackCode.add((AbstractInsnNode)new VarInsnNode(24, 14));
            hackCode.add((AbstractInsnNode)new VarInsnNode(24, 18));
            hackCode.add((AbstractInsnNode)new VarInsnNode(24, 16));
            hackCode.add((AbstractInsnNode)new MethodInsnNode(184, "com/teamderpy/shouldersurfing/asm/InjectionDelegation", "checkDistance", "(DFDDDDDD)D", false));
            hackCode.add((AbstractInsnNode)new VarInsnNode(57, 10));
            method.instructions.insert(method.instructions.get(offset + 1), hackCode);
            ShoulderSurfing.LOGGER.info("Injected code for camera distance check!");
            ++MODIFICATIONS;
        } else if (this.methodMatches(method, "EntityRenderer#renderWorld")) {
            ShoulderSurfing.LOGGER.info("Located method " + method.name + method.desc + ", locating signature");
            InsnList searchList = new InsnList();
            searchList.add((AbstractInsnNode)new MethodInsnNode(184, this.mappings.getClassPath("ClippingHelperImpl"), this.mappings.getFieldOrMethod("ClippingHelperImpl#getInstance"), this.mappings.getDescriptor("ClippingHelperImpl#getInstance"), false));
            searchList.add((AbstractInsnNode)new InsnNode(87));
            int offset = ShoulderASMHelper.locateOffset(method.instructions, searchList);
            if (offset == -1) {
                ShoulderSurfing.LOGGER.error("Failed to locate offset in " + method.name + method.desc + "! Is base file changed?");
                return false;
            }
            ShoulderSurfing.LOGGER.info("Located offset @" + offset);
            InsnList hackCode = new InsnList();
            hackCode.add((AbstractInsnNode)new MethodInsnNode(184, "com/teamderpy/shouldersurfing/asm/InjectionDelegation", "calculateRayTraceProjection", "()V", false));
            hackCode.add((AbstractInsnNode)new LabelNode(new Label()));
            method.instructions.insertBefore(method.instructions.get(offset + 1), hackCode);
            ShoulderSurfing.LOGGER.info("Injected code for raytrace projection!");
            ++MODIFICATIONS;
        }
        return true;
    }

    private boolean transformMinecraft(MethodNode method) {
        if (this.methodMatches(method, "Minecraft#runTick")) {
            ShoulderSurfing.LOGGER.info("Located method " + method.name + method.desc + ", locating signature");
            InsnList searchList = new InsnList();
            searchList.add((AbstractInsnNode)new FieldInsnNode(180, this.mappings.getClassPath("GameSettings"), this.mappings.getFieldOrMethod("GameSettings#thirdPersonView"), this.mappings.getDescriptor("GameSettings#thirdPersonView")));
            searchList.add((AbstractInsnNode)new InsnNode(5));
            int offset = ShoulderASMHelper.locateOffset(method.instructions, searchList);
            if (offset == -1) {
                ShoulderSurfing.LOGGER.error("Failed to locate offset in " + method.name + method.desc + "! Is base file changed?");
                return false;
            }
            method.instructions.set(method.instructions.get(offset), (AbstractInsnNode)new MethodInsnNode(184, "com/teamderpy/shouldersurfing/asm/InjectionDelegation", "getMax3ppId", "()I", false));
            ShoulderSurfing.LOGGER.info("Injected code new third person mode!");
            ++MODIFICATIONS;
        }
        return true;
    }

    private boolean methodMatches(MethodNode method, String name) {
        return method.name.equals(this.mappings.getFieldOrMethod(name)) && method.desc.equals(this.mappings.getDescriptor(name));
    }
}

