/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing;

import com.teamderpy.shouldersurfing.ShoulderCamera;
import com.teamderpy.shouldersurfing.ShoulderSettings;
import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.math.RayTracer;
import com.teamderpy.shouldersurfing.renderer.ShoulderRenderBin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class ShoulderEventHandler {
    private static float lastX = 0.0f;
    private static float lastY = 0.0f;

    @SubscribeEvent
    public void renderEvent(TickEvent.RenderTickEvent event) {
        ShoulderRenderBin.skipPlayerRender = false;
        RayTracer.traceFromEyes(1.0f);
        if (ShoulderRenderBin.rayTraceHit != null && Minecraft.func_71410_x().field_71439_g != null) {
            ShoulderRenderBin.rayTraceHit = ShoulderRenderBin.rayTraceHit.func_178788_d(new Vec3(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v));
        }
    }

    @SubscribeEvent
    public void keyPressed(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71462_r == null && Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
            if (ShoulderSurfing.KEYBIND_ROTATE_CAMERA_LEFT.func_151468_f()) {
                ShoulderCamera.adjustCameraLeft();
            } else if (ShoulderSurfing.KEYBIND_ROTATE_CAMERA_RIGHT.func_151468_f()) {
                ShoulderCamera.adjustCameraRight();
            } else if (ShoulderSurfing.KEYBIND_ZOOM_CAMERA_IN.func_151468_f()) {
                ShoulderCamera.adjustCameraIn();
            } else if (ShoulderSurfing.KEYBIND_ZOOM_CAMERA_OUT.func_151468_f()) {
                ShoulderCamera.adjustCameraOut();
            } else {
                return;
            }
            ShoulderSurfing.config.get("general", "Rotation Offset", (double)ShoulderCamera.SHOULDER_ROTATION, "Third person camera rotation").set((double)ShoulderCamera.SHOULDER_ROTATION);
            ShoulderSurfing.config.get("general", "Zoom Offset", (double)ShoulderCamera.SHOULDER_ZOOM_MOD, "Third person camera zoom").set((double)ShoulderCamera.SHOULDER_ZOOM_MOD);
            ShoulderSurfing.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("shouldersurfing")) {
            ShoulderSurfing.syncConfig();
        }
    }

    @SubscribeEvent
    public void postRenderCrosshairs(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
    }

    @SubscribeEvent
    public void preRenderPlayer(RenderPlayerEvent.Pre event) {
        if (ShoulderRenderBin.skipPlayerRender && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void preRenderCrosshairs(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            float tick = event.partialTicks;
            GuiIngame g = Minecraft.func_71410_x().field_71456_v;
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            int l = sr.func_78326_a();
            int i1 = sr.func_78328_b();
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 || !ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED && Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
                lastX = sr.func_78326_a() * sr.func_78325_e() / 2;
                lastY = sr.func_78328_b() * sr.func_78325_e() / 2;
                this.bind(Gui.field_110324_m);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)775, (int)769, (int)1, (int)0);
                g.func_73729_b(sr.func_78326_a() / 2 - 7, sr.func_78328_b() / 2 - 7, 0, 0, 16, 16);
                GlStateManager.func_179084_k();
            } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
                if (ShoulderRenderBin.projectedVector != null) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179147_l();
                    this.bind(Gui.field_110324_m);
                    if (ShoulderRenderBin.rayTraceInReach) {
                        GL14.glBlendColor((float)0.2f, (float)0.2f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179120_a((int)775, (int)769, (int)1, (int)0);
                    } else {
                        GL14.glBlendColor((float)1.0f, (float)0.2f, (float)0.2f, (float)1.0f);
                        GlStateManager.func_179120_a((int)775, (int)769, (int)1, (int)0);
                    }
                    float diffX = (ShoulderRenderBin.projectedVector.x - lastX) * tick;
                    float diffY = (ShoulderRenderBin.projectedVector.y - lastY) * tick;
                    int crosshairWidth = (int)((lastX + diffX) / (float)sr.func_78325_e() - 7.0f);
                    int crosshairHeight = (int)((lastY + diffY) / (float)sr.func_78325_e() - 7.0f);
                    g.func_73729_b(crosshairWidth, crosshairHeight, 0, 0, 16, 16);
                    lastX += diffX;
                    lastY += diffY;
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179121_F();
                } else if (ShoulderSettings.TRACE_TO_HORIZON_LAST_RESORT) {
                    this.bind(Gui.field_110324_m);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179120_a((int)775, (int)769, (int)1, (int)0);
                    float diffX = ((float)(sr.func_78326_a() * sr.func_78325_e() / 2) - lastX) * tick;
                    float diffY = ((float)(sr.func_78328_b() * sr.func_78325_e() / 2) - lastY) * tick;
                    int crosshairWidth = (int)((lastX + diffX) / (float)sr.func_78325_e() - 7.0f);
                    int crosshairHeight = (int)((lastY + diffY) / (float)sr.func_78325_e() - 7.0f);
                    g.func_73729_b(crosshairWidth, crosshairHeight, 0, 0, 16, 16);
                    lastX += diffX;
                    lastY += diffY;
                    GlStateManager.func_179084_k();
                }
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    private void bind(ResourceLocation res) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
    }
}

