/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing;

import com.teamderpy.shouldersurfing.ShoulderCamera;
import com.teamderpy.shouldersurfing.ShoulderEventHandler;
import com.teamderpy.shouldersurfing.ShoulderSettings;
import com.teamderpy.shouldersurfing.asm.ShoulderTransformations;
import com.teamderpy.shouldersurfing.proxy.CommonProxy;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
@Mod(modid="shouldersurfing", name="Shoulder Surfing", acceptedMinecraftVersions="[1.8.8,)", version="1.1", canBeDeactivated=false, guiFactory="com.teamderpy.shouldersurfing.gui.GuiShoulderSurfingConfigFactory")
public class ShoulderSurfing {
    @Mod.Instance(value="shouldersurfing")
    public ShoulderSurfing INSTACE;
    @SidedProxy(clientSide="com.teamderpy.shouldersurfing.proxy.ClientProxy", serverSide="com.teamderpy.shouldersurfing.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration config;
    public static final String NAME = "Shoulder Surfing";
    public static final String MODID = "shouldersurfing";
    public static final String MC_VERSION = "1.8.8,";
    public static final String VERSION = "1.1";
    public static final String DEVELOPERS = "Joshua Powers, Exopandora (for 1.8+)";
    public static KeyBinding KEYBIND_ROTATE_CAMERA_LEFT;
    public static KeyBinding KEYBIND_ROTATE_CAMERA_RIGHT;
    public static KeyBinding KEYBIND_ZOOM_CAMERA_OUT;
    public static KeyBinding KEYBIND_ZOOM_CAMERA_IN;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.syncConfig();
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND_ROTATE_CAMERA_LEFT);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND_ROTATE_CAMERA_RIGHT);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND_ZOOM_CAMERA_OUT);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBIND_ZOOM_CAMERA_IN);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ShoulderEventHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        int expMods = 3;
        if (ShoulderTransformations.modifications != expMods) {
            logger.error("Only found " + ShoulderTransformations.modifications + " code injections, but expected " + expMods);
            logger.error("ShoulderSurfing should be disabled!");
        } else {
            logger.info("Loaded " + ShoulderTransformations.modifications + " code injections, ShoulderSurfing good to go!");
        }
    }

    public static void syncConfig() {
        ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED = config.get("general", "Dynamic Crosshair", ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED, "If enabled, then the crosshair moves around to line up with the block you are facing.").getBoolean(ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED);
        ShoulderCamera.SHOULDER_ROTATION = (float)config.get("general", "Rotation Offset", (double)ShoulderCamera.SHOULDER_ROTATION, "Third person camera rotation").getDouble((double)ShoulderCamera.SHOULDER_ROTATION);
        ShoulderCamera.SHOULDER_ZOOM_MOD = (float)config.get("general", "Zoom Offset", (double)ShoulderCamera.SHOULDER_ZOOM_MOD, "Third person camera zoom").getDouble((double)ShoulderCamera.SHOULDER_ZOOM_MOD);
        ShoulderSettings.IS_ROTATION_UNLIMITED = config.get("general", "Unlimited Rotation", ShoulderSettings.IS_ROTATION_UNLIMITED, "Whether or not rotation adjustment has limits").getBoolean(ShoulderSettings.IS_ROTATION_UNLIMITED);
        ShoulderSettings.ROTATION_MAXIMUM = (float)config.get("general", "Rotation Maximum", (double)ShoulderSettings.ROTATION_MAXIMUM, "If rotation is limited this is the maximum amount").getDouble((double)ShoulderSettings.ROTATION_MAXIMUM);
        ShoulderSettings.ROTATION_MINIMUM = (float)config.get("general", "Rotation Minimum", (double)ShoulderSettings.ROTATION_MINIMUM, "If rotation is limited this is the minimum amount").getDouble((double)ShoulderSettings.ROTATION_MINIMUM);
        ShoulderSettings.IS_ZOOM_UNLIMITED = config.get("general", "Unlimited Zoom", ShoulderSettings.IS_ZOOM_UNLIMITED, "Whether or not zoom adjustment has limits").getBoolean(ShoulderSettings.IS_ZOOM_UNLIMITED);
        ShoulderSettings.ZOOM_MAXIMUM = (float)config.get("general", "Zoom Maximum", (double)ShoulderSettings.ZOOM_MAXIMUM, "If zoom is limited this is the maximum amount").getDouble((double)ShoulderSettings.ZOOM_MAXIMUM);
        ShoulderSettings.ZOOM_MINIMUM = (float)config.get("general", "Zoom Minimum", (double)ShoulderSettings.ZOOM_MINIMUM, "If zoom is limited this is the minimum amount").getDouble((double)ShoulderSettings.ZOOM_MINIMUM);
        ShoulderSettings.TRACE_TO_HORIZON_LAST_RESORT = config.get("general", "Always Show Crosshair", ShoulderSettings.TRACE_TO_HORIZON_LAST_RESORT, "Whether or not to show a crosshair in the center of the screen if nothing is in range of you").getBoolean(ShoulderSettings.TRACE_TO_HORIZON_LAST_RESORT);
        ShoulderSettings.USE_CUSTOM_RAYTRACE_DISTANCE = config.get("general", "Show Crosshair Farther", ShoulderSettings.USE_CUSTOM_RAYTRACE_DISTANCE, "Whether or not to show the crosshairs farther than normal").getBoolean(ShoulderSettings.USE_CUSTOM_RAYTRACE_DISTANCE);
        ShoulderSettings.HIDE_PLAYER_IF_TOO_CLOSE_TO_CAMERA = config.get("general", "Keep Camera Out Of Head", ShoulderSettings.HIDE_PLAYER_IF_TOO_CLOSE_TO_CAMERA, "Whether or not to hide the player model if the camera gets too close to it").getBoolean(ShoulderSettings.HIDE_PLAYER_IF_TOO_CLOSE_TO_CAMERA);
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        KEYBIND_ROTATE_CAMERA_LEFT = new KeyBinding("Camera adj left", 36, "key.categories.misc");
        KEYBIND_ROTATE_CAMERA_RIGHT = new KeyBinding("Camera adj right", 38, "key.categories.misc");
        KEYBIND_ZOOM_CAMERA_OUT = new KeyBinding("Camera adj closer", 23, "key.categories.misc");
        KEYBIND_ZOOM_CAMERA_IN = new KeyBinding("Camera adj farther", 37, "key.categories.misc");
        logger = LogManager.getLogger((String)NAME);
    }
}

