/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.asm.ShoulderASMHelper;
import java.util.HashMap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@SideOnly(value=Side.CLIENT)
public class ShoulderTransformations
implements IClassTransformer {
    private final HashMap<String, String> obfStrings = new HashMap();
    private final HashMap<String, String> mcpStrings = new HashMap();
    public static final int CODE_MODIFICATIONS = 3;
    public static int modifications = 0;

    public ShoulderTransformations() {
        this.registerMapping("EntityRendererClass", "net.minecraft.client.renderer.EntityRenderer", "bfk");
        this.registerMapping("EntityRendererJavaClass", "net/minecraft/client/renderer/EntityRenderer", "bfk");
        this.registerMapping("EntityJavaClass", "net/minecraft/entity/Entity", "pk");
        this.registerMapping("orientCameraMethod", "orientCamera", "f");
        this.registerMapping("rotationYawField", "rotationYaw", "y");
        this.registerMapping("rotationPitchField", "rotationPitch", "z");
        this.registerMapping("SHOULDER_ROTATIONField", "SHOULDER_ROTATION", "SHOULDER_ROTATION");
        this.registerMapping("SHOULDER_ZOOM_MODField", "SHOULDER_ZOOM_MOD", "SHOULDER_ZOOM_MOD");
        this.registerMapping("InjectionDelegationJavaClass", "com/teamderpy/shouldersurfing/asm/InjectionDelegation", "com/teamderpy/shouldersurfing/asm/InjectionDelegation");
        this.registerMapping("ShoulderRenderBinJavaClass", "com/teamderpy/shouldersurfing/renderer/ShoulderRenderBin", "com/teamderpy/shouldersurfing/renderer/ShoulderRenderBin");
        this.registerMapping("renderWorldPassMethod", "renderWorldPass", "a");
        this.registerMapping("clippingHelperImplJavaClass", "net/minecraft/client/renderer/culling/ClippingHelperImpl", "bib");
        this.registerMapping("clippingHelperJavaClass", "net/minecraft/client/renderer/culling/ClippingHelper", "bid");
        this.registerMapping("clippingHelperGetInstanceMethod", "getInstance", "a");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.equals(this.obfStrings.get("EntityRendererClass"))) {
            ShoulderSurfing.logger.info("Injecting into obfuscated code - EntityRendererClass");
            return this.transformEntityRenderClass(bytes, this.obfStrings);
        }
        if (name.equals(this.mcpStrings.get("EntityRendererClass"))) {
            ShoulderSurfing.logger.info("Injecting into non-obfuscated code - EntityRendererClass");
            return this.transformEntityRenderClass(bytes, this.mcpStrings);
        }
        return bytes;
    }

    private byte[] transformEntityRenderClass(byte[] bytes, HashMap hm) {
        ShoulderSurfing.logger.info("Attempting class transformation against EntityRender");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            InsnList hackCode;
            int offset;
            InsnList searchList;
            if (m.name.equals(hm.get("orientCameraMethod")) && m.desc.equals("(F)V")) {
                ShoulderSurfing.logger.info("Located method " + m.name + m.desc + ", locating signature");
                searchList = new InsnList();
                searchList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                searchList.add((AbstractInsnNode)new FieldInsnNode(180, (String)hm.get("EntityJavaClass"), (String)hm.get("rotationYawField"), "F"));
                searchList.add((AbstractInsnNode)new VarInsnNode(56, 12));
                searchList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                searchList.add((AbstractInsnNode)new FieldInsnNode(180, (String)hm.get("EntityJavaClass"), (String)hm.get("rotationPitchField"), "F"));
                searchList.add((AbstractInsnNode)new VarInsnNode(56, 13));
                offset = ShoulderASMHelper.locateOffset(m.instructions, searchList);
                if (offset == -1) {
                    ShoulderSurfing.logger.error("Failed to locate first of two offsets in " + m.name + m.desc + "! Is base file changed?");
                    return bytes;
                }
                ShoulderSurfing.logger.info("Located offset @ " + offset);
                hackCode = new InsnList();
                hackCode.add((AbstractInsnNode)new VarInsnNode(23, 12));
                hackCode.add((AbstractInsnNode)new MethodInsnNode(184, (String)hm.get("InjectionDelegationJavaClass"), "getShoulderRotation", "()F", false));
                hackCode.add((AbstractInsnNode)new InsnNode(98));
                hackCode.add((AbstractInsnNode)new VarInsnNode(56, 12));
                hackCode.add((AbstractInsnNode)new VarInsnNode(24, 10));
                hackCode.add((AbstractInsnNode)new MethodInsnNode(184, (String)hm.get("InjectionDelegationJavaClass"), "getShoulderZoomMod", "()F", false));
                hackCode.add((AbstractInsnNode)new InsnNode(141));
                hackCode.add((AbstractInsnNode)new InsnNode(107));
                hackCode.add((AbstractInsnNode)new VarInsnNode(57, 10));
                hackCode.add((AbstractInsnNode)new LabelNode(new Label()));
                m.instructions.insertBefore(m.instructions.get(offset + 1), hackCode);
                ShoulderSurfing.logger.info("Injected code for camera orientation!");
                ++modifications;
                searchList = new InsnList();
                searchList.add((AbstractInsnNode)new VarInsnNode(57, 25));
                searchList.add((AbstractInsnNode)new VarInsnNode(24, 25));
                offset = ShoulderASMHelper.locateOffset(m.instructions, searchList);
                if (offset == -1) {
                    ShoulderSurfing.logger.error("Failed to locate second of two offsets in " + m.name + m.desc + "! Is base file changed?");
                    return bytes;
                }
                ShoulderSurfing.logger.info("Located offset @ " + offset);
                hackCode = new InsnList();
                hackCode.add((AbstractInsnNode)new VarInsnNode(24, 25));
                hackCode.add((AbstractInsnNode)new MethodInsnNode(184, (String)hm.get("InjectionDelegationJavaClass"), "verifyReverseBlockDist", "(D)V", false));
                hackCode.add((AbstractInsnNode)new LabelNode(new Label()));
                m.instructions.insertBefore(m.instructions.get(offset), hackCode);
                ShoulderSurfing.logger.info("Injected code for camera distance check!");
                ++modifications;
                continue;
            }
            if (!m.name.equals(hm.get("renderWorldPassMethod")) || !m.desc.equals("(IFJ)V")) continue;
            ShoulderSurfing.logger.info("Located method " + m.name + m.desc + ", locating signature");
            searchList = new InsnList();
            searchList.add((AbstractInsnNode)new MethodInsnNode(184, (String)hm.get("clippingHelperImplJavaClass"), (String)hm.get("clippingHelperGetInstanceMethod"), "()L" + (String)hm.get("clippingHelperJavaClass") + ";", false));
            searchList.add((AbstractInsnNode)new InsnNode(87));
            offset = ShoulderASMHelper.locateOffset(m.instructions, searchList);
            if (offset == -1) {
                ShoulderSurfing.logger.error("Failed to locate offset in " + m.name + m.desc + "! Is base file changed?");
                return bytes;
            }
            ShoulderSurfing.logger.info("Located offset @ " + offset);
            hackCode = new InsnList();
            hackCode.add((AbstractInsnNode)new MethodInsnNode(184, (String)hm.get("InjectionDelegationJavaClass"), "calculateRayTraceProjection", "()V", false));
            hackCode.add((AbstractInsnNode)new LabelNode(new Label()));
            m.instructions.insertBefore(m.instructions.get(offset + 1), hackCode);
            ShoulderSurfing.logger.info("Injected code for ray trace projection!");
            ++modifications;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void registerMapping(String key, String normalValue, String obfuscatedValue) {
        this.mcpStrings.put(key, normalValue);
        this.obfStrings.put(key, obfuscatedValue);
    }
}

