/*
 * Decompiled with CFR 0.152.
 */
package quaternary.simpletrophies.common.item;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import quaternary.simpletrophies.common.block.BlockSimpleTrophy;
import quaternary.simpletrophies.common.config.SimpleTrophiesConfig;
import quaternary.simpletrophies.common.etc.DateHelpers;
import quaternary.simpletrophies.common.etc.EnumTrophyVariant;
import quaternary.simpletrophies.common.etc.TrophyHelpers;
import quaternary.simpletrophies.common.tile.TileSimpleTrophy;

public class ItemSimpleTrophy
extends ItemBlock {
    public ItemSimpleTrophy(BlockSimpleTrophy block) {
        super((Block)block);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        assert (nbt != null);
        if (!nbt.func_74764_b("TrophyColorRed")) {
            nbt.func_74768_a("TrophyColorRed", 255);
        }
        if (!nbt.func_74764_b("TrophyColorGreen")) {
            nbt.func_74768_a("TrophyColorGreen", 255);
        }
        if (!nbt.func_74764_b("TrophyColorBlue")) {
            nbt.func_74768_a("TrophyColorBlue", 255);
        }
        if (!nbt.func_74764_b("TrophyItem")) {
            nbt.func_74782_a("TrophyItem", (NBTBase)ItemStack.field_190927_a.serializeNBT());
        }
        if (!nbt.func_74764_b("TrophyName")) {
            nbt.func_74778_a("TrophyName", "");
        }
        if (!nbt.func_74764_b("TrophyVariant")) {
            nbt.func_74778_a("TrophyVariant", "classic");
        }
        if (!nbt.func_74764_b("TrophyEarnedAt")) {
            nbt.func_74772_a("TrophyEarnedAt", DateHelpers.now());
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() && stack.func_82837_s()) {
            String customName = stack.func_82833_r();
            nbt.func_74778_a("TrophyName", customName.equals("<CLEAR>") ? "" : customName);
            stack.func_135074_t();
            if (nbt.func_74764_b("RepairCost")) {
                nbt.func_82580_o("RepairCost");
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        String trophyName = TrophyHelpers.getDisplayedName(stack);
        if (trophyName.isEmpty()) {
            return super.func_77653_i(stack);
        }
        return I18n.func_74838_a((String)trophyName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag mistake) {
        ItemStack displayedStack = TrophyHelpers.getDisplayedStack(stack);
        if (!displayedStack.func_190926_b()) {
            tooltip.add(I18n.func_74837_a((String)"simple_trophies.misc.tooltip.displaying", (Object[])new Object[]{displayedStack.func_77953_t().field_77937_e + displayedStack.func_82833_r()}));
            if (mistake.func_194127_a()) {
                StringBuilder bob = new StringBuilder();
                bob.append("   ");
                bob.append(TextFormatting.DARK_GRAY);
                bob.append(displayedStack.func_77973_b().getRegistryName());
                bob.append(" (#");
                bob.append(Item.func_150891_b((Item)displayedStack.func_77973_b()));
                bob.append('/');
                bob.append(displayedStack.func_77952_i());
                bob.append(')');
                tooltip.add(bob.toString());
            }
            ArrayList displayedTooltip = new ArrayList();
            displayedStack.func_77973_b().func_77624_a(displayedStack, world, displayedTooltip, mistake);
            displayedTooltip.forEach(s -> tooltip.add("   " + s));
        }
        EnumTrophyVariant trophyVariant = TrophyHelpers.getDisplayedVariant(stack);
        if (mistake.func_194127_a()) {
            tooltip.add(TextFormatting.DARK_GRAY + I18n.func_74837_a((String)"simple_trophies.misc.modelName", (Object[])new Object[]{trophyVariant.blockstateVariant}));
        }
        long time = TrophyHelpers.getEarnTime(stack);
        if (SimpleTrophiesConfig.SHOW_EARNEDAT && time != 0L) {
            tooltip.add(I18n.func_74837_a((String)"simple_trophies.misc.earnedAt", (Object[])new Object[]{DateHelpers.epochToString(time)}));
        }
        if (SimpleTrophiesConfig.TOOLTIP_CREDITS) {
            tooltip.add(TextFormatting.DARK_GRAY + I18n.func_74837_a((String)"simple_trophies.misc.modelBy", (Object[])new Object[]{trophyVariant.author}));
        }
        super.func_77624_a(stack, world, tooltip, mistake);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        ItemStack displayedItem = TrophyHelpers.getDisplayedStack(stack);
        return displayedItem.func_190926_b() ? EnumRarity.COMMON : displayedItem.func_77953_t();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.field_150939_a) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileSimpleTrophy) {
                TrophyHelpers.populateTileNBTFromStack(stack, (TileSimpleTrophy)tile);
            }
            this.field_150939_a.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_184812_l_()) {
            ItemStack held = player.func_184586_b(hand);
            if (held.func_77942_o() && world.field_72995_K) {
                NBTTagCompound cmp = held.func_77978_p().func_74737_b();
                cmp.func_82580_o("TrophyEarnedAt");
                String str = cmp.toString();
                LogManager.getLogger((String)"Simple Trophies").info(str);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(str), null);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("simple_trophies.misc.copied", new Object[0]), true);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
        }
        return super.func_77659_a(world, player, hand);
    }
}

