/*
 * Decompiled with CFR 0.152.
 */
package tfar.simpletrophies.common.etc;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;

public class DateHelpers {
    private static final DateTimeFormatter doot = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(Locale.UK).withZone(ZoneId.systemDefault());

    public static long now() {
        return Instant.now().atZone(ZoneId.systemDefault()).toEpochSecond();
    }

    public static String epochToString(long time) {
        if (time == 0L) {
            return "?";
        }
        return doot.format(Instant.ofEpochSecond(time));
    }
}

