/*
 * Decompiled with CFR 0.152.
 */
package tfar.simpletrophies.common.etc;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import tfar.simpletrophies.common.tile.TileSimpleTrophy;

public class TrophyHelpers {
    public static int getCombinedColor(ItemStack stack) {
        if (stack.func_77942_o()) {
            return TrophyHelpers.getCombinedColor(stack.func_77978_p());
        }
        return 0xFFFFFF;
    }

    public static int getCombinedColor(TileSimpleTrophy tile) {
        return tile.displayedColorRed << 16 | tile.displayedColorGreen << 8 | tile.displayedColorBlue;
    }

    public static int getCombinedColor(CompoundNBT nbt) {
        int red = nbt.func_74764_b("TrophyColorRed") ? nbt.func_74762_e("TrophyColorRed") : 255;
        int green = nbt.func_74764_b("TrophyColorGreen") ? nbt.func_74762_e("TrophyColorGreen") : 255;
        int blue = nbt.func_74764_b("TrophyColorBlue") ? nbt.func_74762_e("TrophyColorBlue") : 255;
        red = MathHelper.func_76125_a((int)red, (int)0, (int)255);
        green = MathHelper.func_76125_a((int)green, (int)0, (int)255);
        blue = MathHelper.func_76125_a((int)blue, (int)0, (int)255);
        return red << 16 | green << 8 | blue;
    }

    public static ItemStack getDisplayedStack(ItemStack stack) {
        if (stack.func_77942_o()) {
            return TrophyHelpers.getDisplayedStack(stack.func_77978_p());
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getDisplayedStack(CompoundNBT nbt) {
        if (nbt.func_74764_b("TrophyItem")) {
            return ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a("TrophyItem")));
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public static ITextComponent getDisplayedName(ItemStack stack) {
        if (stack.func_77942_o()) {
            return new TranslationTextComponent(TrophyHelpers.getDisplayedName(stack.func_77978_p()), new Object[0]);
        }
        return null;
    }

    public static String getDisplayedName(CompoundNBT nbt) {
        if (nbt.func_74764_b("TrophyName")) {
            return nbt.func_74779_i("TrophyName");
        }
        return "";
    }

    public static long getEarnTime(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74763_f("TrophyEarnedAt");
        }
        return 0L;
    }

    public static void populateStackNBTFromTile(ItemStack stack, TileSimpleTrophy tile) {
        if (tile.displayedStack.func_190926_b() && tile.displayedName.isEmpty()) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT nbt = stack.func_77978_p();
        assert (nbt != null);
        nbt.func_197643_a(tile.writeToNBTInternal(new CompoundNBT()));
    }

    public static void populateTileNBTFromStack(ItemStack stack, TileSimpleTrophy tile) {
        if (!stack.func_77942_o()) {
            tile.displayedName = "";
            tile.displayedStack = ItemStack.field_190927_a;
            tile.displayedColorRed = 255;
            tile.displayedColorGreen = 255;
            tile.displayedColorBlue = 255;
            tile.earnedTime = 0L;
        } else {
            tile.readFromNBTInternal(stack.func_77978_p());
        }
    }

    public static ItemStack createItemStackFromTile(BlockPos pos, IBlockReader world, Block block) {
        TileEntity tile = world.func_175625_s(pos);
        ItemStack trophy = new ItemStack((IItemProvider)block);
        if (tile instanceof TileSimpleTrophy) {
            TrophyHelpers.populateStackNBTFromTile(trophy, (TileSimpleTrophy)tile);
        }
        return trophy;
    }
}

