/*
 * Decompiled with CFR 0.152.
 */
package tfar.simpletrophies.common.item;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tfar.simpletrophies.SimpleTrophies;
import tfar.simpletrophies.common.config.TrophyConfig;
import tfar.simpletrophies.common.etc.DateHelpers;
import tfar.simpletrophies.common.etc.TrophyHelpers;
import tfar.simpletrophies.common.tile.TileSimpleTrophy;

public class ItemSimpleTrophy
extends BlockItem {
    public ItemSimpleTrophy(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT nbt = stack.func_77978_p();
        assert (nbt != null);
        if (!nbt.func_74764_b("TrophyColorRed")) {
            nbt.func_74768_a("TrophyColorRed", 255);
        }
        if (!nbt.func_74764_b("TrophyColorGreen")) {
            nbt.func_74768_a("TrophyColorGreen", 255);
        }
        if (!nbt.func_74764_b("TrophyColorBlue")) {
            nbt.func_74768_a("TrophyColorBlue", 255);
        }
        if (!nbt.func_74764_b("TrophyItem")) {
            nbt.func_218657_a("TrophyItem", (INBT)ItemStack.field_190927_a.serializeNBT());
        }
        if (!nbt.func_74764_b("TrophyName")) {
            nbt.func_74778_a("TrophyName", "");
        }
        if (!nbt.func_74764_b("TrophyVariant")) {
            nbt.func_74778_a("TrophyVariant", "classic");
        }
        if (!nbt.func_74764_b("TrophyEarnedAt")) {
            nbt.func_74772_a("TrophyEarnedAt", DateHelpers.now());
        }
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_() && stack.func_82837_s()) {
            String customName = stack.func_200301_q().func_150261_e();
            nbt.func_74778_a("TrophyName", customName.equals("<CLEAR>") ? "" : customName);
            stack.func_135074_t();
            if (nbt.func_74764_b("RepairCost")) {
                nbt.func_82580_o("RepairCost");
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent trophyName = TrophyHelpers.getDisplayedName(stack);
        return trophyName != null ? trophyName : super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag mistake) {
        ItemStack displayedStack = TrophyHelpers.getDisplayedStack(stack);
        if (!displayedStack.func_190926_b()) {
            tooltip.add(new TranslationTextComponent("simple_trophies.misc.tooltip.displaying", new Object[]{displayedStack.func_200301_q()}).func_211709_a(new TextFormatting[]{displayedStack.func_77953_t().field_77937_e}));
            if (mistake.func_194127_a()) {
                StringBuilder bob = new StringBuilder();
                bob.append("   ");
                bob.append(TextFormatting.DARK_GRAY);
                bob.append(displayedStack.func_77973_b().getRegistryName());
                bob.append(" (#");
                bob.append(Item.func_150891_b((Item)displayedStack.func_77973_b()));
                bob.append('/');
                bob.append(')');
                tooltip.add((ITextComponent)new StringTextComponent(bob.toString()));
            }
            ArrayList displayedTooltip = new ArrayList();
            displayedStack.func_77973_b().func_77624_a(displayedStack, world, displayedTooltip, mistake);
            displayedTooltip.forEach(s -> tooltip.add((ITextComponent)new StringTextComponent("   " + s)));
        }
        long time = TrophyHelpers.getEarnTime(stack);
        if (((Boolean)TrophyConfig.ClientConfig.SHOW_EARNEDAT.get()).booleanValue() && time != 0L) {
            tooltip.add((ITextComponent)new TranslationTextComponent("simple_trophies.misc.earnedAt", new Object[]{DateHelpers.epochToString(time)}));
        }
        super.func_77624_a(stack, world, tooltip, mistake);
    }

    public Rarity func_77613_e(ItemStack stack) {
        ItemStack displayedItem = TrophyHelpers.getDisplayedStack(stack);
        return displayedItem.func_190926_b() ? Rarity.COMMON : displayedItem.func_77953_t();
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState newState) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.func_179223_d()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileSimpleTrophy) {
                TrophyHelpers.populateTileNBTFromStack(stack, (TileSimpleTrophy)tile);
            }
            this.func_179223_d().func_180633_a(world, pos, state, (LivingEntity)player, stack);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
            }
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (player.func_184812_l_()) {
            ItemStack held = player.func_184586_b(hand);
            if (held.func_77942_o() && world.field_72995_K) {
                CompoundNBT cmp = held.func_77978_p().func_74737_b();
                cmp.func_82580_o("TrophyEarnedAt");
                String str = cmp.toString();
                SimpleTrophies.LOG.info(str);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(str), null);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("simple_trophies.misc.copied", new Object[0]), true);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)held);
        }
        return super.func_77659_a(world, player, hand);
    }
}

