/*
 * Decompiled with CFR 0.152.
 */
package paulevs.skyworld.math;

import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import paulevs.skyworld.math.Vector2F;
import paulevs.skyworld.noise.OpenSimplexNoise;

public class MHelper {
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(0L);
    public static final float PI2 = (float)Math.PI * 2;

    public static int getSquaredRange(int min, int max, Random random) {
        float a = random.nextFloat();
        return Math.round((float)min + (float)(max - min) * a * a);
    }

    public static float noise(class_2338 pos, double scale) {
        return (float)NOISE.eval((double)pos.method_10263() * scale, (double)pos.method_10264() * scale, (double)pos.method_10260() * scale) * 0.5f + 0.5f;
    }

    public static float noise(class_2338 pos, double scale, int octaves) {
        float result = MHelper.noise(pos, scale);
        float delta = 0.6f;
        for (int i = 0; i < octaves; ++i) {
            result = class_3532.method_16439((float)(delta *= 0.5f), (float)result, (float)MHelper.noise(pos, scale *= 2.0));
        }
        return result;
    }

    public static float rigidNoise(class_2338 pos, double scale) {
        return (float)Math.abs(NOISE.eval((double)pos.method_10263() * scale, (double)pos.method_10264() * scale, (double)pos.method_10260() * scale));
    }

    public static float rigidNoise(class_2338 pos, double scale, int octaves) {
        float result = MHelper.rigidNoise(pos, scale);
        float delta = 0.6f;
        for (int i = 0; i < octaves; ++i) {
            result = class_3532.method_16439((float)(delta *= 0.5f), (float)result, (float)MHelper.rigidNoise(pos, scale *= 2.0));
        }
        return result;
    }

    public static class_3341 intersection(class_3341 box1, class_3341 box2) {
        int x1 = Math.max(box1.field_14381, box2.field_14381);
        int y1 = Math.max(box1.field_14380, box2.field_14380);
        int z1 = Math.max(box1.field_14379, box2.field_14379);
        int x2 = Math.min(box1.field_14378, box2.field_14378);
        int y2 = Math.min(box1.field_14377, box2.field_14377);
        int z2 = Math.min(box1.field_14376, box2.field_14376);
        return new class_3341(x1, y1, z1, x2, y2, z2);
    }

    public static int randRange(int min, int max, Random random) {
        return min + random.nextInt(max - min + 1);
    }

    public static Vector2F getSpiral(float x, float dx, float dr, float offsetX, float offsetR, Vector2F result) {
        float a = x * dr + offsetR;
        float b = x * dx + offsetX;
        return result.set(a * (float)Math.cos(b), a * (float)Math.sin(b));
    }

    public static float randRange(float min, float max, Random random) {
        return min + random.nextFloat() * (max - min);
    }
}

