/*
 * Decompiled with CFR 0.152.
 */
package paulevs.skyworld.math;

import java.util.Locale;

public class Vector2F {
    private float x;
    private float y;

    public Vector2F() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vector2F(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public Vector2F clone() {
        return new Vector2F(this.x, this.y);
    }

    public Vector2F invert() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public float getLengthSqared() {
        return this.x * this.x + this.y * this.y;
    }

    public float getLength() {
        return (float)Math.sqrt(this.getLengthSqared());
    }

    public Vector2F normalize() {
        float l = this.getLengthSqared();
        if (l > 0.0f) {
            l = (float)Math.sqrt(l);
            this.x /= l;
            this.y /= l;
        }
        return this;
    }

    public String toString() {
        return String.format(Locale.ROOT, "[%f, %f]", Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public Vector2F multiple(float n) {
        this.x *= n;
        this.y *= n;
        return this;
    }

    public Vector2F add(Vector2F vec) {
        this.x += vec.x;
        this.y += vec.y;
        return this;
    }

    public Vector2F add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2F set(Vector2F vec) {
        this.x = vec.x;
        this.y = vec.y;
        return this;
    }

    public Vector2F set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2F subtract(Vector2F vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        return this;
    }

    public float dot(Vector2F vec) {
        return this.x * vec.x + this.y * vec.y;
    }

    public Vector2F rotateCW() {
        float nx = this.y;
        float ny = -this.x;
        this.x = nx;
        this.y = ny;
        return this;
    }

    public float distance(Vector2F vec) {
        float x = this.x - vec.x;
        float y = this.y - vec.y;
        return (float)Math.sqrt(x * x + y * y);
    }

    public float distanceSquared(Vector2F vec) {
        float x = this.x - vec.x;
        float y = this.y - vec.y;
        return x * x + y * y;
    }

    public float angle(Vector2F vec) {
        return (float)Math.acos(this.dot(vec));
    }

    public float signAngle(Vector2F vec) {
        float angle = this.angle(vec);
        boolean sign = (double)(this.clone().rotateCW().angle(vec) * 2.0f) > Math.PI;
        return sign ? -angle : angle;
    }

    public int hashCode() {
        return (Float.hashCode(this.x) & 0xFFFF) << 16 | Float.hashCode(this.y) & 0xFFFF;
    }
}

