/*
 * Decompiled with CFR 0.152.
 */
package paulevs.skyworld.structures.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_4543;
import paulevs.skyworld.generator.SkyChunkGenerator;
import paulevs.skyworld.math.MHelper;
import paulevs.skyworld.math.Vector2F;
import paulevs.skyworld.structures.generators.Generators;
import paulevs.skyworld.structures.generators.IslandGenerator;
import paulevs.skyworld.structures.piece.IslandPiece;

public class IslandFeature
extends class_3195<class_3111> {
    private int salt = this.method_14019().hashCode();
    private int distance = 6;
    private int separation = 3;

    public IslandFeature(Function<Dynamic<?>, ? extends class_3111> configFactory) {
        super(configFactory);
    }

    protected class_1923 method_14018(class_2794<?> chunkGenerator, Random random, int chunkX, int chunkZ, int scaleX, int scaleZ) {
        int o = chunkX + this.distance * scaleX;
        int p = chunkZ + this.distance * scaleZ;
        int q = o < 0 ? o - this.distance + 1 : o;
        int r = p < 0 ? p - this.distance + 1 : p;
        int x = q / this.distance;
        int z = r / this.distance;
        ((class_2919)random).method_12665(chunkGenerator.method_12101(), x, z, this.salt);
        x *= this.distance;
        z *= this.distance;
        return new class_1923(x += random.nextInt(this.distance - this.separation), z += random.nextInt(this.distance - this.separation));
    }

    public boolean method_14026(class_4543 biomeAccess, class_2794<?> chunkGenerator, Random random, int chunkX, int chunkZ, class_1959 biome) {
        if (chunkGenerator instanceof SkyChunkGenerator) {
            class_1923 pos = this.method_14018(chunkGenerator, random, chunkX, chunkZ, 0, 0);
            if (chunkX == pos.field_9181 && chunkZ == pos.field_9180) {
                return true;
            }
        }
        return false;
    }

    protected void setDistance(int distance) {
        this.distance = distance;
    }

    protected void setSeparation(int separation) {
        this.separation = separation;
    }

    protected void setSalt(int salt) {
        this.salt = salt;
    }

    public class_3195.class_3774 method_14016() {
        return IslandStart::new;
    }

    public String method_14019() {
        return "sky_island";
    }

    public int method_14021() {
        return 4;
    }

    public static class IslandStart
    extends class_3449 {
        public IslandStart(class_3195<?> feature, int chunkX, int chunkZ, class_3341 box, int references, long l) {
            super(feature, chunkX, chunkZ, box, references, l);
        }

        public void method_16655(class_2794<?> chunkGenerator, class_3485 structureManager, int x, int z, class_1959 biome) {
            int px = x << 4;
            int pz = z << 4;
            IslandGenerator generator = Generators.getGenerator((Random)this.field_16715);
            int radius = MHelper.getSquaredRange(generator.getMinSize(), generator.getMaxSize(), (Random)this.field_16715);
            class_2338 center = new class_2338(px + this.field_16715.nextInt(16), MHelper.randRange(radius + 16, 128, (Random)this.field_16715), pz + this.field_16715.nextInt(16));
            this.field_15325.add(new IslandPiece(center, radius, (Random)this.field_16715, generator));
            if (radius > 30 && this.field_16715.nextBoolean()) {
                int spirals = MHelper.randRange(1, 3, (Random)this.field_16715);
                float startAngle = this.field_16715.nextFloat() * ((float)Math.PI * 2);
                float dx = MHelper.randRange(0.4f, 0.8f, (Random)this.field_16715);
                float dr = MHelper.randRange(0.4f, 0.8f, (Random)this.field_16715) * (float)radius;
                float offsetR = MHelper.randRange((float)radius * 1.3f, (float)radius * 1.5f, (Random)this.field_16715) * generator.groupDistanceMultiplier();
                Vector2F offset = new Vector2F();
                int yDelta = (int)((double)radius * 0.1);
                float xDist = 0.0256f * dx + 0.7949f;
                for (int s = 0; s < spirals; ++s) {
                    float offsetX = (float)s * ((float)Math.PI * 2) / (float)spirals + startAngle;
                    int count = MHelper.randRange(2, radius / 5, (Random)this.field_16715);
                    for (int i = 0; i < count; ++i) {
                        MHelper.getSpiral((float)i * xDist, dx, dr, offsetX, offsetR, offset);
                        class_2338 childPos = center.method_10080((double)offset.getX(), (double)(MHelper.randRange(-yDelta, yDelta, (Random)this.field_16715) - i * yDelta), (double)offset.getY());
                        int rad = (int)((double)((count - i) * radius) * 0.5 / (double)count);
                        int max = Math.min(generator.getMinSize(), rad);
                        int min = Math.max(generator.getMinSize(), rad / 2);
                        rad = MHelper.getSquaredRange(min, max, (Random)this.field_16715);
                        this.field_15325.add(new IslandPiece(childPos, rad, (Random)this.field_16715, Generators.cloneGenerator(generator)));
                    }
                }
            }
            this.method_14969();
        }
    }
}

