/*
 * Decompiled with CFR 0.152.
 */
package paulevs.skyworld.structures.generators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import paulevs.skyworld.structures.generators.IslandConeGenerator;
import paulevs.skyworld.structures.generators.IslandDoubleConeGenerator;
import paulevs.skyworld.structures.generators.IslandFlatSphereGenerator;
import paulevs.skyworld.structures.generators.IslandGenerator;
import paulevs.skyworld.structures.generators.IslandSphereGenerator;
import paulevs.skyworld.structures.generators.IslandTallSphereGenerator;

public class Generators {
    private static final List<String> GENERATOR_LIST = new ArrayList<String>();
    private static final Map<String, Class<? extends IslandGenerator>> GENERATORS = new HashMap<String, Class<? extends IslandGenerator>>();

    public static IslandGenerator getGenerator(String name) {
        Class<? extends IslandGenerator> gen = GENERATORS.get(name);
        try {
            return gen != null ? gen.getConstructor(new Class[0]).newInstance(new Object[0]).setName(name) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void register(String name, Class<? extends IslandGenerator> generator) {
        GENERATORS.put(name, generator);
        GENERATOR_LIST.add(name);
    }

    public static IslandGenerator getGenerator(Random random) {
        return Generators.getGenerator(GENERATOR_LIST.get(random.nextInt(GENERATOR_LIST.size())));
    }

    public static IslandGenerator cloneGenerator(IslandGenerator generator) {
        return Generators.getGenerator(generator.getName());
    }

    static {
        Generators.register("flat_sphere", IslandFlatSphereGenerator.class);
        Generators.register("cone", IslandConeGenerator.class);
        Generators.register("sphere", IslandSphereGenerator.class);
        Generators.register("double_cone", IslandDoubleConeGenerator.class);
        Generators.register("tall_sphere", IslandTallSphereGenerator.class);
    }
}

