/*
 * Decompiled with CFR 0.152.
 */
package paulevs.skyworld.structures.generators;

import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3531;
import paulevs.skyworld.math.MHelper;
import paulevs.skyworld.math.SDF;
import paulevs.skyworld.structures.generators.IslandGenerator;

public class IslandDoubleConeGenerator
extends IslandGenerator {
    private float noisePower;
    private float noiseScale;
    private class_2338 cone1Pos;
    private class_2338 cone2Pos;
    private class_2338 cone4Pos;
    private int h1;
    private int h2;
    private int h3;
    private float r2;
    private float r3;
    private float r4;
    private float blend;

    @Override
    public void initValues(class_2338 center, int radius) {
        this.h1 = (int)Math.ceil((float)radius * 0.125f);
        this.h2 = radius - this.h1;
        this.h3 = (int)Math.ceil((float)radius * 0.4f);
        this.cone1Pos = center.method_10087(this.h1);
        this.cone2Pos = center.method_10087(this.h1 + this.h2);
        this.cone4Pos = center.method_10086(this.h3);
        this.r2 = (float)radius * 0.5f;
        this.r3 = (float)radius * 0.1f;
        this.r4 = (float)radius * 0.25f;
        this.blend = (float)radius * 0.75f;
        this.noisePower = (float)radius * 0.15f;
        this.noiseScale = 0.5f / (float)Math.log(radius);
    }

    @Override
    public void setBoundingBox(class_3341 box, class_2338 center, int radius) {
        box.field_14381 = center.method_10263() - radius;
        box.field_14380 = center.method_10264() - radius * 3;
        if (box.field_14380 < 0) {
            box.field_14380 = 0;
        }
        box.field_14379 = center.method_10260() - radius;
        box.field_14378 = center.method_10263() + radius;
        box.field_14377 = center.method_10264() + radius;
        box.field_14376 = center.method_10260() + radius;
    }

    @Override
    public void generate(class_1936 world, class_2794<?> generator, Random random, class_3341 box, class_1923 pos, class_2338 center, int radius) {
        HEIGHTMAP.clear();
        for (int x = box.field_14381; x <= box.field_14378; ++x) {
            B_POS.method_20787(x);
            for (int z = box.field_14379; z <= box.field_14376; ++z) {
                B_POS.method_20788(z);
                class_3531 config = world.method_23753((class_2338)B_POS).method_8722();
                int h = random.nextInt(3) + 2;
                for (int y = box.field_14377; y >= box.field_14380; --y) {
                    B_POS.method_10099(y);
                    float d = SDF.smoothUnion(SDF.coneSDF((class_2338)B_POS, this.cone1Pos, this.h1, this.r2, radius), SDF.coneSDF((class_2338)B_POS, this.cone2Pos, this.h2, this.r3, this.r2), this.blend);
                    d = SDF.smoothUnion(d, SDF.coneSDF((class_2338)B_POS, center, this.h3, this.r2, this.r4), this.blend);
                    d = SDF.smoothUnion(d, SDF.coneSDF((class_2338)B_POS, this.cone4Pos, this.h3, this.r4, this.r3), this.blend);
                    if (!(d < 0.0f) || !((d += MHelper.noise((class_2338)B_POS, this.noiseScale) * this.noisePower) < 0.0f)) continue;
                    if (this.isAir(world, B_POS.method_10084())) {
                        world.method_8652((class_2338)B_POS, config.method_15337(), 0);
                        HEIGHTMAP.addHeight(x - box.field_14381, y, z - box.field_14379);
                        continue;
                    }
                    if (this.isAir(world, B_POS.method_10086(h))) {
                        world.method_8652((class_2338)B_POS, config.method_15336(), 0);
                        continue;
                    }
                    world.method_8652((class_2338)B_POS, STONE, 0);
                }
            }
        }
        this.generateOres(box, world, random, radius);
        this.generateBushes(box, world, random, radius);
    }
}

