/*
 * Decompiled with CFR 0.152.
 */
package paulevs.skyworld.structures.generators;

import java.util.List;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2975;
import net.minecraft.class_2986;
import net.minecraft.class_2997;
import net.minecraft.class_3124;
import net.minecraft.class_3243;
import net.minecraft.class_3277;
import net.minecraft.class_3341;
import paulevs.skyworld.generator.SkyWorldBiomeSource;
import paulevs.skyworld.math.MHelper;
import paulevs.skyworld.structures.features.FoliagePair;
import paulevs.skyworld.structures.generators.VolumetricHeightmap;

public abstract class IslandGenerator {
    private static final class_2382[] OFFSETS = new class_2382[]{new class_2382(-1, 0, -1), new class_2382(-1, 0, 0), new class_2382(-1, 0, 1), new class_2382(0, 0, -1), new class_2382(0, 0, 1), new class_2382(1, 0, -1), new class_2382(1, 0, 0), new class_2382(1, 0, 1)};
    protected static final class_2680 STONE = class_2246.field_10340.method_9564();
    protected static final class_2338.class_2339 B_POS = new class_2338.class_2339();
    protected static final VolumetricHeightmap HEIGHTMAP = new VolumetricHeightmap();
    protected String name;

    public abstract void initValues(class_2338 var1, int var2);

    public abstract void setBoundingBox(class_3341 var1, class_2338 var2, int var3);

    public abstract void generate(class_1936 var1, class_2794<?> var2, Random var3, class_3341 var4, class_1923 var5, class_2338 var6, int var7);

    protected boolean isAir(class_1936 world, class_2338 pos) {
        return !world.method_8320(pos).method_21743((class_1922)world, pos);
    }

    public String getName() {
        return this.name;
    }

    public IslandGenerator setName(String name) {
        this.name = name;
        return this;
    }

    protected void generateBushes(class_3341 box, class_1936 world, Random random, int radius) {
        B_POS.method_10103(box.field_14381 + 8, 0, box.field_14379 + 8);
        class_1959 biome = world.method_23753((class_2338)B_POS);
        FoliagePair[] pairs = SkyWorldBiomeSource.getFoliage(biome);
        if (pairs != null && pairs.length > 0) {
            int count = radius > 20 ? 4 : (int)Math.ceil((float)radius / 5.0f);
            int countBush = MHelper.randRange(count / 2, count, random);
            int countVine = MHelper.randRange(count / 2, count, random);
            int sectionStart = VolumetricHeightmap.getSection(box.field_14380);
            int sectionEnd = VolumetricHeightmap.getSection(box.field_14377);
            for (int section = sectionStart; section <= sectionEnd; ++section) {
                FoliagePair pair;
                int h;
                int hz;
                int hx;
                int i;
                if (biome.method_8715() > 0.5f) {
                    for (i = 0; i < countBush; ++i) {
                        B_POS.method_20787(MHelper.randRange(box.field_14381, box.field_14378, random));
                        B_POS.method_20788(MHelper.randRange(box.field_14379, box.field_14376, random));
                        hx = B_POS.method_10263() - box.field_14381;
                        hz = B_POS.method_10260() - box.field_14379;
                        h = HEIGHTMAP.getRandomHeight(hx, hz, section, random);
                        if (h <= 0) continue;
                        B_POS.method_10099(h + 1);
                        pair = pairs[random.nextInt(pairs.length)];
                        this.makeBush(world, B_POS.method_10062(), pair, random);
                    }
                }
                if (!this.hasVines(biome)) continue;
                for (i = 0; i < countVine; ++i) {
                    B_POS.method_20787(MHelper.randRange(box.field_14381, box.field_14378, random));
                    B_POS.method_20788(MHelper.randRange(box.field_14379, box.field_14376, random));
                    hx = B_POS.method_10263() - box.field_14381;
                    hz = B_POS.method_10260() - box.field_14379;
                    h = HEIGHTMAP.getRandomHeight(hx, hz, section, random);
                    if (h <= 0) continue;
                    B_POS.method_10099(h + 1);
                    pair = pairs[random.nextInt(pairs.length)];
                    this.generateVine(world, pair, box, (class_2338)B_POS, random, radius);
                }
            }
            if (this.hasVines(biome)) {
                int i;
                for (i = 0; i < countVine * 2; ++i) {
                    B_POS.method_20787(MHelper.randRange(box.field_14381, box.field_14378, random));
                    B_POS.method_20788(MHelper.randRange(box.field_14379, box.field_14376, random));
                    B_POS.method_10099(box.field_14380);
                    while (world.method_22347((class_2338)B_POS) && B_POS.method_10264() < box.field_14377) {
                        B_POS.method_10099(B_POS.method_10264() + 1);
                    }
                    if (B_POS.method_10264() >= box.field_14377 - 1 || !world.method_22347((class_2338)B_POS)) continue;
                    B_POS.method_10099(B_POS.method_10264() - 1);
                    FoliagePair pair = pairs[random.nextInt(pairs.length)];
                    this.generateVine(world, pair, box, (class_2338)B_POS, random, radius / 2);
                }
                for (i = 0; i < countVine * 3; ++i) {
                    B_POS.method_20787(MHelper.randRange(box.field_14381, box.field_14378, random));
                    B_POS.method_20788(MHelper.randRange(box.field_14379, box.field_14376, random));
                    B_POS.method_10099(box.field_14380);
                    boolean sides = false;
                    while (world.method_22347((class_2338)B_POS) && B_POS.method_10264() < box.field_14377 && !sides) {
                        B_POS.method_10099(B_POS.method_10264() + 1);
                        sides = this.hasSideBlocks(world, (class_2338)B_POS);
                    }
                    if (B_POS.method_10264() >= box.field_14377 - 1 || !world.method_22347((class_2338)B_POS) || !sides) continue;
                    this.generateVanillaVine(world, (class_2338)B_POS, random, radius * 3 / 2);
                }
            }
        }
    }

    private boolean hasVines(class_1959 biome) {
        float t = biome.method_8712();
        return t >= 0.5f && t <= 1.5f && biome.method_8715() > 0.5f;
    }

    protected void generateVine(class_1936 world, FoliagePair pair, class_3341 box, class_2338 pos, Random random, int maxLength) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        B_POS.method_10101((class_2382)pos);
        int length = MHelper.randRange(maxLength > 5 ? 5 : 0, maxLength, random);
        int length2 = length / 2;
        boolean offseted = false;
        block0: for (int i = 0; i < length; ++i) {
            class_2382 offset;
            if (i < length2) {
                offset = OFFSETS[random.nextInt(OFFSETS.length)];
                B_POS.method_20787(x + offset.method_10263());
                B_POS.method_20788(z + offset.method_10260());
                if (world.method_22347((class_2338)B_POS)) {
                    pair.setLeavesNoDecay(world, (class_2338)B_POS, random);
                }
                B_POS.method_20787(x);
                B_POS.method_20788(z);
            }
            B_POS.method_10099(y--);
            if (world.method_22347((class_2338)B_POS)) {
                if (!offseted && random.nextBoolean()) {
                    offset = OFFSETS[random.nextInt(OFFSETS.length)];
                    B_POS.method_20787(x + offset.method_10263());
                    B_POS.method_20788(z + offset.method_10260());
                    if (!world.method_22347((class_2338)B_POS)) {
                        B_POS.method_20787(x);
                        B_POS.method_20788(z);
                    }
                    pair.setLeavesNoDecay(world, (class_2338)B_POS, random);
                    B_POS.method_20787(x);
                    B_POS.method_20788(z);
                    offseted = true;
                    continue;
                }
                offseted = false;
                pair.setLeavesNoDecay(world, (class_2338)B_POS, random);
                continue;
            }
            for (class_2382 dir : OFFSETS) {
                B_POS.method_20787(x + dir.method_10263());
                B_POS.method_20788(z + dir.method_10260());
                if (!box.method_14662((class_2382)B_POS) || !world.method_22347((class_2338)B_POS)) continue;
                pair.setLeavesNoDecay(world, (class_2338)B_POS, random);
                x = pos.method_10263();
                z = pos.method_10260();
                continue block0;
            }
        }
    }

    protected void generateVanillaVine(class_1936 world, class_2338 pos, Random random, int maxLength) {
        boolean north = !this.isAir(world, pos.method_10095());
        boolean south = !this.isAir(world, pos.method_10072());
        boolean east = !this.isAir(world, pos.method_10078());
        boolean west = !this.isAir(world, pos.method_10067());
        class_2680 vine = (class_2680)((class_2680)((class_2680)((class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)class_2541.field_11706, (Comparable)Boolean.valueOf(north))).method_11657((class_2769)class_2541.field_11699, (Comparable)Boolean.valueOf(south))).method_11657((class_2769)class_2541.field_11702, (Comparable)Boolean.valueOf(east))).method_11657((class_2769)class_2541.field_11696, (Comparable)Boolean.valueOf(west));
        int length = MHelper.randRange(maxLength > 5 ? 5 : 0, maxLength, random);
        B_POS.method_10101((class_2382)pos);
        int y = pos.method_10264();
        for (int i = 0; i < length; ++i) {
            B_POS.method_10099(y - i);
            if (!world.method_22347((class_2338)B_POS)) continue;
            world.method_8652((class_2338)B_POS, vine, 0);
        }
    }

    protected boolean hasSideBlocks(class_1936 world, class_2338 pos) {
        return !this.isAir(world, pos.method_10095()) || !this.isAir(world, pos.method_10072()) || !this.isAir(world, pos.method_10078()) || !this.isAir(world, pos.method_10067());
    }

    protected void generateOres(class_3341 box, class_1936 world, Random random, int radius) {
        int oreRange = box.field_14377 - box.field_14380;
        int middle = box.field_14380 + oreRange / 2;
        float countCoef = 128.0f / (float)oreRange;
        B_POS.method_10103(box.field_14381 + 8, 0, box.field_14379 + 8);
        List ores = world.method_23753((class_2338)B_POS).method_8721(class_2893.class_2895.field_13176);
        for (class_2975 feature : ores) {
            class_2986 conf = (class_2986)feature.field_13375;
            if (!(conf.field_13399.field_13375 instanceof class_3124)) continue;
            class_3124 oreConfig = (class_3124)conf.field_13399.field_13375;
            if (oreConfig.field_13725 != class_3124.class_3125.field_13730) continue;
            class_3243 decorator = conf.field_13398;
            int maxY = 0;
            int count = 0;
            if (decorator.field_14114 instanceof class_3277) {
                class_3277 depthDecoratorConfig = (class_3277)decorator.field_14114;
                maxY = depthDecoratorConfig.field_14213 + depthDecoratorConfig.field_14212;
                count = depthDecoratorConfig.field_14214;
            } else {
                if (!(decorator.field_14114 instanceof class_2997)) continue;
                class_2997 rangeConfig = (class_2997)decorator.field_14114;
                maxY = rangeConfig.field_13432;
                count = rangeConfig.field_13435;
            }
            if (radius < 20 && maxY < 30) continue;
            maxY = maxY > 30 ? box.field_14377 : middle;
            count = MHelper.randRange(1, (int)Math.ceil((float)count * countCoef), random);
            if (radius < 20 && count > 3) {
                count = 3;
            }
            for (int n = 0; n < count; ++n) {
                B_POS.method_10103(MHelper.randRange(box.field_14381, box.field_14378, random), MHelper.randRange(box.field_14380, maxY, random), MHelper.randRange(box.field_14379, box.field_14376, random));
                int size = random.nextInt(oreConfig.field_13723 * 2);
                for (int i = 0; i < size; ++i) {
                    B_POS.method_10098(class_2350.method_10162((Random)random));
                    if (world.method_8320((class_2338)B_POS) != STONE) continue;
                    world.method_8652((class_2338)B_POS, oreConfig.field_13724, 0);
                }
            }
        }
    }

    protected void makeBush(class_1936 world, class_2338 pos, FoliagePair foliage, Random random) {
        int r = MHelper.randRange(1, 3, random);
        int x1 = pos.method_10263() - r;
        int x2 = pos.method_10263() + r;
        int ry = (int)Math.ceil((float)r * 0.3f);
        int y1 = pos.method_10264() - ry;
        int y2 = pos.method_10264() + ry;
        int z1 = pos.method_10260() - r;
        int z2 = pos.method_10260() + r;
        for (int y = y1; y <= y2; ++y) {
            B_POS.method_10099(y);
            int r2 = r - Math.abs(y - pos.method_10264());
            r2 *= r2;
            int minR = r2 / 3;
            for (int x = x1; x <= x2; ++x) {
                B_POS.method_20787(x);
                int sqrX = x - pos.method_10263();
                sqrX *= sqrX;
                for (int z = z1; z <= z2; ++z) {
                    B_POS.method_20788(z);
                    int sqrZ = z - pos.method_10260();
                    sqrZ *= sqrZ;
                    int sum = sqrX + sqrZ;
                    if (!((double)sum < 1.5) && sum > MHelper.randRange(minR, r2, random) || !world.method_22347((class_2338)B_POS)) continue;
                    foliage.setLeaves(world, (class_2338)B_POS, random);
                }
            }
        }
        foliage.setTrunk(world, pos, random);
    }

    public int getMaxSize() {
        return 50;
    }

    public int getMinSize() {
        return 10;
    }

    public float groupDistanceMultiplier() {
        return 1.0f;
    }

    public float getSpiralPower() {
        return 1.0f;
    }
}

