/*
 * Decompiled with CFR 0.152.
 */
package paulevs.skyworld.structures.generators;

import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3531;
import paulevs.skyworld.math.MHelper;
import paulevs.skyworld.math.SDF;
import paulevs.skyworld.structures.generators.IslandGenerator;

public class IslandTallSphereGenerator
extends IslandGenerator {
    private float noisePower;
    private float noiseScale;
    private int radius2;

    @Override
    public void initValues(class_2338 center, int radius) {
        this.noisePower = (float)radius / 6.0f;
        this.noiseScale = 0.5f / (float)Math.log(radius);
        this.radius2 = Math.round((float)radius * 0.3f);
    }

    @Override
    public void setBoundingBox(class_3341 box, class_2338 center, int radius) {
        box.field_14381 = center.method_10263() - this.radius2;
        box.field_14380 = center.method_10264() - radius;
        box.field_14379 = center.method_10260() - this.radius2;
        box.field_14378 = center.method_10263() + this.radius2;
        box.field_14377 = center.method_10264() + radius;
        box.field_14376 = center.method_10260() + this.radius2;
    }

    @Override
    public void generate(class_1936 world, class_2794<?> generator, Random random, class_3341 box, class_1923 pos, class_2338 center, int radius) {
        HEIGHTMAP.clear();
        for (int x = box.field_14381; x <= box.field_14378; ++x) {
            B_POS.method_20787(x);
            for (int z = box.field_14379; z <= box.field_14376; ++z) {
                B_POS.method_20788(z);
                class_3531 config = world.method_23753((class_2338)B_POS).method_8722();
                int h = random.nextInt(3) + 2;
                for (int y = box.field_14377; y >= box.field_14380; --y) {
                    B_POS.method_10099(y);
                    float d = SDF.sdfEllipsoid((class_2338)B_POS, center, this.radius2, radius, this.radius2);
                    if (!(d < 0.0f) || !((d += MHelper.noise((class_2338)B_POS, this.noiseScale) * this.noisePower) < 0.0f)) continue;
                    if (this.isAir(world, B_POS.method_10084())) {
                        world.method_8652((class_2338)B_POS, config.method_15337(), 0);
                        HEIGHTMAP.addHeight(x - box.field_14381, y, z - box.field_14379);
                        continue;
                    }
                    if (this.isAir(world, B_POS.method_10086(h))) {
                        world.method_8652((class_2338)B_POS, config.method_15336(), 0);
                        continue;
                    }
                    world.method_8652((class_2338)B_POS, STONE, 0);
                }
            }
        }
        this.generateOres(box, world, random, radius);
        this.generateBushes(box, world, random, radius);
    }

    @Override
    public int getMaxSize() {
        return 60;
    }

    @Override
    public int getMinSize() {
        return 20;
    }

    @Override
    public float groupDistanceMultiplier() {
        return 0.4f;
    }

    @Override
    public float getSpiralPower() {
        return 2.0f;
    }
}

