/*
 * Decompiled with CFR 0.152.
 */
package paulevs.skyworld.structures.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_3532;

public class VolumetricHeightmap {
    private final Section[] sections = new Section[16];

    public VolumetricHeightmap() {
        for (int i = 0; i < 16; ++i) {
            this.sections[i] = new Section();
        }
    }

    public void clear() {
        for (Section s : this.sections) {
            s.clear();
        }
    }

    public void addHeight(int x, int y, int z) {
        if (y >= 0 && y < 256) {
            this.sections[y >> 4].addHeight(x, z, y);
        }
    }

    public int getRandomHeight(int x, int z, int section, Random random) {
        return this.sections[section].getRandomHeight(x, z, random);
    }

    public static int getSection(int y) {
        return class_3532.method_15340((int)(y >> 4), (int)0, (int)15);
    }

    private class Section {
        final List<Integer>[][] heights = new ArrayList[16][16];

        Section() {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.heights[x][z] = new ArrayList<Integer>();
                }
            }
        }

        void clear() {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.heights[x][z].clear();
                }
            }
        }

        void addHeight(int x, int z, int height) {
            this.heights[x][z].add(height);
        }

        int getRandomHeight(int x, int z, Random random) {
            if (this.heights[x][z].size() > 0) {
                return this.heights[x][z].get(random.nextInt(this.heights[x][z].size()));
            }
            return -1;
        }
    }
}

