/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nymmd;

import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import java.util.Map;
import java.util.stream.IntStream;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdPmdModel_BasicClass;
import jp.nyatla.nymmd.MmdVmdMotion_BasicClass;
import jp.nyatla.nymmd.core.PmdBone;
import jp.nyatla.nymmd.core.PmdFace;
import jp.nyatla.nymmd.core.PmdIK;
import jp.nyatla.nymmd.types.FaceData;
import jp.nyatla.nymmd.types.MmdMatrix;
import jp.nyatla.nymmd.types.MmdVector3;
import jp.nyatla.nymmd.types.MotionData;

public abstract class MmdMotionPlayer {
    protected MmdPmdModel_BasicClass _ref_pmd_model;
    protected MmdVmdMotion_BasicClass _ref_vmd_motion;
    private PmdBone[] m_ppBoneList;
    private PmdFace[] m_ppFaceList;
    public MmdMatrix[] _skinning_mat;
    public Map<String, Integer> boneNameToIndex = Maps.newHashMap();
    private PmdBone m_pNeckBone;
    public final EventBus eventBus = new EventBus();
    private MmdVector3 _looktarget = new MmdVector3();
    private boolean _lookme_enabled = false;

    public int getBoneIndexByName(String name) {
        Integer result = this.boneNameToIndex.get(name);
        return result == null ? -1 : result;
    }

    public PmdBone getBoneByName(String name) {
        int idx = this.getBoneIndexByName(name);
        if (idx < 0) {
            return null;
        }
        return this._ref_pmd_model.getBoneArray()[idx];
    }

    public void setPmd(MmdPmdModel_BasicClass i_pmd_model) throws MmdException {
        this._ref_pmd_model = i_pmd_model;
        PmdBone[] bone_array = i_pmd_model.getBoneArray();
        this._skinning_mat = MmdMatrix.createArray(bone_array.length);
        this.boneNameToIndex.clear();
        IntStream.range(0, bone_array.length).forEach(value -> this.boneNameToIndex.put(bone_array[value].getName(), value));
        this.m_pNeckBone = null;
        Integer headIdx = this.boneNameToIndex.get("\u9b06\uff6d");
        if (headIdx != null) {
            this.m_pNeckBone = bone_array[headIdx];
        }
        if (this._ref_vmd_motion != null) {
            this.makeBoneFaceList();
        }
    }

    public void setVmd(MmdVmdMotion_BasicClass i_vmd_model) throws MmdException {
        if (this._ref_vmd_motion == i_vmd_model) {
            return;
        }
        this._ref_vmd_motion = i_vmd_model;
        MotionData[] pMotionDataList = i_vmd_model.refMotionDataArray();
        this.m_ppBoneList = new PmdBone[pMotionDataList.length];
        FaceData[] pFaceDataList = i_vmd_model.refFaceDataArray();
        this.m_ppFaceList = new PmdFace[pFaceDataList.length];
        if (this._ref_pmd_model != null) {
            this.makeBoneFaceList();
        }
    }

    private void makeBoneFaceList() {
        MmdPmdModel_BasicClass pmd_model = this._ref_pmd_model;
        MmdVmdMotion_BasicClass vmd_model = this._ref_vmd_motion;
        MotionData[] pMotionDataList = vmd_model.refMotionDataArray();
        this.m_ppBoneList = new PmdBone[pMotionDataList.length];
        for (int i = 0; i < pMotionDataList.length; ++i) {
            this.m_ppBoneList[i] = pmd_model.getBoneByName(pMotionDataList[i].szBoneName);
        }
        FaceData[] pFaceDataList = vmd_model.refFaceDataArray();
        this.m_ppFaceList = new PmdFace[pFaceDataList.length];
        for (int i = 0; i < pFaceDataList.length; ++i) {
            this.m_ppFaceList[i] = pmd_model.getFaceByName(pFaceDataList[i].szFaceName);
        }
    }

    public float getTimeLength() {
        return (float)((double)this._ref_vmd_motion.getMaxFrame() * 33.333333333333336);
    }

    public void updateMotion(float i_position_in_msec) throws MmdException {
        int i;
        PmdIK[] ik_array = this._ref_pmd_model.getIKArray();
        PmdBone[] bone_array = this._ref_pmd_model.getBoneArray();
        assert (i_position_in_msec >= 0.0f);
        float frame = (float)((double)i_position_in_msec / 33.333333333333336);
        if (frame > this._ref_vmd_motion.getMaxFrame()) {
            frame = this._ref_vmd_motion.getMaxFrame();
        }
        this.updateFace(frame);
        for (PmdBone bone : bone_array) {
            bone.reset();
        }
        this.updateBone(frame);
        this.eventBus.post((Object)new UpdateBoneEvent.Pre(this._ref_pmd_model.getBoneArray(), this));
        for (i = 0; i < bone_array.length; ++i) {
            bone_array[i].updateMatrix();
        }
        for (i = 0; i < ik_array.length; ++i) {
            ik_array[i].update();
        }
        this.eventBus.post((Object)new UpdateBoneEvent.Pre(this._ref_pmd_model.getBoneArray(), this));
        for (i = 0; i < bone_array.length; ++i) {
            bone_array[i].updateMatrix();
        }
        if (this._lookme_enabled) {
            this.updateNeckBone();
        }
        for (i = 0; i < bone_array.length; ++i) {
            bone_array[i].updateSkinningMat(this._skinning_mat[i]);
        }
        this.onUpdateSkinningMatrix(this._skinning_mat);
    }

    protected abstract void onUpdateSkinningMatrix(MmdMatrix[] var1) throws MmdException;

    public void setLookVector(float i_x, float i_y, float i_z) {
        this._looktarget.x = i_x;
        this._looktarget.y = i_y;
        this._looktarget.z = i_z;
    }

    public void lookMeEnable(boolean i_enable) {
        this._lookme_enabled = i_enable;
    }

    private void updateNeckBone() {
        int i;
        if (this.m_pNeckBone == null) {
            return;
        }
        this.m_pNeckBone.lookAt(this._looktarget);
        PmdBone[] bone_array = this._ref_pmd_model.getBoneArray();
        for (i = 0; i < bone_array.length && this.m_pNeckBone != bone_array[i]; ++i) {
        }
        while (i < bone_array.length) {
            bone_array[i].updateMatrix();
            ++i;
        }
    }

    private void updateBone(float i_frame) throws MmdException {
        PmdBone[] ppBone = this.m_ppBoneList;
        MotionData[] pMotionDataList = this._ref_vmd_motion.refMotionDataArray();
        for (int i = 0; i < pMotionDataList.length; ++i) {
            if (ppBone[i] == null) continue;
            pMotionDataList[i].getMotionPosRot(i_frame, ppBone[i]);
        }
    }

    private void updateFace(float i_frame) throws MmdException {
        MmdVector3[] position_array = this._ref_pmd_model.getPositionArray();
        PmdFace[] ppFace = this.m_ppFaceList;
        FaceData[] pFaceDataList = this._ref_vmd_motion.refFaceDataArray();
        for (int i = 0; i < pFaceDataList.length; ++i) {
            float fFaceRate = this.getFaceRate(pFaceDataList[i], i_frame);
            if (ppFace[i] == null) continue;
            if (fFaceRate == 1.0f) {
                ppFace[i].setFace(position_array);
                continue;
            }
            if (!(0.001f < fFaceRate)) continue;
            ppFace[i].blendFace(position_array, fFaceRate);
        }
    }

    private float getFaceRate(FaceData pFaceData, float fFrame) {
        int i;
        int ulNumKeyFrame = pFaceData.ulNumKeyFrames;
        if (fFrame > pFaceData.pKeyFrames[ulNumKeyFrame - 1].fFrameNo) {
            fFrame = pFaceData.pKeyFrames[ulNumKeyFrame - 1].fFrameNo;
        }
        for (i = 0; i < ulNumKeyFrame && !(fFrame <= pFaceData.pKeyFrames[i].fFrameNo); ++i) {
        }
        int lKey0 = i - 1;
        int lKey1 = i;
        if (lKey0 <= 0) {
            lKey0 = 0;
        }
        if (i == ulNumKeyFrame) {
            lKey1 = ulNumKeyFrame - 1;
        }
        float fTime0 = pFaceData.pKeyFrames[lKey0].fFrameNo;
        float fTime1 = pFaceData.pKeyFrames[lKey1].fFrameNo;
        if (lKey0 != lKey1) {
            float fLerpValue = (fFrame - fTime0) / (fTime1 - fTime0);
            return pFaceData.pKeyFrames[lKey0].fRate * (1.0f - fLerpValue) + pFaceData.pKeyFrames[lKey1].fRate * fLerpValue;
        }
        return pFaceData.pKeyFrames[lKey0].fRate;
    }

    public static class UpdateBoneEvent {
        public final PmdBone[] bones;
        public final MmdMotionPlayer motionPlayer;

        public UpdateBoneEvent(PmdBone[] bones, MmdMotionPlayer motionPlayer) {
            this.bones = bones;
            this.motionPlayer = motionPlayer;
        }

        public static class Post
        extends UpdateBoneEvent {
            public Post(PmdBone[] bones, MmdMotionPlayer motionPlayer) {
                super(bones, motionPlayer);
            }
        }

        public static class Pre
        extends UpdateBoneEvent {
            public Pre(PmdBone[] bones, MmdMotionPlayer motionPlayer) {
                super(bones, motionPlayer);
            }
        }
    }
}

