/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nymmd;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;
import jp.nyatla.nymmd.BoneCompare;
import jp.nyatla.nymmd.FaceCompare;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.struct.DataReader;
import jp.nyatla.nymmd.struct.vmd.VMD_Face;
import jp.nyatla.nymmd.struct.vmd.VMD_Header;
import jp.nyatla.nymmd.struct.vmd.VMD_Motion;
import jp.nyatla.nymmd.types.BoneKeyFrame;
import jp.nyatla.nymmd.types.FaceData;
import jp.nyatla.nymmd.types.FaceKeyFrame;
import jp.nyatla.nymmd.types.MmdVector3;
import jp.nyatla.nymmd.types.MmdVector4;
import jp.nyatla.nymmd.types.MotionData;

public class MmdVmdMotion_BasicClass {
    private MotionData[] _motion_data_array;
    private FaceData[] _face_data_array;
    private float _fMaxFrame;

    public MmdVmdMotion_BasicClass(InputStream i_stream) throws MmdException {
        this.initialize(i_stream);
    }

    public MotionData[] refMotionDataArray() {
        return this._motion_data_array;
    }

    public FaceData[] refFaceDataArray() {
        return this._face_data_array;
    }

    public float getMaxFrame() {
        return this._fMaxFrame;
    }

    private boolean initialize(InputStream i_st) throws MmdException {
        if (i_st == null) {
            VMD_Header tmp_vmd_header = new VMD_Header();
            float[] max_frame = new float[1];
            this._motion_data_array = new MotionData[2];
            this._motion_data_array[0] = new MotionData();
            this._motion_data_array[0].szBoneName = "\u7e3a\u5436\u220b\u7e3a\uff66\u7e3a\uff6e\u9695\uff6a";
            this._motion_data_array[0].ulNumKeyFrames = 1;
            this._motion_data_array[0].pKeyFrames = new BoneKeyFrame[1];
            this._motion_data_array[0].pKeyFrames[0] = new BoneKeyFrame();
            this._motion_data_array[0].pKeyFrames[0].fFrameNo = 1.0f;
            this._motion_data_array[0].pKeyFrames[0].vec3Position.setValue(new MmdVector3(0.0f, 0.0f, 0.0f));
            this._motion_data_array[0].pKeyFrames[0].vec4Rotate.setValue(new MmdVector4(){
                {
                    this.x = 0.0;
                    this.y = 0.0;
                    this.z = 0.0;
                    this.w = 1.0;
                }
            });
            this._motion_data_array[1] = new MotionData();
            this._motion_data_array[1].szBoneName = "\u873f\uff73\u96dc\uff73\ufffd\uff7c\uff69\ufffd\uff7c\uff6b";
            this._motion_data_array[1].ulNumKeyFrames = 3;
            this._motion_data_array[1].pKeyFrames = new BoneKeyFrame[3];
            this._motion_data_array[1].pKeyFrames[0] = new BoneKeyFrame();
            this._motion_data_array[1].pKeyFrames[0].fFrameNo = 0.0f;
            this._motion_data_array[1].pKeyFrames[0].vec3Position.setValue(new MmdVector3(0.0f, 5.0f, 5.0f));
            this._motion_data_array[1].pKeyFrames[0].vec4Rotate.setValue(new MmdVector4(){
                {
                    this.x = 0.0;
                    this.y = 0.0;
                    this.z = 0.0;
                    this.w = 1.0;
                }
            });
            this._motion_data_array[1].pKeyFrames[1] = new BoneKeyFrame();
            this._motion_data_array[1].pKeyFrames[1].fFrameNo = 29.0f;
            this._motion_data_array[1].pKeyFrames[1].vec3Position.setValue(new MmdVector3(0.0f, -5.0f, 0.0f));
            this._motion_data_array[1].pKeyFrames[1].vec4Rotate.setValue(new MmdVector4(){
                {
                    this.x = 0.0;
                    this.y = 0.0;
                    this.z = 0.0;
                    this.w = 1.0;
                }
            });
            this._motion_data_array[1].pKeyFrames[2] = new BoneKeyFrame();
            this._motion_data_array[1].pKeyFrames[2].fFrameNo = 59.0f;
            this._motion_data_array[1].pKeyFrames[2].vec3Position.setValue(new MmdVector3(0.0f, 5.0f, -5.0f));
            this._motion_data_array[1].pKeyFrames[2].vec4Rotate.setValue(new MmdVector4(){
                {
                    this.x = 0.0;
                    this.y = 0.0;
                    this.z = 0.0;
                    this.w = 1.0;
                }
            });
            this._face_data_array = new FaceData[0];
            this._fMaxFrame = 60.0f;
            return true;
        }
        DataReader reader = new DataReader(i_st);
        VMD_Header tmp_vmd_header = new VMD_Header();
        tmp_vmd_header.read(reader);
        if (!tmp_vmd_header.szHeader.equalsIgnoreCase("Vocaloid Motion Data 0002")) {
            throw new MmdException();
        }
        float[] max_frame = new float[1];
        this._motion_data_array = MmdVmdMotion_BasicClass.createMotionDataList(reader, max_frame);
        this._fMaxFrame = max_frame[0];
        this._face_data_array = MmdVmdMotion_BasicClass.createFaceDataList(reader, max_frame);
        this._fMaxFrame = this._fMaxFrame > max_frame[0] ? this._fMaxFrame : max_frame[0];
        return true;
    }

    private static FaceData[] createFaceDataList(DataReader i_reader, float[] o_max_frame) throws MmdException {
        int i;
        Vector<FaceData> result = new Vector<FaceData>();
        int ulNumFaceKeyFrames = i_reader.readInt();
        VMD_Face[] tmp_vmd_face = new VMD_Face[ulNumFaceKeyFrames];
        for (int i2 = 0; i2 < ulNumFaceKeyFrames; ++i2) {
            tmp_vmd_face[i2] = new VMD_Face();
            tmp_vmd_face[i2].read(i_reader);
        }
        float max_frame = 0.0f;
        for (i = 0; i < ulNumFaceKeyFrames; ++i) {
            if (max_frame < (float)tmp_vmd_face[i].ulFrameNo) {
                max_frame = tmp_vmd_face[i].ulFrameNo;
            }
            boolean is_found = false;
            for (int i2 = 0; i2 < result.size(); ++i2) {
                FaceData pFaceTemp = (FaceData)result.get(i2);
                if (!pFaceTemp.szFaceName.equals(tmp_vmd_face[i].szFaceName)) continue;
                ++pFaceTemp.ulNumKeyFrames;
                is_found = true;
                break;
            }
            if (is_found) continue;
            FaceData pNew = new FaceData();
            pNew.szFaceName = tmp_vmd_face[i].szFaceName;
            pNew.ulNumKeyFrames = 1;
            result.add(pNew);
        }
        for (i = 0; i < result.size(); ++i) {
            FaceData pFaceTemp = (FaceData)result.get(i);
            pFaceTemp.pKeyFrames = FaceKeyFrame.createArray(pFaceTemp.ulNumKeyFrames);
            pFaceTemp.ulNumKeyFrames = 0;
        }
        block4: for (i = 0; i < ulNumFaceKeyFrames; ++i) {
            for (int i2 = 0; i2 < result.size(); ++i2) {
                FaceData pFaceTemp = (FaceData)result.get(i2);
                if (!pFaceTemp.szFaceName.equals(tmp_vmd_face[i].szFaceName)) continue;
                FaceKeyFrame pKeyFrame = pFaceTemp.pKeyFrames[pFaceTemp.ulNumKeyFrames];
                pKeyFrame.fFrameNo = tmp_vmd_face[i].ulFrameNo;
                pKeyFrame.fRate = tmp_vmd_face[i].fFactor;
                ++pFaceTemp.ulNumKeyFrames;
                continue block4;
            }
        }
        for (i = 0; i < result.size(); ++i) {
            FaceData pFaceTemp = (FaceData)result.get(i);
            Arrays.sort(pFaceTemp.pKeyFrames, new FaceCompare());
        }
        o_max_frame[0] = max_frame;
        return result.toArray(new FaceData[result.size()]);
    }

    private static MotionData[] createMotionDataList(DataReader i_reader, float[] o_max_frame) throws MmdException {
        int i;
        Vector<MotionData> result = new Vector<MotionData>();
        int ulNumBoneKeyFrames = i_reader.readInt();
        VMD_Motion[] tmp_vmd_motion = new VMD_Motion[ulNumBoneKeyFrames];
        for (int i2 = 0; i2 < ulNumBoneKeyFrames; ++i2) {
            tmp_vmd_motion[i2] = new VMD_Motion();
            tmp_vmd_motion[i2].read(i_reader);
        }
        float max_frame = 0.0f;
        for (i = 0; i < ulNumBoneKeyFrames; ++i) {
            if (max_frame < (float)tmp_vmd_motion[i].ulFrameNo) {
                max_frame = tmp_vmd_motion[i].ulFrameNo;
            }
            boolean is_found = false;
            for (int i2 = 0; i2 < result.size(); ++i2) {
                MotionData pMotTemp = (MotionData)result.get(i2);
                if (!pMotTemp.szBoneName.equals(tmp_vmd_motion[i].szBoneName)) continue;
                ++pMotTemp.ulNumKeyFrames;
                is_found = true;
                break;
            }
            if (is_found) continue;
            MotionData pNew = new MotionData();
            pNew.szBoneName = tmp_vmd_motion[i].szBoneName;
            pNew.ulNumKeyFrames = 1;
            result.add(pNew);
        }
        for (i = 0; i < result.size(); ++i) {
            MotionData pMotTemp = (MotionData)result.get(i);
            pMotTemp.pKeyFrames = BoneKeyFrame.createArray(pMotTemp.ulNumKeyFrames);
            pMotTemp.ulNumKeyFrames = 0;
        }
        block4: for (i = 0; i < ulNumBoneKeyFrames; ++i) {
            for (int i2 = 0; i2 < result.size(); ++i2) {
                MotionData pMotTemp = (MotionData)result.get(i2);
                if (!pMotTemp.szBoneName.equals(tmp_vmd_motion[i].szBoneName)) continue;
                BoneKeyFrame pKeyFrame = pMotTemp.pKeyFrames[pMotTemp.ulNumKeyFrames];
                pKeyFrame.fFrameNo = tmp_vmd_motion[i].ulFrameNo;
                pKeyFrame.vec3Position.setValue(tmp_vmd_motion[i].vec3Position);
                pKeyFrame.vec4Rotate.QuaternionNormalize(tmp_vmd_motion[i].vec4Rotate);
                ++pMotTemp.ulNumKeyFrames;
                continue block4;
            }
        }
        for (i = 0; i < result.size(); ++i) {
            MotionData pMotTemp = (MotionData)result.get(i);
            Arrays.sort(pMotTemp.pKeyFrames, new BoneCompare());
        }
        o_max_frame[0] = max_frame;
        return result.toArray(new MotionData[result.size()]);
    }
}

