/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import com.google.common.base.CaseFormat;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mods.flammpfeil.slashblade.ability.LockOnManager;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.imputstate.CapabilityImputState;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.LayerMainBlade;
import mods.flammpfeil.slashblade.client.renderer.LockonCircleRender;
import mods.flammpfeil.slashblade.client.renderer.SlashBladeTEISR;
import mods.flammpfeil.slashblade.client.renderer.entity.BladeItemEntityRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.BladeStandEntityRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.JudgementCutRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.SummonedSwordRenderer;
import mods.flammpfeil.slashblade.client.renderer.gui.RankRenderer;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModel;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntityJudgementCut;
import mods.flammpfeil.slashblade.event.AnvilCrafting;
import mods.flammpfeil.slashblade.event.BladeMaterialTooltips;
import mods.flammpfeil.slashblade.event.CapabilityAttachHandler;
import mods.flammpfeil.slashblade.event.FallHandler;
import mods.flammpfeil.slashblade.event.KillCounter;
import mods.flammpfeil.slashblade.event.KnockBackHandler;
import mods.flammpfeil.slashblade.event.MoveImputHandler;
import mods.flammpfeil.slashblade.event.RankPointHandler;
import mods.flammpfeil.slashblade.event.RefineHandler;
import mods.flammpfeil.slashblade.event.client.SneakingMotionCanceller;
import mods.flammpfeil.slashblade.item.BladeStandItem;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.ItemTierSlashBlade;
import mods.flammpfeil.slashblade.item.SBItems;
import mods.flammpfeil.slashblade.network.NetworkManager;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="slashblade")
public class SlashBlade {
    public static final String modid = "slashblade";
    public static final ItemGroup SLASHBLADE = new ItemGroup("slashblade"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            ItemStack stack = new ItemStack((IItemProvider)SBItems.slashblade);
            stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
                s.setModel(new ResourceLocation(SlashBlade.modid, "model/named/yamato.obj"));
                s.setTexture(new ResourceLocation(SlashBlade.modid, "model/named/yamato.png"));
            });
            return stack;
        }
    };
    private static final Logger LOGGER = LogManager.getLogger();

    public SlashBlade() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::Baked);
            MinecraftForge.EVENT_BUS.addListener(MoveImputHandler::onPlayerPostTick);
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkManager.register();
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilitySlashBlade.register();
        CapabilityMobEffect.register();
        CapabilityImputState.register();
        CapabilityConcentrationRank.register();
        MinecraftForge.EVENT_BUS.addListener(KnockBackHandler::onLivingKnockBack);
        FallHandler.getInstance().register();
        LockOnManager.getInstance().register();
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityAttachHandler());
        MinecraftForge.EVENT_BUS.register((Object)new StunManager());
        AnvilCrafting.getInstance().register();
        RefineHandler.getInstance().register();
        KillCounter.getInstance().register();
        RankPointHandler.getInstance().register();
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)BladeModelManager.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)BladeMotionManager.getInstance());
        Minecraft.func_71410_x().func_175598_ae().getSkinMap().values().stream().forEach(lr -> lr.func_177094_a(new LayerMainBlade(lr)));
        SneakingMotionCanceller.getInstance().register();
        LockonCircleRender.getInstance().register();
        BladeMaterialTooltips.getInstance().register();
        RankRenderer.getInstance().register();
        RenderingRegistry.registerEntityRenderingHandler(RegistryEvents.SummonedSword, SummonedSwordRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RegistryEvents.JudgementCut, JudgementCutRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RegistryEvents.BladeItem, BladeItemEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RegistryEvents.BladeStand, BladeStandEntityRenderer::new);
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @OnlyIn(value=Dist.CLIENT)
    private void Baked(ModelBakeEvent event) {
        ModelResourceLocation loc = new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)SBItems.slashblade), "inventory");
        BladeModel model = new BladeModel((IBakedModel)event.getModelRegistry().get(loc), event.getModelLoader());
        event.getModelRegistry().put(loc, model);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        static Supplier<Callable<ItemStackTileEntityRenderer>> teisr = () -> SlashBladeTEISR::new;
        public static final ResourceLocation BladeItemEntityLoc = new ResourceLocation("slashblade", RegistryEvents.classToString(BladeItemEntity.class));
        public static final EntityType<BladeItemEntity> BladeItem = EntityType.Builder.func_220322_a(BladeItemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(BladeItemEntity::createInstanceFromPacket).func_206830_a(BladeItemEntityLoc.toString());
        public static final ResourceLocation BladeStandEntityLoc = new ResourceLocation("slashblade", RegistryEvents.classToString(BladeStandEntity.class));
        public static final EntityType<BladeStandEntity> BladeStand = EntityType.Builder.func_220322_a(BladeStandEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).setCustomClientFactory(BladeStandEntity::createInstance).func_206830_a(BladeStandEntityLoc.toString());
        public static final ResourceLocation SummonedSwordLoc = new ResourceLocation("slashblade", RegistryEvents.classToString(EntityAbstractSummonedSword.class));
        public static final EntityType<EntityAbstractSummonedSword> SummonedSword = EntityType.Builder.func_220322_a(EntityAbstractSummonedSword::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityAbstractSummonedSword::createInstance).func_206830_a(SummonedSwordLoc.toString());
        public static final ResourceLocation JudgementCutLoc = new ResourceLocation("slashblade", RegistryEvents.classToString(EntityJudgementCut.class));
        public static final EntityType<EntityJudgementCut> JudgementCut = EntityType.Builder.func_220322_a(EntityJudgementCut::new, (EntityClassification)EntityClassification.MISC).func_220321_a(2.5f, 2.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityJudgementCut::createInstance).func_206830_a(JudgementCutLoc.toString());

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            LOGGER.info("HELLO from Register Block");
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register(new ItemSlashBlade(new ItemTierSlashBlade(() -> {
                Tag tags = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(SlashBlade.modid, "proudsouls"));
                return Ingredient.func_199805_a((Tag)tags);
            }), 1, -2.4f, new Item.Properties().func_200916_a(ItemGroup.field_78037_j).setISTER(teisr)).setRegistryName(SlashBlade.modid, SlashBlade.modid));
            ToolType proudsoulLevel = ToolType.get((String)"proudsoul");
            registry.register(new Item(new Item.Properties().func_200916_a(SLASHBLADE).addToolType(proudsoulLevel, 2)){

                public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
                    if (entity instanceof BladeItemEntity) {
                        return false;
                    }
                    CompoundNBT tag = entity.serializeNBT();
                    tag.func_74768_a("Health", 50);
                    short age = tag.func_74765_d("Age");
                    entity.deserializeNBT(tag);
                    if (entity.func_225510_bt_()) {
                        entity.func_213317_d(entity.func_213322_ci().func_216372_d(0.8, 0.0, 0.8).func_72441_c(0.0, 0.04, 0.0));
                    } else if (entity.func_70027_ad()) {
                        entity.func_213317_d(entity.func_213322_ci().func_216372_d(0.8, 0.5, 0.8).func_72441_c(0.0, 0.04, 0.0));
                    }
                    return false;
                }

                public boolean func_77636_d(ItemStack stack) {
                    return true;
                }
            }.setRegistryName(SlashBlade.modid, "proudsoul"));
            registry.register(new Item(new Item.Properties().func_200916_a(SLASHBLADE).addToolType(proudsoulLevel, 3)){

                public boolean func_77636_d(ItemStack stack) {
                    return true;
                }
            }.setRegistryName(SlashBlade.modid, "proudsoul_ingot"));
            registry.register(new Item(new Item.Properties().func_200916_a(SLASHBLADE).addToolType(proudsoulLevel, 1)){

                public boolean func_77636_d(ItemStack stack) {
                    return true;
                }
            }.setRegistryName(SlashBlade.modid, "proudsoul_tiny"));
            registry.register(new Item(new Item.Properties().func_200916_a(SLASHBLADE).addToolType(proudsoulLevel, 4).func_208103_a(Rarity.UNCOMMON)){

                public boolean func_77636_d(ItemStack stack) {
                    return true;
                }
            }.setRegistryName(SlashBlade.modid, "proudsoul_sphere"));
            registry.register(new Item(new Item.Properties().func_200916_a(SLASHBLADE).addToolType(proudsoulLevel, 5).func_208103_a(Rarity.RARE)){

                public boolean func_77636_d(ItemStack stack) {
                    return true;
                }
            }.setRegistryName(SlashBlade.modid, "proudsoul_crystal"));
            registry.register(new Item(new Item.Properties().func_200916_a(SLASHBLADE).addToolType(proudsoulLevel, 6).func_208103_a(Rarity.EPIC)){

                public boolean func_77636_d(ItemStack stack) {
                    return true;
                }
            }.setRegistryName(SlashBlade.modid, "proudsoul_trapezohedron"));
            registry.register(new BladeStandItem(new Item.Properties().func_200916_a(SLASHBLADE).func_208103_a(Rarity.COMMON)).setRegistryName(SlashBlade.modid, "bladestand_1"));
            registry.register(new BladeStandItem(new Item.Properties().func_200916_a(SLASHBLADE).func_208103_a(Rarity.COMMON)).setRegistryName(SlashBlade.modid, "bladestand_2"));
            registry.register(new BladeStandItem(new Item.Properties().func_200916_a(SLASHBLADE).func_208103_a(Rarity.COMMON)).setRegistryName(SlashBlade.modid, "bladestand_v"));
            registry.register(new BladeStandItem(new Item.Properties().func_200916_a(SLASHBLADE).func_208103_a(Rarity.COMMON)).setRegistryName(SlashBlade.modid, "bladestand_s"));
            registry.register(new BladeStandItem(new Item.Properties().func_200916_a(SLASHBLADE).func_208103_a(Rarity.COMMON), true).setRegistryName(SlashBlade.modid, "bladestand_1w"));
            registry.register(new BladeStandItem(new Item.Properties().func_200916_a(SLASHBLADE).func_208103_a(Rarity.COMMON), true).setRegistryName(SlashBlade.modid, "bladestand_2w"));
        }

        @SubscribeEvent
        public static void onEntitiesRegistry(RegistryEvent.Register<EntityType<?>> event) {
            Object entity = SummonedSword;
            entity.setRegistryName(SummonedSwordLoc);
            event.getRegistry().register(entity);
            entity = JudgementCut;
            entity.setRegistryName(JudgementCutLoc);
            event.getRegistry().register(entity);
            entity = BladeItem;
            entity.setRegistryName(BladeItemEntityLoc);
            event.getRegistry().register(entity);
            entity = BladeStand;
            entity.setRegistryName(BladeStandEntityLoc);
            event.getRegistry().register(entity);
        }

        private static String classToString(Class<? extends Entity> entityClass) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", "");
        }
    }
}

