/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import mods.flammpfeil.slashblade.capability.imputstate.CapabilityImputState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ImputCommand;
import mods.flammpfeil.slashblade.util.RayTraceHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.client.Minecraft;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LockOnManager {
    public static LockOnManager getInstance() {
        return SingletonHolder.instance;
    }

    private LockOnManager() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void onImputChange(EnumSet<ImputCommand> old, EnumSet<ImputCommand> current, ServerPlayerEntity player) {
        Entity targetEntity;
        if (old.contains((Object)ImputCommand.SNEAK) == current.contains((Object)ImputCommand.SNEAK)) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        if (old.contains((Object)ImputCommand.SNEAK) && !current.contains((Object)ImputCommand.SNEAK)) {
            targetEntity = null;
        } else {
            Optional<RayTraceResult> result = RayTraceHelper.rayTrace(player.field_70170_p, (Entity)player, player.func_174824_e(0.0f), player.func_70040_Z(), 12.0, 12.0, null);
            Optional<Entity> foundEntity = result.filter(r -> r.func_216346_c() == RayTraceResult.Type.ENTITY).filter(r -> {
                EntityRayTraceResult er = (EntityRayTraceResult)r;
                Entity target = ((EntityRayTraceResult)r).func_216348_a();
                boolean isMatch = true;
                if (target instanceof LivingEntity) {
                    isMatch = TargetSelector.lockon_focus.func_221015_a((LivingEntity)player, (LivingEntity)target);
                }
                return isMatch;
            }).map(r -> ((EntityRayTraceResult)r).func_216348_a());
            if (!foundEntity.isPresent()) {
                List entities = player.field_70170_p.func_217374_a(LivingEntity.class, TargetSelector.lockon, (LivingEntity)player, player.func_174813_aQ().func_72314_b(12.0, 6.0, 12.0));
                foundEntity = entities.stream().map(s -> s).min(Comparator.comparingDouble(e -> e.func_70068_e((Entity)player)));
            }
            targetEntity = foundEntity.orElse(null);
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> s.setTargetEntityId(targetEntity));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g != event.player) {
            return;
        }
        ItemStack stack = event.player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
            Entity target = s.getTargetEntity(event.player.field_70170_p);
            if (target == null) {
                return;
            }
            if (!target.func_70089_S()) {
                return;
            }
            PlayerEntity entity = event.player;
            if (!entity.field_70170_p.field_72995_K) {
                return;
            }
            if (!entity.getCapability(CapabilityImputState.IMPUT_STATE).filter(imput -> imput.getCommands().contains((Object)ImputCommand.SNEAK)).isPresent()) {
                return;
            }
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            float oldYawHead = entity.field_70759_as;
            float oldPitch = entity.field_70125_A;
            float oldYaw = entity.field_70177_z;
            entity.func_200602_a(EntityAnchorArgument.Type.EYES, target.func_174824_e(partialTicks));
            float step = 0.125f;
            step = (float)((double)step * Math.min(1.0, Math.abs(Math.tan(Math.toRadians(oldYaw - entity.field_70759_as)))));
            entity.field_70760_ar = entity.field_70761_aq = (entity.field_70759_as = MathHelper.func_219805_h((float)step, (float)oldYawHead, (float)entity.field_70759_as));
            entity.field_70125_A = MathHelper.func_219805_h((float)step, (float)oldPitch, (float)entity.field_70125_A);
            entity.field_70177_z = MathHelper.func_219805_h((float)step, (float)oldYaw, (float)entity.field_70177_z);
        });
    }

    private static final class SingletonHolder {
        private static final LockOnManager instance = new LockOnManager();

        private SingletonHolder() {
        }
    }
}

