/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.entity.ai.StunGoal;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StunManager {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof CreatureEntity)) {
            return;
        }
        CreatureEntity entity = (CreatureEntity)event.getEntity();
        entity.field_70714_bg.func_75776_a(-1, (Goal)new StunGoal(entity));
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity target = event.getEntityLiving();
        if (!(target instanceof CreatureEntity)) {
            return;
        }
        if (target == null) {
            return;
        }
        if (target.field_70170_p == null) {
            return;
        }
        boolean onStun = target.getCapability(CapabilityMobEffect.MOB_EFFECT).filter(state -> state.isStun(target.field_70170_p.func_82737_E())).isPresent();
        if (onStun) {
            Vec3d motion = target.func_213322_ci();
            if (5.0f < target.field_70143_R) {
                target.func_213293_j(motion.field_72450_a, motion.field_72448_b - 2.0, motion.field_72449_c);
            } else if (motion.field_72448_b < 0.0) {
                target.func_213293_j(motion.field_72450_a, motion.field_72448_b * 0.25, motion.field_72449_c);
            }
        }
    }

    public static void setStun(LivingEntity target) {
        StunManager.setStun(target, 10L);
    }

    public static void setStun(LivingEntity target, long duration) {
        if (!(target instanceof CreatureEntity)) {
            return;
        }
        if (target.field_70170_p == null) {
            return;
        }
        target.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(state -> state.setManagedStun(target.field_70170_p.func_82737_E(), duration));
    }

    public static void removeStun(LivingEntity target) {
        if (target.field_70170_p == null) {
            return;
        }
        if (!(target instanceof LivingEntity)) {
            return;
        }
        target.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(state -> {
            state.clearStunTimeOut();
            state.clearFreezeTimeOut();
        });
    }

    @SubscribeEvent
    public void onEntityCanUpdate(EntityEvent.CanUpdate event) {
        if (event.isCanceled()) {
            return;
        }
        Entity target = event.getEntity();
        if (target == null) {
            return;
        }
        if (target.field_70170_p == null) {
            return;
        }
        boolean onFreeze = target.getCapability(CapabilityMobEffect.MOB_EFFECT).filter(state -> state.isFreeze(target.field_70170_p.func_82737_E())).isPresent();
        if (onFreeze) {
            event.setCanUpdate(false);
        }
    }

    public static void setFreeze(LivingEntity target, long duration) {
        if (target.field_70170_p == null) {
            return;
        }
        if (!(target instanceof LivingEntity)) {
            return;
        }
        target.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(state -> state.setManagedFreeze(target.field_70170_p.func_82737_E(), duration));
    }
}

