/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.mobeffect;

public interface IMobEffectState {
    default public void setManagedStun(long now, long duration) {
        if (duration <= 0L) {
            return;
        }
        long solvedDuration = Math.min(duration, (long)this.getStunLimit());
        long timeout = now + solvedDuration;
        if (this.getStunTimeOut() < timeout) {
            this.setStunTimeOut(timeout);
        }
    }

    public void setStunTimeOut(long var1);

    default public void clearStunTimeOut() {
        this.setStunTimeOut(-1L);
    }

    public long getStunTimeOut();

    default public boolean isStun(long now) {
        return this.isStun(now, false);
    }

    default public boolean isStun(long now, boolean isVirtual) {
        long timeout = this.getStunTimeOut();
        if (timeout <= 0L) {
            return false;
        }
        if ((timeout -= now) <= 0L || (long)this.getStunLimit() < timeout) {
            if (!isVirtual) {
                this.clearStunTimeOut();
            }
            return false;
        }
        return true;
    }

    default public void setManagedFreeze(long now, long duration) {
        if (duration <= 0L) {
            return;
        }
        long solvedDuration = Math.min(duration, (long)this.getFreezeLimit());
        long timeout = now + solvedDuration;
        if (this.getFreezeTimeOut() < timeout) {
            this.setFreezeTimeOut(timeout);
        }
    }

    public void setFreezeTimeOut(long var1);

    default public void clearFreezeTimeOut() {
        this.setFreezeTimeOut(-1L);
    }

    public long getFreezeTimeOut();

    default public boolean isFreeze(long now) {
        return this.isFreeze(now, false);
    }

    default public boolean isFreeze(long now, boolean isVirtual) {
        long timeout = this.getFreezeTimeOut();
        if (timeout <= 0L) {
            return false;
        }
        if ((timeout -= now) <= 0L || (long)this.getFreezeLimit() < timeout) {
            if (!isVirtual) {
                this.clearFreezeTimeOut();
            }
            return false;
        }
        return true;
    }

    public int getStunLimit();

    public void setStunLimit(int var1);

    public int getFreezeLimit();

    public void setFreezeLimit(int var1);
}

