/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import java.util.Optional;
import java.util.UUID;
import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.RangeAttack;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilitySlashBlade {
    @CapabilityInject(value=ISlashBladeState.class)
    public static Capability<ISlashBladeState> BLADESTATE = null;

    protected static Vec3d readVec3dFrom(CompoundNBT tag, String key) {
        ListNBT list = tag.func_150295_c(key, 6);
        return new Vec3d(list.func_150309_d(0), list.func_150309_d(1), list.func_150309_d(2));
    }

    protected static ListNBT newDoubleNBTList(Vec3d vec) {
        return CapabilitySlashBlade.newDoubleNBTList(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    protected static ListNBT newDoubleNBTList(double ... numbers) {
        ListNBT listnbt = new ListNBT();
        for (double d0 : numbers) {
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)d0));
        }
        return listnbt;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ISlashBladeState.class, (Capability.IStorage)new Capability.IStorage<ISlashBladeState>(){

            public INBT writeNBT(Capability<ISlashBladeState> capability, ISlashBladeState instance, Direction side) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74772_a("lastActionTime", instance.getLastActionTime());
                tag.func_74768_a("TargetEntity", instance.getTargetEntityId());
                tag.func_74757_a("_onClick", instance.onClick());
                tag.func_74776_a("fallDecreaseRate", instance.getFallDecreaseRate());
                tag.func_74757_a("isCharged", instance.isCharged());
                tag.func_74776_a("AttackAmplifier", instance.getAttackAmplifier());
                tag.func_74778_a("currentCombo", instance.getComboSeq().getName());
                tag.func_74778_a("lastPosHash", instance.getLastPosHash());
                tag.func_74757_a("HasShield", instance.hasShield());
                tag.func_74776_a("Damage", instance.getDamage());
                tag.func_74757_a("isBroken", instance.isBroken());
                tag.func_74757_a("isNoScabbard", instance.isNoScabbard());
                tag.func_74757_a("isSealed", instance.isSealed());
                tag.func_74776_a("baseAttackModifier", instance.getBaseAttackModifier());
                tag.func_74768_a("killCount", instance.getKillCount());
                tag.func_74768_a("RepairCounter", instance.getRefine());
                UUID id = instance.getOwner();
                if (id != null) {
                    tag.func_186854_a("Owner", id);
                }
                UUID bladeId = instance.getUniqueId();
                tag.func_186854_a("BladeUniqueId", bladeId);
                tag.func_74778_a("RangeAttackType", instance.getRangeAttackType().getName());
                tag.func_74778_a("SpecialAttackType", Optional.ofNullable(instance.getSlashArtsKey()).orElse("none"));
                tag.func_74757_a("isDestructable", instance.isDestructable());
                tag.func_74757_a("isDefaultBewitched", instance.isDefaultBewitched());
                tag.func_74774_a("rarityType", (byte)instance.getRarity().ordinal());
                tag.func_74778_a("translationKey", instance.getTranslationKey());
                tag.func_74774_a("StandbyRenderType", (byte)instance.getCarryType().ordinal());
                tag.func_74768_a("SummonedSwordColor", instance.getColorCode());
                tag.func_74757_a("SummonedSwordColorInverse", instance.isEffectColorInverse());
                tag.func_218657_a("adjustXYZ", (INBT)CapabilitySlashBlade.newDoubleNBTList(instance.getAdjust()));
                instance.getTexture().ifPresent(loc -> tag.func_74778_a("TextureName", loc.toString()));
                instance.getModel().ifPresent(loc -> tag.func_74778_a("ModelName", loc.toString()));
                tag.func_74778_a("ComboRoot", Optional.ofNullable(instance.getComboRoot()).map(c -> c.getName()).orElseGet(() -> "standby"));
                return tag;
            }

            private <T extends Enum> T fromOrdinal(T[] values, int ordinal, T def) {
                if (0 <= ordinal && ordinal < values.length) {
                    return values[ordinal];
                }
                return def;
            }

            public void readNBT(Capability<ISlashBladeState> capability, ISlashBladeState instance, Direction side, INBT nbt) {
                CompoundNBT tag = (CompoundNBT)nbt;
                if (!(instance instanceof SlashBladeState)) {
                    throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
                }
                instance.setLastActionTime(tag.func_74763_f("lastActionTime"));
                instance.setTargetEntityId(tag.func_74762_e("TargetEntity"));
                instance.setOnClick(tag.func_74767_n("_onClick"));
                instance.setFallDecreaseRate(tag.func_74760_g("fallDecreaseRate"));
                instance.setCharged(tag.func_74767_n("isCharged"));
                instance.setAttackAmplifier(tag.func_74760_g("AttackAmplifier"));
                instance.setComboSeq((ComboState)((Object)ComboState.NONE.valueOf(tag.func_74779_i("currentCombo"))));
                instance.setLastPosHash(tag.func_74779_i("lastPosHash"));
                instance.setHasShield(tag.func_74767_n("HasShield"));
                instance.setDamage(tag.func_74760_g("Damage"));
                instance.setBroken(tag.func_74767_n("isBroken"));
                instance.setHasChangedActiveState(true);
                instance.setNoScabbard(tag.func_74767_n("isNoScabbard"));
                instance.setSealed(tag.func_74767_n("isSealed"));
                instance.setBaseAttackModifier(tag.func_74760_g("baseAttackModifier"));
                instance.setKillCount(tag.func_74762_e("killCount"));
                instance.setRefine(tag.func_74762_e("RepairCounter"));
                instance.setOwner(tag.func_186855_b("Owner") ? tag.func_186857_a("Owner") : null);
                instance.setUniqueId(tag.func_186855_b("BladeUniqueId") ? tag.func_186857_a("BladeUniqueId") : UUID.randomUUID());
                instance.setRangeAttackType((RangeAttack)((Object)RangeAttack.NONE.valueOf(tag.func_74779_i("RangeAttackType"))));
                instance.setSlashArtsKey(tag.func_74779_i("SpecialAttackType"));
                instance.setDestructable(tag.func_74767_n("isDestructable"));
                instance.setDefaultBewitched(tag.func_74767_n("isDefaultBewitched"));
                instance.setRarity((Rarity)this.fromOrdinal((Enum[])Rarity.values(), tag.func_74771_c("rarityType"), (Enum)Rarity.COMMON));
                instance.setTranslationKey(tag.func_74779_i("translationKey"));
                instance.setCarryType((CarryType)this.fromOrdinal(CarryType.values(), tag.func_74771_c("StandbyRenderType"), CarryType.DEFAULT));
                instance.setColorCode(tag.func_74762_e("SummonedSwordColor"));
                instance.setEffectColorInverse(tag.func_74767_n("SummonedSwordColorInverse"));
                instance.setAdjust(CapabilitySlashBlade.readVec3dFrom(tag, "adjustXYZ"));
                if (tag.func_74764_b("TextureName")) {
                    instance.setTexture(new ResourceLocation(tag.func_74779_i("TextureName")));
                } else {
                    instance.setTexture(null);
                }
                if (tag.func_74764_b("ModelName")) {
                    instance.setModel(new ResourceLocation(tag.func_74779_i("ModelName")));
                } else {
                    instance.setModel(null);
                }
                instance.setComboRootName(tag.func_74779_i("ComboRoot"));
            }
        }, () -> new SlashBladeState());
    }
}

