/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.imputstate.IImputState;
import mods.flammpfeil.slashblade.event.FallHandler;
import mods.flammpfeil.slashblade.event.KnockBackHandler;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialattack.SlashArts;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.ImputCommand;
import mods.flammpfeil.slashblade.util.RegistryBase;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class ComboState
extends RegistryBase<ComboState> {
    public static final ResourceLocation baseMotionLoc = new ResourceLocation("slashblade", "combostate/motion.vmd");
    @CapabilityInject(value=IImputState.class)
    public static Capability<IImputState> IMPUT_STATE = null;
    public static final ComboState NONE = new ComboState(BaseInstanceName, 1000, () -> 30, () -> 31, () -> Float.valueOf(1.0f), () -> true, () -> 1000, baseMotionLoc, a -> NONE, () -> NONE).setQuickChargeEnabled(() -> false);
    static List<Map.Entry<EnumSet<ImputCommand>, Supplier<ComboState>>> standbyMap = new HashMap<EnumSet<ImputCommand>, Supplier<ComboState>>(){
        {
            this.put(EnumSet.of(ImputCommand.ON_GROUND, ImputCommand.SNEAK, ImputCommand.FORWARD, ImputCommand.R_CLICK), () -> ARTS_RAPID_SLASH);
            this.put(EnumSet.of(ImputCommand.ON_GROUND, ImputCommand.L_CLICK), () -> COMBO_B1);
            this.put(EnumSet.of(ImputCommand.ON_GROUND, ImputCommand.BACK, ImputCommand.SNEAK, ImputCommand.R_CLICK), () -> COMBO_B1);
            this.put(EnumSet.of(ImputCommand.ON_GROUND, ImputCommand.R_CLICK), () -> COMBO_A1);
            this.put(EnumSet.of(ImputCommand.ON_AIR, ImputCommand.SNEAK, ImputCommand.FORWARD, ImputCommand.R_CLICK), () -> ARTS_HELM_BREAKER);
            this.put(EnumSet.of(ImputCommand.ON_AIR), () -> COMBO_AA1);
        }
    }.entrySet().stream().collect(Collectors.toList());
    public static final ComboState STANDBY = new ComboState("standby", 10, () -> 30, () -> 31, () -> Float.valueOf(1.0f), () -> true, () -> 1000, baseMotionLoc, a -> {
        EnumSet commands = (EnumSet)a.getCapability(IMPUT_STATE).map(state -> state.getCommands((LivingEntity)a)).orElseGet(() -> EnumSet.noneOf(ImputCommand.class));
        return standbyMap.stream().filter(entry -> commands.containsAll((Collection)entry.getKey())).min(Comparator.comparingInt(entry -> ((ComboState)((Object)((Object)((Object)((Supplier)entry.getValue()).get())))).getPriority())).map(entry -> (ComboState)((Object)((Object)((Object)((Supplier)entry.getValue()).get())))).orElseGet(() -> NONE);
    }, () -> NONE).setQuickChargeEnabled(() -> false);
    public static final ComboState COMBO_A1 = new ComboState("combo_a1", 100, () -> 60, () -> 70, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> COMBO_A2, () -> NONE).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).addHitEffect(StunManager::setStun).setQuickChargeEnabled(() -> false);
    public static final ComboState COMBO_A2 = new ComboState("combo_a2", 100, () -> 70, () -> 80, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> COMBO_A3, () -> NONE).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).addHitEffect(StunManager::setStun).setQuickChargeEnabled(() -> false);
    public static final ComboState COMBO_A3 = new ComboState("combo_a3", 100, () -> 80, () -> 90, () -> Float.valueOf(1.0f), () -> false, () -> 600, baseMotionLoc, a -> NONE, () -> COMBO_A3_F).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setBoost(ee, 1.5))).setQuickChargeEnabled(() -> false);
    public static final ComboState COMBO_A3_F = new ComboState("combo_a3_f", 100, () -> 90, () -> 120, () -> Float.valueOf(1.5f), () -> false, () -> 2000, baseMotionLoc, a -> NONE, () -> NONE);
    private static final EnumSet<ImputCommand> combo_b1_alt = EnumSet.of(ImputCommand.BACK, ImputCommand.R_DOWN);
    public static final ComboState COMBO_B1 = new ComboState("combo_b1", 90, () -> 150, () -> 160, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> COMBO_B2, () -> COMBO_B1_F).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setSmash(ee, 0.5))).addHoldAction(player -> {
        int elapsed = player.func_184612_cw();
        EnumSet commands = (EnumSet)player.getCapability(IMPUT_STATE).map(state -> state.getCommands((LivingEntity)player)).orElseGet(() -> EnumSet.noneOf(ImputCommand.class));
        if (5 == elapsed && commands.containsAll(combo_b1_alt)) {
            Vec3d motion = player.func_213322_ci();
            player.func_213293_j(motion.field_72450_a, motion.field_72448_b + 0.7, motion.field_72449_c);
            player.field_70122_E = false;
            player.field_70160_al = true;
        }
    }).addHitEffect(e -> StunManager.setStun(e, 15L)).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn)).setQuickChargeEnabled(() -> false);
    public static final ComboState COMBO_B1_F = new ComboState("combo_b1_f", 100, () -> 165, () -> 185, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> NONE, () -> NONE).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState COMBO_B2 = new ComboState("combo_b2", 90, () -> 200, () -> 215, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> NONE, () -> COMBO_B2_F).addHitEffect(StunManager::setStun).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setSmash(ee, -5.0))).setQuickChargeEnabled(() -> false);
    public static final ComboState COMBO_B2_F = new ComboState("combo_b2_f", 100, () -> 215, () -> 240, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> NONE, () -> NONE);
    public static final ComboState COMBO_AA1 = new ComboState("combo_aa1", 80, () -> 245, () -> 270, () -> Float.valueOf(1.0f), () -> false, () -> 500, baseMotionLoc, a -> COMBO_AA2, () -> COMBO_AA1_F).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).setIsAerial().addTickAction(playerIn -> {
        FallHandler.fallDecrease(playerIn);
        playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            long elapsed = state.getElapsedTime((LivingEntity)playerIn);
            if (elapsed == 4L) {
                AttackManager.areaAttack(playerIn, KnockBackHandler::setCancel);
            }
        });
    }).addHitEffect(StunManager::setStun).setIsAerial();
    public static final ComboState COMBO_AA1_F = new ComboState("combo_aa1_f", 80, () -> 269, () -> 270, () -> Float.valueOf(20.0f), () -> true, () -> 1000, baseMotionLoc, a -> COMBO_AA2, () -> NONE);
    public static final ComboState COMBO_AA2 = new ComboState("combo_aa2", 80, () -> 270, () -> 295, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> NONE, () -> COMBO_AA2_F).setClickAction(e -> AttackManager.areaAttack(e, ee -> KnockBackHandler.setBoost(ee, 1.5))).setIsAerial().addTickAction(playerIn -> FallHandler.fallDecrease(playerIn)).setQuickChargeEnabled(() -> false);
    public static final ComboState COMBO_AA2_F = new ComboState("combo_aa2_f", 100, () -> 295, () -> 300, () -> Float.valueOf(1.0f), () -> false, () -> 400, baseMotionLoc, a -> NONE, () -> NONE).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState ARTS_RAPID_SLASH = new ComboState("arts_rapid_slash", 70, () -> 80, () -> 90, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> ARTS_RAPID_SLASH_F, () -> ARTS_RAPID_SLASH_F).setClickAction(e -> AttackManager.areaAttack(e, KnockBackHandler::setCancel)).addHitEffect(StunManager::setStun).addHoldAction(playerIn -> {
        int elapsed = playerIn.func_184612_cw();
        if (elapsed < 6) {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> AttackManager.areaAttack(playerIn, KnockBackHandler::setCancel, 1.0f, false, false, true));
            if (elapsed % 3 == 1) {
                playerIn.field_70170_p.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
            }
        }
        if (elapsed <= 3 && playerIn.field_70122_E) {
            playerIn.func_213309_a(playerIn.func_70090_H() ? 0.35f : 0.8f, new Vec3d(0.0, 0.0, 1.0));
        }
        if (elapsed == 10 && (!playerIn.field_70170_p.field_72995_K || playerIn.field_70122_E)) {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                ComboState combo = ARTS_RISING_STAR;
                state.setComboSeq(combo);
                state.setLastActionTime(playerIn.field_70170_p.func_82737_E());
                combo.clickAction((LivingEntity)playerIn);
            });
        }
    });
    public static final ComboState ARTS_RAPID_SLASH_F = new ComboState("arts_rapid_slash_f", 70, () -> 90, () -> 120, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> NONE, () -> NONE);
    public static final ComboState ARTS_RISING_STAR = new ComboState("arts_rising_star", 100, () -> 250, () -> 255, () -> Float.valueOf(0.75f), () -> false, () -> 1000, baseMotionLoc, a -> NONE, () -> COMBO_A3_F).addHitEffect(StunManager::setStun).setIsAerial().setClickAction(playerIn -> {
        AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setSmash(ee, 0.5), 1.0f, true, false, false);
        Vec3d motion = playerIn.func_213322_ci();
        playerIn.func_213293_j(0.0, motion.field_72448_b + 0.7, 0.0);
        playerIn.field_70122_E = false;
        playerIn.field_70160_al = true;
    }).addHoldAction(playerIn -> {
        int elapsed = playerIn.func_184612_cw();
        if (elapsed < 6) {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setSmash(ee, 0.5), 1.0f, false, false, true));
            if (elapsed % 2 == 1) {
                playerIn.field_70170_p.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
            }
        }
    }).addTickAction(playerIn -> FallHandler.fallDecrease(playerIn));
    public static final ComboState ARTS_HELM_BREAKER = new ComboState("arts_helm_breaker", 70, () -> 200, () -> 215, () -> Float.valueOf(1.0f), () -> false, () -> 1000, baseMotionLoc, a -> NONE, () -> ARTS_HELM_BREAKER_F).addHitEffect(StunManager::setStun).setClickAction(playerIn -> {
        AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setSmash(ee, -5.0), 1.0f, true, false, false);
        Vec3d motion = playerIn.func_213322_ci();
        playerIn.func_213293_j(motion.field_72450_a, motion.field_72448_b - 0.7, motion.field_72449_c);
    }).addHoldAction(playerIn -> {
        int elapsed = playerIn.func_184612_cw();
        if (!playerIn.field_70122_E) {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setSmash(ee, -5.0), 1.0f, false, false, true));
            if (elapsed % 2 == 1) {
                playerIn.field_70170_p.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
            }
        }
    }).addTickAction(playerIn -> {
        if (!playerIn.field_70122_E) {
            playerIn.field_70143_R = 1.0f;
        } else {
            playerIn.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                AttackManager.areaAttack(playerIn, ee -> KnockBackHandler.setSmash(ee, -5.0), 1.3f, true, true, true);
                state.setComboSeq(ARTS_HELM_BREAKER_F);
                state.setLastActionTime(playerIn.field_70170_p.func_82737_E());
                FallHandler.spawnLandingParticle(playerIn, 20.0f);
            });
        }
    }).setQuickChargeEnabled(() -> false);
    public static final ComboState ARTS_HELM_BREAKER_F = new ComboState("arts_helm_breaker_f", 70, () -> 214, () -> 215, () -> Float.valueOf(20.0f), () -> true, () -> 600, baseMotionLoc, a -> NONE, () -> COMBO_B2_F).setQuickChargeEnabled(() -> false);
    static final EnumSet<ImputCommand> jc_cycle_imput = EnumSet.of(ImputCommand.L_DOWN, ImputCommand.R_CLICK);
    static final RangeMap<Long, SlashArts.ArtsType> jc_cycle_accept = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Long.valueOf(7L)), (Object)SlashArts.ArtsType.Fail).put(Range.closedOpen((Comparable)Long.valueOf(7L), (Comparable)Long.valueOf(8L)), (Object)SlashArts.ArtsType.Jackpot).put(Range.closed((Comparable)Long.valueOf(8L), (Comparable)Long.valueOf(9L)), (Object)SlashArts.ArtsType.Success).put(Range.greaterThan((Comparable)Long.valueOf(9L)), (Object)SlashArts.ArtsType.Fail).build();
    public static final ComboState SLASH_ARTS_JC = new ComboState("slash_arts_jc", 50, () -> 115, () -> 120, () -> Float.valueOf(0.5f), () -> false, () -> 600, baseMotionLoc, a -> {
        EnumSet commands = (EnumSet)a.getCapability(IMPUT_STATE).map(state -> state.getCommands((LivingEntity)a)).orElseGet(() -> EnumSet.noneOf(ImputCommand.class));
        if (commands.containsAll(jc_cycle_imput)) {
            return (ComboState)((Object)((Object)a.func_184614_ca().getCapability(ItemSlashBlade.BLADESTATE).map(s -> {
                long time = a.field_70170_p.func_82737_E();
                long lastAction = s.getLastActionTime();
                long count = time - lastAction;
                SlashArts.ArtsType type = (SlashArts.ArtsType)((Object)((Object)((Object)jc_cycle_accept.get((Comparable)Long.valueOf(count)))));
                return s.getSlashArts().doArts(type, (LivingEntity)a);
            }).orElse((Object)NONE)));
        }
        return NONE;
    }, () -> NONE).addTickAction(playerIn -> FallHandler.fallResist(playerIn));
    private ResourceLocation motionLoc;
    private Supplier<Integer> start;
    private Supplier<Integer> end;
    private Supplier<Float> speed;
    private Supplier<Boolean> roop;
    public Supplier<Integer> timeout;
    private Function<LivingEntity, ComboState> next;
    private Supplier<ComboState> nextOfTimeout;
    private Consumer<LivingEntity> holdAction;
    private Consumer<LivingEntity> tickAction;
    private Consumer<LivingEntity> hitEffect;
    private Consumer<LivingEntity> clickAction;
    private boolean isAerial;
    private int priority;
    private Supplier<Boolean> quickChargeEnabled;

    public ResourceLocation getMotionLoc() {
        return this.motionLoc;
    }

    public int getStartFrame() {
        return this.start.get();
    }

    public int getEndFrame() {
        return this.end.get();
    }

    public float getSpeed() {
        return this.speed.get().floatValue();
    }

    public boolean getRoop() {
        return this.roop.get();
    }

    public int getTimeoutMS() {
        return this.timeout.get();
    }

    public void holdAction(LivingEntity user) {
        this.holdAction.accept(user);
    }

    public ComboState addHoldAction(Consumer<LivingEntity> holdAction) {
        this.holdAction = this.holdAction.andThen(holdAction);
        return this;
    }

    public void tickAction(LivingEntity user) {
        this.tickAction.accept(user);
    }

    public ComboState addTickAction(Consumer<LivingEntity> tickAction) {
        this.tickAction = this.tickAction.andThen(tickAction);
        return this;
    }

    public void hitEffect(LivingEntity target) {
        this.hitEffect.accept(target);
    }

    public ComboState addHitEffect(Consumer<LivingEntity> hitEffect) {
        this.hitEffect = this.hitEffect.andThen(hitEffect);
        return this;
    }

    public void clickAction(LivingEntity user) {
        this.clickAction.accept(user);
    }

    public ComboState setClickAction(Consumer<LivingEntity> clickAction) {
        this.clickAction = clickAction;
        return this;
    }

    public ComboState setQuickChargeEnabled(Supplier<Boolean> sup) {
        this.quickChargeEnabled = sup;
        return this;
    }

    public boolean getQuickChargeEnabled() {
        return this.quickChargeEnabled.get();
    }

    public ComboState(String name, int priority, Supplier<Integer> start, Supplier<Integer> end, Supplier<Float> speed, Supplier<Boolean> roop, Supplier<Integer> timeout, ResourceLocation motionLoc, Function<LivingEntity, ComboState> next, Supplier<ComboState> nextOfTimeout) {
        super(name);
        this.start = start;
        this.end = end;
        this.speed = speed;
        this.timeout = timeout;
        this.roop = roop;
        this.motionLoc = motionLoc;
        this.next = next;
        this.nextOfTimeout = nextOfTimeout;
        this.holdAction = a -> {};
        this.tickAction = ArrowReflector::doTicks;
        this.hitEffect = a -> {};
        this.clickAction = user -> AttackManager.areaAttack(user, e -> {});
        this.isAerial = false;
        this.priority = priority;
        this.quickChargeEnabled = () -> true;
    }

    @Override
    public String getPath() {
        return "combostate";
    }

    @Override
    public ComboState getNone() {
        return NONE;
    }

    public ComboState getNext(LivingEntity living) {
        return this.next.apply(living);
    }

    public ComboState getNextOfTimeout() {
        return this.nextOfTimeout.get();
    }

    @Nonnull
    public ComboState checkTimeOut(float time) {
        return (float)this.timeout.get().intValue() < time ? this.nextOfTimeout.get() : this;
    }

    public boolean isAerial() {
        return this.isAerial;
    }

    public ComboState setIsAerial() {
        this.isAerial = true;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }
}

