/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.capability.slashblade.RangeAttack;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.network.ActiveStateSyncMessage;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.specialattack.SlashArts;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public interface ISlashBladeState {
    public long getLastActionTime();

    public void setLastActionTime(long var1);

    default public long getElapsedTime(LivingEntity user) {
        return Math.max(0L, user.field_70170_p.func_82737_E() - this.getLastActionTime());
    }

    public boolean onClick();

    public void setOnClick(boolean var1);

    public float getFallDecreaseRate();

    public void setFallDecreaseRate(float var1);

    public boolean isCharged();

    public void setCharged(boolean var1);

    public float getAttackAmplifier();

    public void setAttackAmplifier(float var1);

    @Nonnull
    public ComboState getComboSeq();

    public void setComboSeq(ComboState var1);

    public String getLastPosHash();

    public void setLastPosHash(String var1);

    public boolean hasShield();

    public void setHasShield(boolean var1);

    public boolean isBroken();

    public void setBroken(boolean var1);

    public boolean isNoScabbard();

    public void setNoScabbard(boolean var1);

    public boolean isSealed();

    public void setSealed(boolean var1);

    public float getBaseAttackModifier();

    public void setBaseAttackModifier(float var1);

    public int getKillCount();

    public void setKillCount(int var1);

    public int getRefine();

    public void setRefine(int var1);

    public UUID getOwner();

    public void setOwner(UUID var1);

    public UUID getUniqueId();

    public void setUniqueId(UUID var1);

    @Nonnull
    public RangeAttack getRangeAttackType();

    public void setRangeAttackType(RangeAttack var1);

    @Nonnull
    default public SlashArts getSlashArts() {
        String key = this.getSlashArtsKey();
        SlashArts result = null;
        if (key != null) {
            result = (SlashArts)((Object)SlashArts.NONE.valueOf(key));
        }
        if (result == SlashArts.NONE) {
            result = null;
        }
        return result != null ? result : SlashArts.JUDGEMENT_CUT;
    }

    public void setSlashArtsKey(String var1);

    public String getSlashArtsKey();

    public boolean isDestructable();

    public void setDestructable(boolean var1);

    public boolean isDefaultBewitched();

    public void setDefaultBewitched(boolean var1);

    @Nonnull
    public Rarity getRarity();

    public void setRarity(Rarity var1);

    @Nonnull
    public String getTranslationKey();

    public void setTranslationKey(String var1);

    @Nonnull
    public CarryType getCarryType();

    public void setCarryType(CarryType var1);

    @Nonnull
    public Color getEffectColor();

    public void setEffectColor(Color var1);

    public boolean isEffectColorInverse();

    public void setEffectColorInverse(boolean var1);

    default public void setColorCode(int colorCode) {
        this.setEffectColor(new Color(colorCode));
    }

    default public int getColorCode() {
        return this.getEffectColor().getRGB();
    }

    @Nonnull
    public Vec3d getAdjust();

    public void setAdjust(Vec3d var1);

    @Nonnull
    public Optional<ResourceLocation> getTexture();

    public void setTexture(ResourceLocation var1);

    @Nonnull
    public Optional<ResourceLocation> getModel();

    public void setModel(ResourceLocation var1);

    public int getTargetEntityId();

    public void setTargetEntityId(int var1);

    @Nullable
    default public Entity getTargetEntity(World world) {
        int id = this.getTargetEntityId();
        if (id < 0) {
            return null;
        }
        return world.func_73045_a(id);
    }

    default public void setTargetEntityId(Entity target) {
        if (target != null) {
            this.setTargetEntityId(target.func_145782_y());
        } else {
            this.setTargetEntityId(-1);
        }
    }

    default public int getFullChargeTicks(LivingEntity user) {
        return 20;
    }

    default public boolean isCharged(LivingEntity user) {
        int elapsed = user.func_184612_cw();
        return this.getFullChargeTicks(user) < elapsed;
    }

    default public ComboState progressCombo(LivingEntity user) {
        ComboState current = this.resolvCurrentComboState(user);
        ComboState next = current.getNext(user);
        ComboState rootNext = this.getComboRoot().getNext(user);
        ComboState resolved = next.getPriority() <= rootNext.getPriority() ? next : rootNext;
        this.setComboSeq(resolved);
        return resolved;
    }

    default public ComboState progressCombo(LivingEntity user, int elapsed) {
        ComboState cs;
        ComboState current;
        int fullChargeTicks = this.getFullChargeTicks(user);
        int justReceptionSpan = 3;
        int justChargePeriod = fullChargeTicks + justReceptionSpan;
        ImmutableRangeMap charge_accept = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Integer.valueOf(fullChargeTicks)), (Object)SlashArts.ArtsType.Fail).put(Range.closedOpen((Comparable)Integer.valueOf(fullChargeTicks), (Comparable)Integer.valueOf(justChargePeriod)), (Object)SlashArts.ArtsType.Jackpot).put(Range.atLeast((Comparable)Integer.valueOf(justChargePeriod)), (Object)SlashArts.ArtsType.Success).build();
        SlashArts.ArtsType type = (SlashArts.ArtsType)((Object)charge_accept.get((Comparable)Integer.valueOf(elapsed)));
        if (type != SlashArts.ArtsType.Jackpot && (current = this.resolvCurrentComboState(user)).getQuickChargeEnabled()) {
            int offsetTicks = 0;
            ComboState old = this.getComboSeq();
            if (old != current) {
                offsetTicks = (int)TimeValueHelper.getTicksFromMSec(old.getTimeoutMS());
            }
            int quickReceptionSpan = 5;
            int quickChargeTicks = (int)(TimeValueHelper.getTicksFromFrames(current.getEndFrame() - current.getStartFrame()) * (1.0f / current.getSpeed()) + (float)offsetTicks);
            int quickJustChargePeriod = quickChargeTicks + justReceptionSpan;
            int quickChargePeriod = quickChargeTicks + quickReceptionSpan;
            ImmutableRangeMap qcharge_accept = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Integer.valueOf(quickChargeTicks)), (Object)type).put(Range.closedOpen((Comparable)Integer.valueOf(quickChargeTicks), (Comparable)Integer.valueOf(quickJustChargePeriod)), (Object)SlashArts.ArtsType.Jackpot).put(Range.closedOpen((Comparable)Integer.valueOf(quickJustChargePeriod), (Comparable)Integer.valueOf(quickChargePeriod)), (Object)SlashArts.ArtsType.Success).put(Range.atLeast((Comparable)Integer.valueOf(quickChargePeriod)), (Object)type).build();
            type = (SlashArts.ArtsType)((Object)qcharge_accept.get((Comparable)Integer.valueOf(elapsed)));
        }
        if ((cs = this.getSlashArts().doArts(type, user)) != ComboState.NONE) {
            this.setComboSeq(cs);
            this.setLastActionTime(user.field_70170_p.func_82737_E());
        }
        return cs;
    }

    default public ComboState resolvCurrentComboState(LivingEntity user) {
        ComboState current = this.getComboSeq();
        for (float time = TimeValueHelper.getMSecFromTicks(this.getElapsedTime(user)); current != ComboState.NONE && (float)current.getTimeoutMS() < time; time -= (float)current.getTimeoutMS(), current = current.getNextOfTimeout()) {
        }
        return current;
    }

    default public boolean hasEnergy() {
        return true;
    }

    public String getComboRootName();

    public void setComboRootName(String var1);

    default public ComboState getComboRoot() {
        return Optional.ofNullable(ComboState.NONE.valueOf(this.getComboRootName())).orElseGet(() -> ComboState.STANDBY);
    }

    public CompoundNBT getShareTag();

    public void setShareTag(CompoundNBT var1);

    public float getDamage();

    public void setDamage(float var1);

    default public <T extends LivingEntity> void damageBlade(ItemStack stack, int amount, T entityIn, Consumer<T> onBroken) {
        if (amount <= 0) {
            return;
        }
        boolean current = this.isBroken();
        stack.func_222118_a(1, entityIn, s -> {});
        if (1.0f <= this.getDamage()) {
            this.setBroken(true);
        }
        if (current != this.isBroken()) {
            onBroken.accept(entityIn);
            if (entityIn instanceof ServerPlayerEntity) {
                stack.getShareTag();
                CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)entityIn, stack);
            }
            if (entityIn instanceof PlayerEntity) {
                ((PlayerEntity)entityIn).func_71029_a(Stats.field_199088_e.func_199076_b((Object)stack.func_77973_b()));
            }
        }
        if (this.isBroken() && this.isDestructable()) {
            stack.func_190918_g(1);
        }
    }

    default public float getDurabilityForDisplay() {
        return Math.max(0.0f, Math.min(this.getDamage(), 1.0f));
    }

    public boolean hasChangedActiveState();

    public void setHasChangedActiveState(boolean var1);

    default public void sendChanges(Entity entityIn) {
        if (!entityIn.field_70170_p.field_72995_K && this.hasChangedActiveState()) {
            ActiveStateSyncMessage msg = new ActiveStateSyncMessage();
            msg.activeTag = this.getActiveState();
            msg.id = entityIn.func_145782_y();
            NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entityIn), (Object)msg);
            this.setHasChangedActiveState(false);
        }
    }

    public static void removeActiveState(CompoundNBT tag) {
        NBTHelper.getNBTCoupler(tag).remove("lastActionTime").remove("TargetEntity").remove("_onClick").remove("fallDecreaseRate").remove("isCharged").remove("AttackAmplifier").remove("currentCombo").remove("lastPosHash").remove("HasShield").remove("killCount").remove("Damage");
    }

    default public CompoundNBT getActiveState() {
        CompoundNBT tag = new CompoundNBT();
        NBTHelper.getNBTCoupler(tag).put("BladeUniqueId", this.getUniqueId()).put("lastActionTime", this.getLastActionTime()).put("TargetEntity", this.getTargetEntityId()).put("_onClick", this.onClick()).put("fallDecreaseRate", Float.valueOf(this.getFallDecreaseRate())).put("isCharged", this.isCharged()).put("AttackAmplifier", Float.valueOf(this.getAttackAmplifier())).put("currentCombo", this.getComboSeq().getName()).put("lastPosHash", this.getLastPosHash()).put("HasShield", this.hasShield()).put("killCount", this.getKillCount()).put("Damage", Float.valueOf(this.getDamage())).put("isBroken", this.isBroken());
        return tag;
    }

    default public void setActiveState(CompoundNBT tag) {
        NBTHelper.getNBTCoupler(tag).get("lastActionTime", this::setLastActionTime, new Long[0]).get("TargetEntity", id -> this.setTargetEntityId((int)id), new Integer[0]).get("_onClick", this::setOnClick, new Boolean[0]).get("fallDecreaseRate", this::setFallDecreaseRate, new Float[0]).get("isCharged", this::setCharged, new Boolean[0]).get("AttackAmplifier", this::setAttackAmplifier, new Float[0]).get("currentCombo", s -> this.setComboSeq((ComboState)((Object)((Object)ComboState.NONE.valueOf((String)s)))), new String[0]).get("lastPosHash", this::setLastPosHash, new String[0]).get("HasShield", this::setHasShield, new Boolean[0]).get("killCount", this::setKillCount, new Integer[0]).get("Damage", this::setDamage, new Float[0]).get("isBroken", this::setBroken, new Boolean[0]);
        this.setHasChangedActiveState(false);
    }
}

