/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.FileNotFoundException;
import java.io.IOException;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdMotionPlayerGL2;
import jp.nyatla.nymmd.MmdPmdModelMc;
import jp.nyatla.nymmd.MmdPmdModel_BasicClass;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;

public class LayerMainBlade<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    final LazyOptional<MmdPmdModelMc> bladeholder = LazyOptional.of(() -> {
        try {
            return new MmdPmdModelMc(new ResourceLocation("slashblade", "model/bladeholder.pmd"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MmdException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    });
    final LazyOptional<MmdMotionPlayerGL2> motionPlayer = LazyOptional.of(() -> {
        MmdMotionPlayerGL2 mmp = new MmdMotionPlayerGL2();
        this.bladeholder.ifPresent(pmd -> {
            try {
                mmp.setPmd((MmdPmdModel_BasicClass)pmd);
            }
            catch (MmdException e) {
                e.printStackTrace();
            }
        });
        return mmp;
    });

    public LayerMainBlade(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    private float modifiedSpeed(float baseSpeed, LivingEntity entity) {
        float modif = 6.0f;
        if (EffectUtils.func_205135_a((LivingEntity)entity)) {
            modif = 6 - (1 + EffectUtils.func_205134_b((LivingEntity)entity));
        } else if (entity.func_70644_a(Effects.field_76419_f)) {
            modif = 6 + (1 + entity.func_70660_b(Effects.field_76419_f).func_76458_c()) * 2;
        }
        return baseSpeed / (modif /= 6.0f);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int lightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float motionYOffset = 1.5f;
        float motionScale = 0.125f;
        float modelScaleBase = 0.0078125f;
        ItemStack stack = entity.func_184586_b(Hand.MAIN_HAND);
        LazyOptional state = stack.getCapability(CapabilitySlashBlade.BLADESTATE);
        state.ifPresent(s -> this.motionPlayer.ifPresent(mmp -> {
            ComboState combo = s.getComboSeq();
            MmdVmdMotionMc motion = BladeMotionManager.getInstance().getMotion(combo.getMotionLoc());
            float maxSeconds = 0.0f;
            try {
                mmp.setVmd(motion);
                maxSeconds = TimeValueHelper.getMSecFromFrames(motion.getMaxFrame());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            float time = TimeValueHelper.getMSecFromTicks((float)Math.max(0L, entity.field_70170_p.func_82737_E() - s.getLastActionTime()) + partialTicks);
            ComboState next = combo.checkTimeOut(time);
            if (combo != next) {
                time -= (float)combo.getTimeoutMS();
                combo = next;
            }
            float start = TimeValueHelper.getMSecFromFrames(combo.getStartFrame());
            float end = TimeValueHelper.getMSecFromFrames(combo.getEndFrame());
            float span = end - start;
            span = Math.min(maxSeconds, span);
            time *= this.modifiedSpeed(combo.getSpeed(), (LivingEntity)entity);
            boolean isRoop = combo.getRoop();
            if (isRoop) {
                time %= span;
            }
            time = Math.min(span, time);
            time = start + time;
            try {
                mmp.updateMotion(time);
            }
            catch (MmdException e) {
                e.printStackTrace();
            }
            try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack);){
                MatrixStack.Entry entry;
                Matrix4f mat;
                int idx;
                matrixStack.func_227861_a_(0.0, (double)motionYOffset, 0.0);
                matrixStack.func_227862_a_(motionScale, motionScale, motionScale);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                ResourceLocation textureLocation = s.getTexture().orElseGet(() -> BladeModelManager.resourceDefaultTexture);
                WavefrontObject obj = BladeModelManager.getInstance().getModel(s.getModel().orElse(null));
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack);){
                    idx = mmp.getBoneIndexByName("hardpointA");
                    if (0 <= idx) {
                        float[] buf = new float[16];
                        mmp._skinning_mat[idx].getValue(buf);
                        mat = new Matrix4f(buf);
                        mat.func_226602_e_();
                        matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
                        entry = matrixStack.func_227866_c_();
                        entry.func_227870_a_().func_226595_a_(mat);
                        matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
                    }
                    float modelScale = modelScaleBase * (1.0f / motionScale);
                    matrixStack.func_227862_a_(modelScale, modelScale, modelScale);
                    String part = s.isBroken() ? "blade_damaged" : "blade";
                    BladeRenderState.renderOverrided(stack, obj, part, textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(stack, obj, part + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                }
                msac = MSAutoCloser.pushMatrix(matrixStack);
                var26_30 = null;
                try {
                    idx = mmp.getBoneIndexByName("hardpointB");
                    if (0 <= idx) {
                        float[] buf = new float[16];
                        mmp._skinning_mat[idx].getValue(buf);
                        mat = new Matrix4f(buf);
                        mat.func_226602_e_();
                        matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
                        entry = matrixStack.func_227866_c_();
                        entry.func_227870_a_().func_226595_a_(mat);
                        matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
                    }
                    float modelScale = modelScaleBase * (1.0f / motionScale);
                    matrixStack.func_227862_a_(modelScale, modelScale, modelScale);
                    BladeRenderState.renderOverrided(stack, obj, "sheath", textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(stack, obj, "sheath_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                    if (s.isCharged((LivingEntity)entity)) {
                        // empty if block
                    }
                }
                catch (Throwable throwable) {
                    var26_30 = throwable;
                    throw throwable;
                }
                finally {
                    if (msac != null) {
                        if (var26_30 != null) {
                            try {
                                msac.close();
                            }
                            catch (Throwable throwable) {
                                var26_30.addSuppressed(throwable);
                            }
                        } else {
                            msac.close();
                        }
                    }
                }
            }
        }));
    }
}

