/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class BladeModelManager {
    WavefrontObject defaultModel = new WavefrontObject(resourceDefaultModel);
    public static final ResourceLocation resourceDefaultModel = new ResourceLocation("slashblade", "model/blade.obj");
    public static final ResourceLocation resourceDefaultTexture = new ResourceLocation("slashblade", "model/blade.png");
    public static final ResourceLocation resourceDurabilityModel = new ResourceLocation("slashblade", "model/util/durability.obj");
    public static final ResourceLocation resourceDurabilityTexture = new ResourceLocation("slashblade", "model/util/durability.png");
    LoadingCache<ResourceLocation, WavefrontObject> cache = CacheBuilder.newBuilder().build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<ResourceLocation, WavefrontObject>(){

        public WavefrontObject load(ResourceLocation key) throws Exception {
            try {
                return new WavefrontObject(key);
            }
            catch (Exception e) {
                return BladeModelManager.this.defaultModel;
            }
        }
    }, (Executor)Executors.newCachedThreadPool()));

    public static BladeModelManager getInstance() {
        return SingletonHolder.instance;
    }

    private BladeModelManager() {
    }

    @SubscribeEvent
    public void reload(TextureStitchEvent.Pre event) {
        this.cache.invalidateAll();
        this.defaultModel = new WavefrontObject(resourceDefaultModel);
    }

    public WavefrontObject getModel(ResourceLocation loc) {
        if (loc != null) {
            try {
                return (WavefrontObject)this.cache.get((Object)loc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.defaultModel;
    }

    private static final class SingletonHolder {
        private static final BladeModelManager instance = new BladeModelManager();

        private SingletonHolder() {
        }
    }
}

