/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.model.obj;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import mods.flammpfeil.slashblade.client.renderer.model.obj.TextureCoordinate;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Vertex;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.util.LazyValue;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Face {
    public static boolean isSmoothShade = true;
    public static int lightmap = 15;
    public static Color col;
    private static final LazyValue<Matrix4f> defaultTransform;
    public static MatrixStack matrix;
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    public static void setLightMap(int value) {
        lightmap = value;
    }

    public static void resetLightMap() {
        lightmap = 15;
    }

    public static void setCol(Color col) {
        Face.col = col;
    }

    public static void resetCol() {
        col = Color.white;
    }

    public static void setMatrix(MatrixStack ms) {
        matrix = ms;
    }

    public static void resetMatrix() {
        matrix = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(IVertexBuilder tessellator) {
        this.addFaceForRender(tessellator, 5.0E-4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(IVertexBuilder tessellator, float textureOffset) {
        Matrix4f transform;
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (int i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u;
                averageV += this.textureCoordinates[i].v;
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        IVertexBuilder wr = tessellator;
        if (matrix != null) {
            MatrixStack.Entry me = matrix.func_227866_c_();
            transform = me.func_227870_a_();
        } else {
            transform = (Matrix4f)defaultTransform.func_179281_c();
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector3f vector3f;
            Vector4f vector4f = new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f);
            vector4f.func_229372_a_(transform);
            wr.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c());
            if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                float offsetU = textureOffset;
                float offsetV = textureOffset;
                if (this.textureCoordinates[i].u > averageU) {
                    offsetU = -offsetU;
                }
                if (this.textureCoordinates[i].v > averageV) {
                    offsetV = -offsetV;
                }
                wr.func_225583_a_(this.textureCoordinates[i].u + offsetU, this.textureCoordinates[i].v + offsetV);
            } else {
                wr.func_225583_a_(0.0f, 0.0f);
            }
            wr.func_227886_a_(lightmap);
            wr.func_225586_a_(col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha());
            if (isSmoothShade && this.vertexNormals != null) {
                Vertex normal = this.vertexNormals[i];
                Vec3d nol = new Vec3d((double)normal.x, (double)normal.y, (double)normal.z);
                vector3f = new Vector3f((float)nol.field_72450_a, (float)nol.field_72448_b, (float)nol.field_72449_c);
            } else {
                vector3f = new Vector3f(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
            }
            vector3f.func_229188_a_(new Matrix3f(transform));
            vector3f.func_229194_d_();
            wr.func_225584_a_(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            wr.func_181675_d();
        }
    }

    public Vertex calculateFaceNormal() {
        Vec3d v1 = new Vec3d((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
        Vec3d v2 = new Vec3d((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
        Vec3d normalVector = null;
        normalVector = v1.func_72431_c(v2).func_72432_b();
        return new Vertex((float)normalVector.field_72450_a, (float)normalVector.field_72448_b, (float)normalVector.field_72449_c);
    }

    static {
        defaultTransform = new LazyValue(() -> {
            Matrix4f m = new Matrix4f();
            m.func_226591_a_();
            return m;
        });
        matrix = null;
    }
}

