/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.util;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.function.Function;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.event.client.RenderOverrideEvent;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BladeRenderState
extends RenderState {
    private static final Color defaultColor;
    private static Color col;
    public static final int MAX_LIGHT = 0xF000E0;
    public static final VertexFormat POSITION_TEX;
    public static final RenderType BLADE_GLINT;
    protected static final RenderState.TransparencyState LIGHTNING_ADDITIVE_TRANSPARENCY;
    protected static final RenderState.TransparencyState LIGHTNING_REVERSE_TRANSPARENCY;

    public static void setCol(int rgba) {
        BladeRenderState.setCol(rgba, true);
    }

    public static void setCol(int rgb, boolean hasAlpha) {
        BladeRenderState.setCol(new Color(rgb, hasAlpha));
    }

    public static void setCol(Color value) {
        col = value;
    }

    public static void resetCol() {
        col = defaultColor;
    }

    public BladeRenderState(String p_i225973_1_, Runnable p_i225973_2_, Runnable p_i225973_3_) {
        super(p_i225973_1_, p_i225973_2_, p_i225973_3_);
    }

    public static void renderOverrided(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlend, true);
    }

    public static void renderOverridedColorWrite(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, BladeRenderState::getSlashBladeBlendColorWrite, true);
    }

    public static void renderOverridedLuminous(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, 0xF000E0, BladeRenderState::getSlashBladeBlendLuminous, false);
    }

    public static void renderOverridedReverseLuminous(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, 0xF000E0, BladeRenderState::getSlashBladeBlendReverseLuminous, false);
    }

    public static void renderOverrided(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Function<ResourceLocation, RenderType> getRenderType, boolean enableEffect) {
        RenderOverrideEvent event = RenderOverrideEvent.onRenderOverride(stack, model, target, texture, matrixStackIn, bufferIn);
        if (event.isCanceled()) {
            return;
        }
        RenderType rt = getRenderType.apply(event.getTexture());
        IVertexBuilder vb = bufferIn.getBuffer(rt);
        Face.setCol(col);
        Face.setLightMap(packedLightIn);
        Face.setMatrix(matrixStackIn);
        event.getModel().tessellateOnly(vb, event.getTarget());
        if (stack.func_77962_s()) {
            vb = bufferIn.getBuffer(BLADE_GLINT);
            event.getModel().tessellateOnly(vb, event.getTarget());
        }
        Face.resetMatrix();
        Face.resetLightMap();
        Face.resetCol();
        BladeRenderState.resetCol();
    }

    public static IVertexBuilder getBuffer(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, boolean glintIn) {
        return null;
    }

    public static RenderType getSlashBladeBlend(ResourceLocation p_228638_0_) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(p_228638_0_, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228723_a_(field_228520_l_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"slashblade_blend", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getSlashBladeBlendColorWrite(ResourceLocation p_228638_0_) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(p_228638_0_, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(RenderState.field_228533_y_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228723_a_(field_228520_l_).func_228727_a_(field_228496_F_).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"slashblade_blend", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getSlashBladeBlendLuminous(ResourceLocation p_228638_0_) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(p_228638_0_, true, false)).func_228726_a_(LIGHTNING_ADDITIVE_TRANSPARENCY).func_228716_a_(RenderState.field_228533_y_).func_228713_a_(field_228517_i_).func_228719_a_(RenderState.field_228528_t_).func_228723_a_(field_228520_l_).func_228727_a_(field_228496_F_).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"slashblade_blend_luminous", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static RenderType getSlashBladeBlendReverseLuminous(ResourceLocation p_228638_0_) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(p_228638_0_, true, false)).func_228726_a_(LIGHTNING_REVERSE_TRANSPARENCY).func_228716_a_(RenderState.field_228533_y_).func_228713_a_(field_228517_i_).func_228719_a_(RenderState.field_228528_t_).func_228723_a_(field_228520_l_).func_228727_a_(field_228496_F_).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"slashblade_blend_luminous", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    static {
        col = defaultColor = Color.white;
        POSITION_TEX = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181715_o).build());
        BLADE_GLINT = RenderType.func_228632_a_((String)"blade_glint", (VertexFormat)POSITION_TEX, (int)4, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(ItemRenderer.field_110798_h, true, false)).func_228727_a_(field_228496_F_).func_228714_a_(field_228491_A_).func_228715_a_(field_228493_C_).func_228726_a_(field_228513_e_).func_228725_a_(field_228527_s_).func_228728_a_(false));
        LIGHTNING_ADDITIVE_TRANSPARENCY = new RenderState.TransparencyState("lightning_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        LIGHTNING_REVERSE_TRANSPARENCY = new RenderState.TransparencyState("lightning_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.blendEquation((int)32779);
        }, () -> {
            RenderSystem.blendEquation((int)32774);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
    }
}

